/*
 * share/stat.h
 */


#ifndef share_stat_h
#define share_stat_h


#include<share/types.h>
#include<share/stdint.h>


#ifndef ASM_FILE


/* The stat structure. */
struct stat{
	dev_t     st_dev;		/* Device ID of device containing file. */
	ino_t     st_ino;		/* File serial number. */
	mode_t    st_mode;		/* Mode of file. */
	nlink_t   st_nlink;		/* Number of hard links to the file. */
	uid_t     st_uid;		/* User ID of file. */
	gid_t     st_gid;		/* Group ID of file. */
	off_t     st_size;		/* For regular files, the file size in bytes. */
	time_t    st_atime;		/* Time of last access. */
	time_t    st_mtime;		/* Time of last data modification. */
	time_t    st_ctime;		/* Time of last status change. */
	size_t    st_crtpos;	/* option,current file position. */
	uint32_t  st_blksize;	/* optimal blocksize for I/O */
};


#endif


#endif
