/*
 * Decompiled with CFR 0.152.
 */
package uiMonthSchedule;

import commonData.CommonStatic;
import configInfo.MonthPanelConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import uiMonthSchedule.ArrowPanel;
import uiMonthSchedule.ArrowPanelListener;
import uiMonthSchedule.VersionInfoPanel;
import uiMonthSchedule.VersionInfoPanelListener;

public class MonthScheduleHeader
extends JPanel {
    static final long serialVersionUID = 0L;
    private int startHH;
    private int endHH;
    private double xBase;
    private int dayHeader1;
    private int dayHeader2;

    public MonthScheduleHeader(MonthPanelConfig monthPanelConfig, String yyyy, String mm, int startHH, int endHH, double xBase, int dayHeader1, int dayHeader2, ArrowPanelListener apl, VersionInfoPanelListener vipl) {
        this.setLayout(null);
        this.startHH = monthPanelConfig.getStartHHint();
        this.endHH = monthPanelConfig.getEndHHint();
        this.xBase = monthPanelConfig.getHolizontai_ratio_double();
        this.dayHeader1 = dayHeader1;
        this.dayHeader2 = dayHeader2;
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(new LineBorder(CommonStatic.borderColor));
        this.add(new HeaderTitle(String.valueOf(yyyy) + "\u5e74" + mm + "\u6708", 60, 10));
        this.setPreferredSize(new Dimension(this.calcPreferrdWidth(), 35));
        ArrowPanel arrowNext = new ArrowPanel(apl, 1);
        arrowNext.setBounds(this.calcPreferrdWidth() / 2 + 50, 2, arrowNext.getPreferredSize().width, arrowNext.getPreferredSize().height);
        this.add(arrowNext);
        ArrowPanel arrowPrevious = new ArrowPanel(apl, -1);
        arrowPrevious.setBounds(this.calcPreferrdWidth() / 2 - 100, 2, arrowNext.getPreferredSize().width, arrowNext.getPreferredSize().height);
        this.add(arrowPrevious);
        VersionInfoPanel vip = new VersionInfoPanel(vipl);
        vip.setBounds(this.calcPreferrdWidth() - 50, 2, vip.getPreferredSize().width, vip.getPreferredSize().height);
        this.add(vip);
    }

    protected int calcPreferrdWidth() {
        return this.dayHeader1 + this.dayHeader2 + (int)(this.xBase * (double)(this.endHH - this.startHH) * 60.0);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float[] dist = new float[]{0.0f, 0.5f, 1.0f};
        Color startEndColor = new Color(200, 200, 230);
        Color[] colors = new Color[]{startEndColor, new Color(255, 255, 255), startEndColor};
        LinearGradientPaint grad = new LinearGradientPaint(0.0f, 10.0f, this.getPreferredSize().width, 10.0f, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g2.setPaint(grad);
        g2.fillRect(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
        this.initTimeLabel(g2, this.startHH, this.endHH, this.xBase, this.dayHeader1, this.dayHeader2);
    }

    private void initTimeLabel(Graphics g, int startHH, int endHH, double xBase, int dayHeader1, int dayHeader2) {
        int i = startHH;
        while (i < endHH) {
            g.setColor(new Color(80, 80, 90));
            g.setFont(new Font("ITALIC", 0, 10));
            g.drawString(Integer.toString(i), dayHeader1 + dayHeader2 + (int)(xBase * 60.0 * (double)(i - startHH)) - 4, 32);
            ++i;
        }
    }

    private class HeaderTitle
    extends JLabel {
        static final long serialVersionUID = 0L;
        private String title;

        HeaderTitle(String title, int width, int height) {
            this.setForeground(CommonStatic.standardChar);
            this.setFont(new Font("MS\u30b4\u30b7\u30c3\u30af", 1, 16));
            this.title = title;
            this.setBounds(MonthScheduleHeader.this.calcPreferrdWidth() / 2 - 50, 5, 100, 15);
            if (width - 2 < 20) {
                width = 22;
            }
            this.setOpaque(false);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.getForeground());
            g2.drawString(this.title, 0, 15);
        }
    }
}

