/*
 * Decompiled with CFR 0.152.
 */
package uiDetailSchedule;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uiDetailSchedule.DetailStatic;
import uiDetailSchedule.ItemInfo2Listener;

public class ItemInfo2
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 0L;
    private String title;
    private JComboBox comboBox;
    private ItemInfo2Listener ii2l;
    private String selectedValue;
    private ArrayList<String> valueList;
    int frameWidth;
    boolean editAble;

    public ItemInfo2(ItemInfo2Listener ii2l, String title, int frameWidth, boolean editAble, String selectedValue) {
        ArrayList<String> valueList = new ArrayList<String>();
        this.initItemSet(ii2l, title, selectedValue, valueList, frameWidth, editAble);
    }

    public ItemInfo2(ItemInfo2Listener ii2l, String title, int frameWidth, boolean editAble, String selectedValue, ArrayList<String> valueList) {
        this.initItemSet(ii2l, title, selectedValue, valueList, frameWidth, editAble);
    }

    private void initItemSet(ItemInfo2Listener ii2l, String title, String selectedValue, ArrayList<String> valueList, int frameWidth, boolean editAble) {
        this.setLayout(null);
        this.ii2l = ii2l;
        this.title = title;
        this.selectedValue = selectedValue;
        this.valueList = valueList;
        this.frameWidth = frameWidth;
        this.editAble = editAble;
        JLabel titleJLabel = new JLabel(title);
        titleJLabel.setFont(DetailStatic.defFont);
        titleJLabel.setBounds(4, 0, 36, 22);
        this.add(titleJLabel);
        this.comboBox = this.createJComboBox(title, selectedValue, valueList, frameWidth, editAble);
        this.add(this.comboBox);
    }

    private JComboBox createJComboBox(String title, String selectedValue, ArrayList<String> valueList, int frameWidth, boolean editAble) {
        JComboBox<String> comboBox = new JComboBox<String>();
        if (!selectedValue.equals("")) {
            comboBox.addItem("");
        }
        if (!valueList.contains(selectedValue)) {
            comboBox.addItem(selectedValue);
        }
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                comboBox.addItem(i.next());
            }
        }
        comboBox.setSelectedItem(selectedValue);
        comboBox.setFont(DetailStatic.defFont);
        comboBox.setBounds(36, 0, this.calcWidth(frameWidth), 22);
        comboBox.setEnabled(editAble);
        comboBox.setEditable(true);
        this.add(comboBox);
        if (title.equals("PRJ")) {
            comboBox.addActionListener(this);
        }
        return comboBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.ii2l.notifyComboBoxChanged(this.title, (String)this.comboBox.getSelectedItem());
    }

    public String getSelectedValue() {
        return (String)this.comboBox.getSelectedItem();
    }

    public void setResyse(int frameWidth) {
        this.frameWidth = frameWidth;
        this.comboBox = this.createJComboBox(this.title, this.selectedValue, this.valueList, frameWidth, this.editAble);
        this.add(this.comboBox);
    }

    private int calcWidth(int frameWidth) {
        if (frameWidth < 300) {
            return 256;
        }
        return frameWidth - 36 - 8;
    }

    public void printComboBoxItem() {
        System.out.println("==== for debug @ ItemInfo2");
        int i = 0;
        while (i < this.comboBox.getItemCount()) {
            System.out.println(this.comboBox.getItemAt(i));
            ++i;
        }
    }
}

