/*
 * Decompiled with CFR 0.152.
 */
package uiDetailSchedule;

import commonData.CommonStatic;
import commonData.LimitedNumeralDocument;
import commonData.WbsNo;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;
import uiCommon.UiJButton;
import uiCommon.UiJButtonListener;
import uiCommon.UiJLabel;
import uiCommon.UiJTextField;
import uiDetailSchedule.DetailScheduleJComboBox;
import uiDetailSchedule.DetailScheduleJComboBoxListener;
import uiDetailSchedule.DetailSchedulePanel5;
import uiDetailSchedule.DetailStatic;
import workMasterData.PhaseInfo2;
import workMasterData.PhaseInfoListMap;
import workMasterData.ProjectUnitList;
import workMasterData.WorkInfoListMap;

public class DetailSchedulePanel4Notes
extends DetailSchedulePanel5
implements DetailScheduleJComboBoxListener {
    static final long serialVersionUID = 1L;
    private UiJButton updateButton;
    private UiJButton deleteButton;
    private UiJButton toClipboardButton;
    private UiJButton importButton;
    private UiJLabel titleLabel;
    private UiJTextField title;
    private UiJLabel placeLabel;
    private UiJTextField place;
    private UiJLabel startLabel;
    private UiJTextField startYyyy;
    private UiJLabel startYyyyLabel;
    private UiJTextField startMm;
    private UiJLabel startMmLabel;
    private UiJTextField startDd;
    private UiJLabel startDdLabel;
    private UiJTextField startHH;
    private UiJLabel startHHLabel;
    private UiJTextField startMM;
    private UiJLabel startMMLabel;
    private UiJLabel endLabel;
    private UiJTextField endYyyy;
    private UiJLabel endYyyyLabel;
    private UiJTextField endMm;
    private UiJLabel endMmLabel;
    private UiJTextField endDd;
    private UiJLabel endDdLabel;
    private UiJTextField endHH;
    private UiJLabel endHHLabel;
    private UiJTextField endMM;
    private UiJLabel endMMLabel;
    private UiJLabel projectUnitLabel;
    private DetailScheduleJComboBox projectUnitBox;
    private UiJLabel assignmentLabel;
    private DetailScheduleJComboBox assignmentBox;
    private UiJLabel phaseFilterLabel;
    private DetailScheduleJComboBox phaseFilterBox;
    private UiJLabel projectCodeLabel;
    private JComboBox projectCodeBox;
    private UiJLabel phaseLabel;
    private JComboBox phaseBox;
    private UiJLabel workLabel;
    private JComboBox workBox;
    private UiJLabel progressLabel;
    private JSpinner progress;
    private UiJLabel progressLabel2;
    private JCheckBox closed;
    private UiJLabel closedLabel;
    private JCheckBox unFixed;
    private UiJLabel unFixedLabel;
    private JComboBox colorComboBox;
    private JTextArea commentTextArea;
    private JScrollPane commentJsp;
    private boolean editAble;
    private ProjectUnitList projectUnitList;
    private PhaseInfoListMap phaseInfoListMap;
    private WorkInfoListMap workInfoListMap;

    public DetailSchedulePanel4Notes(UiJButtonListener dsbl, boolean editAble, boolean importAble, ScheduleData sd, ProjectUnitList projectUnitList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap) {
        super(dsbl, editAble, importAble, sd, projectUnitList, phaseInfoListMap, workInfoListMap);
        this.editAble = editAble;
        this.projectUnitList = projectUnitList;
        this.phaseInfoListMap = phaseInfoListMap;
        this.workInfoListMap = workInfoListMap;
        this.initPanel(dsbl, editAble, importAble, sd, projectUnitList, phaseInfoListMap, workInfoListMap);
    }

    private void initPanel(UiJButtonListener dsbl, boolean editAble, boolean importAble, ScheduleData sd, ProjectUnitList projectUnitList, PhaseInfoListMap phaseInfoListMap, WorkInfoListMap workInfoListMap) {
        this.createUpdateButton(dsbl, editAble);
        this.createDeleteButton(dsbl, editAble);
        this.createToClipboardButton(dsbl, editAble);
        this.createImportButton(dsbl, importAble);
        this.createTitle(sd, editAble);
        this.createPlace(sd, editAble);
        this.createStartDateTime(sd, editAble);
        this.createEndDateTime(sd, editAble);
        this.createProjectUnit(sd.getProjectUnitName(), projectUnitList.getAllProjectUnitNameList(), editAble);
        this.createProjectCode(projectUnitList.getProjectUnit(sd.getProjectUnitName()).getProjectItems().getProjectCodeName(sd.getPrj_code()), projectUnitList.getProjectUnit(sd.getProjectUnitName()).getProjectItems().getAllProjectCodeNameList(), editAble);
        this.createAssignment(sd.getSelectedAssignment(), phaseInfoListMap.getAssignmentNameList(projectUnitList.getProjectUnit(sd.getProjectUnitName()).getPhaseListFiles().makePhaseFileNameList()), editAble);
        this.createPhaseFilter(sd.getSelectedPhaseFilter(), phaseInfoListMap.getUpperLevelPhaseNameList(projectUnitList.getProjectUnit(sd.getProjectUnitName()).getPhaseListFiles().makePhaseFileNameList(), 2), editAble);
        if (sd.getSelectedAssignment().equals("") || sd.getSelectedAssignment().equals("----\u62c5\u5f53\u3067\u7d5e\u308a\u8fbc\u3080----")) {
            this.createPhase(this.makePhaseName(sd.getWbsNo(), sd.getPhaseName()), phaseInfoListMap.getPhaseNameList(projectUnitList.getProjectUnit(sd.getProjectUnitName()).getPhaseListFiles().makePhaseFileNameList()), editAble);
        } else {
            ArrayList<String> assignmentList = new ArrayList<String>();
            assignmentList.add(sd.getSelectedAssignment());
            this.createPhase(this.makePhaseName(sd.getWbsNo(), sd.getPhaseName()), phaseInfoListMap.getPhaseNameList(projectUnitList.getProjectUnit(sd.getProjectUnitName()).getPhaseListFiles().makePhaseFileNameList(), assignmentList), editAble);
        }
        this.createWork(sd.getWork(), projectUnitList.getProjectUnit(sd.getProjectUnitName()).getWorkListFiles().makeWorkNameList(workInfoListMap), editAble);
        this.createProgress(sd.getProgressRatio(), editAble);
        this.createClosed(sd.isClosed(), editAble);
        this.createUnFixed(sd.isUnFixed(), editAble);
        this.createColorComboBox(editAble, CommonStatic.htmlScheduleColorList, sd.getColorInfo());
        this.createCommentTextArea(sd.getComment(), editAble);
        this.setLayoutManager();
    }

    private String makePhaseName(String wbsNo, String onlyPhaseName) {
        WbsNo wkWbsNo = new WbsNo();
        wkWbsNo.setWbsNo(wbsNo);
        return String.valueOf(wkWbsNo.getWbsNoWithConnection()) + onlyPhaseName;
    }

    private void setLayoutManager() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        hGroup.addGroup(layout.createSequentialGroup().addComponent(this.updateButton, 40, 100, Integer.MAX_VALUE).addComponent(this.deleteButton, 40, 100, Integer.MAX_VALUE).addComponent(this.toClipboardButton, 40, 100, Integer.MAX_VALUE).addComponent(this.importButton, 40, 100, Integer.MAX_VALUE));
        hGroup.addGroup(layout.createSequentialGroup().addGap(3).addGroup(layout.createParallelGroup().addComponent(this.titleLabel).addComponent(this.placeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.title).addComponent(this.place)).addGap(2));
        hGroup.addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGap(3).addComponent(this.startLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startYyyy, 40, 40, 40).addComponent(this.startYyyyLabel).addGap(2).addComponent(this.startMm, 20, 20, 20).addComponent(this.startMmLabel).addGap(2).addComponent(this.startDd, 20, 20, 20).addComponent(this.startDdLabel).addGap(2).addComponent(this.startHH, 20, 20, 20).addComponent(this.startHHLabel).addGap(2).addComponent(this.startMM, 20, 20, 20).addComponent(this.startMMLabel)).addGroup(layout.createSequentialGroup().addGap(3).addComponent(this.endLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endYyyy, 40, 40, 40).addComponent(this.endYyyyLabel).addGap(2).addComponent(this.endMm, 20, 20, 20).addComponent(this.endMmLabel).addGap(2).addComponent(this.endDd, 20, 20, 20).addComponent(this.endDdLabel).addGap(2).addComponent(this.endHH, 20, 20, 20).addComponent(this.endHHLabel).addGap(2).addComponent(this.endMM, 20, 20, 20).addComponent(this.endMMLabel))));
        hGroup.addGroup(layout.createSequentialGroup().addGap(3).addComponent(this.projectUnitLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectUnitBox).addGap(3).addComponent(this.projectCodeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectCodeBox));
        hGroup.addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGap(32).addComponent(this.phaseFilterBox).addComponent(this.assignmentBox)));
        hGroup.addGroup(layout.createSequentialGroup().addGap(3).addComponent(this.phaseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phaseBox));
        hGroup.addGroup(layout.createSequentialGroup().addGap(3).addComponent(this.workLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.workBox));
        hGroup.addGroup(layout.createSequentialGroup().addGap(3).addComponent(this.progressLabel).addComponent(this.progress, 40, 40, 40).addComponent(this.progressLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closed).addComponent(this.closedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unFixed).addComponent(this.unFixedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorComboBox));
        hGroup.addGroup(layout.createSequentialGroup().addComponent(this.commentJsp));
        layout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updateButton).addComponent(this.deleteButton).addComponent(this.toClipboardButton).addComponent(this.importButton));
        vGroup.addGap(2);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.title));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.placeLabel).addComponent(this.place));
        vGroup.addGap(2);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startLabel).addComponent(this.startYyyy).addComponent(this.startYyyyLabel).addComponent(this.startMm).addComponent(this.startMmLabel).addComponent(this.startDd).addComponent(this.startDdLabel).addComponent(this.startHH).addComponent(this.startHHLabel).addComponent(this.startMM).addComponent(this.startMMLabel));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endLabel).addComponent(this.endYyyy).addComponent(this.endYyyyLabel).addComponent(this.endMm).addComponent(this.endMmLabel).addComponent(this.endDd).addComponent(this.endDdLabel).addComponent(this.endHH).addComponent(this.endHHLabel).addComponent(this.endMM).addComponent(this.endMMLabel));
        vGroup.addGap(5);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectUnitLabel).addComponent(this.projectUnitBox).addComponent(this.projectCodeLabel).addComponent(this.projectCodeBox));
        vGroup.addGap(5);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phaseFilterBox).addComponent(this.assignmentBox));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phaseLabel).addComponent(this.phaseBox));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.workLabel).addComponent(this.workBox));
        vGroup.addGap(1);
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.progressLabel).addComponent(this.progress).addComponent(this.progressLabel2).addComponent(this.closed).addComponent(this.closedLabel).addComponent(this.unFixed).addComponent(this.unFixedLabel).addComponent(this.colorComboBox));
        vGroup.addGap(2);
        vGroup.addGroup(layout.createSequentialGroup()).addComponent(this.commentJsp);
        layout.setVerticalGroup(vGroup);
    }

    private void createUpdateButton(UiJButtonListener dsbl, boolean editAble) {
        this.updateButton = new UiJButton("\u66f4\u65b0", dsbl);
        if (!editAble) {
            this.updateButton.setEnabled(false);
        }
    }

    private void createDeleteButton(UiJButtonListener dsbl, boolean editAble) {
        this.deleteButton = new UiJButton("\u524a\u9664", dsbl);
        if (!editAble) {
            this.deleteButton.setEnabled(false);
        }
    }

    private void createToClipboardButton(UiJButtonListener dsbl, boolean editAble) {
        this.toClipboardButton = new UiJButton("\u30af\u30ea\u30c3\u30d7", dsbl);
        if (!editAble) {
            this.toClipboardButton.setEnabled(false);
        }
    }

    private void createImportButton(UiJButtonListener dsbl, boolean importAble) {
        this.importButton = new UiJButton("\u53d6\u8fbc", dsbl);
        if (!importAble) {
            this.importButton.setEnabled(false);
        }
    }

    private void createTitle(ScheduleData sd, boolean editAble) {
        this.titleLabel = new UiJLabel();
        this.titleLabel.setText("\u8868\u984c");
        this.title = new UiJTextField();
        this.title.setText(sd.getTitle());
        this.title.setEditable(editAble);
    }

    private void createPlace(ScheduleData sd, boolean editAble) {
        this.placeLabel = new UiJLabel();
        this.placeLabel.setText("\u5834\u6240");
        this.place = new UiJTextField();
        this.place.setText(sd.getPlace());
        this.place.setEditable(editAble);
    }

    private void createStartDateTime(ScheduleData sd, boolean editAble) {
        this.startLabel = new UiJLabel();
        this.startLabel.setText("\u958b\u59cb");
        this.startYyyy = new UiJTextField();
        this.startYyyy.setDocument(new LimitedNumeralDocument(4));
        this.startYyyy.enableInputMethods(false);
        this.startYyyy.setEditable(editAble);
        this.startYyyy.setText(sd.getS_date().getYyyy());
        this.startYyyyLabel = new UiJLabel();
        this.startYyyyLabel.setText("\u5e74");
        this.startMm = new UiJTextField();
        this.startMm.setDocument(new LimitedNumeralDocument(2));
        this.startMm.enableInputMethods(false);
        this.startMm.setEditable(editAble);
        this.startMm.setText(sd.getS_date().getMm());
        this.startMmLabel = new UiJLabel();
        this.startMmLabel.setText("\u6708");
        this.startDd = new UiJTextField();
        this.startDd.setDocument(new LimitedNumeralDocument(2));
        this.startDd.enableInputMethods(false);
        this.startDd.setEditable(editAble);
        this.startDd.setText(sd.getS_date().getDd());
        this.startDdLabel = new UiJLabel();
        this.startDdLabel.setText("\u65e5");
        this.startHH = new UiJTextField();
        this.startHH.setDocument(new LimitedNumeralDocument(2));
        this.startHH.enableInputMethods(false);
        this.startHH.setEditable(editAble);
        this.startHH.setText(sd.getS_date().getHH());
        this.startHHLabel = new UiJLabel();
        this.startHHLabel.setText("\u6642");
        this.startMM = new UiJTextField();
        this.startMM.setDocument(new LimitedNumeralDocument(2));
        this.startMM.enableInputMethods(false);
        this.startMM.setEditable(editAble);
        this.startMM.setText(sd.getS_date().getMM());
        this.startMMLabel = new UiJLabel();
        this.startMMLabel.setText("\u5206");
    }

    private void createEndDateTime(ScheduleData sd, boolean editAble) {
        this.endLabel = new UiJLabel();
        this.endLabel.setText("\u7d42\u4e86");
        this.endYyyy = new UiJTextField();
        this.endYyyy.setDocument(new LimitedNumeralDocument(4));
        this.endYyyy.enableInputMethods(false);
        this.endYyyy.setEditable(editAble);
        this.endYyyy.setText(sd.getE_date().getYyyy());
        this.endYyyyLabel = new UiJLabel();
        this.endYyyyLabel.setText("\u5e74");
        this.endMm = new UiJTextField();
        this.endMm.setDocument(new LimitedNumeralDocument(2));
        this.endMm.enableInputMethods(false);
        this.endMm.setEditable(editAble);
        this.endMm.setText(sd.getE_date().getMm());
        this.endMmLabel = new UiJLabel();
        this.endMmLabel.setText("\u6708");
        this.endDd = new UiJTextField();
        this.endDd.setDocument(new LimitedNumeralDocument(2));
        this.endDd.enableInputMethods(false);
        this.endDd.setEditable(editAble);
        this.endDd.setText(sd.getE_date().getDd());
        this.endDdLabel = new UiJLabel();
        this.endDdLabel.setText("\u65e5");
        this.endHH = new UiJTextField();
        this.endHH.setDocument(new LimitedNumeralDocument(2));
        this.endHH.enableInputMethods(false);
        this.endHH.setEditable(editAble);
        this.endHH.setText(sd.getE_date().getHH());
        this.endHHLabel = new UiJLabel();
        this.endHHLabel.setText("\u6642");
        this.endMM = new UiJTextField();
        this.endMM.setDocument(new LimitedNumeralDocument(2));
        this.endMM.enableInputMethods(false);
        this.endMM.setEditable(editAble);
        this.endMM.setText(sd.getE_date().getMM());
        this.endMMLabel = new UiJLabel();
        this.endMMLabel.setText("\u5206");
    }

    private void createProjectUnit(String selectedValue, ArrayList<String> valueList, boolean editAble) {
        this.projectUnitLabel = new UiJLabel();
        this.projectUnitLabel.setText("\u6848\u4ef6");
        this.projectUnitBox = new DetailScheduleJComboBox("\u6848\u4ef6", this);
        this.projectUnitBox.setFont(DetailStatic.defFont);
        if (!selectedValue.equals("")) {
            this.projectUnitBox.addItem("");
        }
        if (!valueList.contains(selectedValue)) {
            this.projectUnitBox.addItem(selectedValue);
        }
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.projectUnitBox.addItem(i.next());
            }
        }
        this.projectUnitBox.setSelectedItem(selectedValue);
        this.projectUnitBox.setEnabled(editAble);
        this.projectUnitBox.addActionListenerReq();
    }

    private void createAssignment(String selectedValue, ArrayList<String> valueList, boolean editAble) {
        this.assignmentLabel = new UiJLabel();
        this.assignmentLabel.setText("\u62c5\u5f53(\u7d5e\u8fbc)");
        this.assignmentBox = new DetailScheduleJComboBox("\u62c5\u5f53", this);
        this.assignmentBox.setFont(DetailStatic.defFont);
        if (!selectedValue.equals("")) {
            this.assignmentBox.addItem("");
        } else {
            this.assignmentBox.addItem("----\u62c5\u5f53\u3067\u7d5e\u308a\u8fbc\u3080----");
        }
        if (!valueList.contains(selectedValue)) {
            this.assignmentBox.addItem(selectedValue);
        }
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.assignmentBox.addItem(i.next());
            }
        }
        if (selectedValue.equals("")) {
            this.assignmentBox.setSelectedItem("----\u62c5\u5f53\u3067\u7d5e\u308a\u8fbc\u3080----");
        } else {
            this.assignmentBox.setSelectedItem(selectedValue);
        }
        this.assignmentBox.setEnabled(editAble);
        this.assignmentBox.setEditable(true);
        this.assignmentBox.addActionListenerReq();
    }

    private void createPhaseFilter(String selectedValue, ArrayList<String> valueList, boolean editAble) {
        this.phaseFilterLabel = new UiJLabel();
        this.phaseFilterLabel.setText("\u5de5\u7a0b\u3067\u7d5e\u308a\u8fbc\u3080");
        this.phaseFilterBox = new DetailScheduleJComboBox("\u5de5\u7a0b\u7d5e\u8fbc", this);
        this.phaseFilterBox.setFont(DetailStatic.defFont);
        if (!selectedValue.equals("")) {
            this.phaseFilterBox.addItem("");
        } else {
            this.phaseFilterBox.addItem("----\u5de5\u7a0b\u3067\u7d5e\u308a\u8fbc\u3080----");
        }
        if (!valueList.contains(selectedValue)) {
            this.phaseFilterBox.addItem(selectedValue);
        }
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.phaseFilterBox.addItem(i.next());
            }
        }
        if (selectedValue.equals("")) {
            this.phaseFilterBox.setSelectedItem("----\u5de5\u7a0b\u3067\u7d5e\u308a\u8fbc\u3080----");
        } else {
            this.phaseFilterBox.setSelectedItem(selectedValue);
        }
        this.phaseFilterBox.setEnabled(editAble);
        this.phaseFilterBox.setEditable(true);
        this.phaseFilterBox.addActionListenerReq();
    }

    private void createProjectCode(String selectedValue, ArrayList<String> valueList, boolean editAble) {
        this.projectCodeLabel = new UiJLabel();
        this.projectCodeLabel.setText("PRJ");
        this.projectCodeBox = new JComboBox();
        this.projectCodeBox.setFont(DetailStatic.defFont);
        if (!selectedValue.equals("")) {
            this.projectCodeBox.addItem("");
        }
        if (!valueList.contains(selectedValue)) {
            this.projectCodeBox.addItem(selectedValue);
        }
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.projectCodeBox.addItem(i.next());
            }
        }
        this.projectCodeBox.setSelectedItem(selectedValue);
        this.projectCodeBox.setEnabled(editAble);
    }

    private void createPhase(String selectedValue, ArrayList<String> valueList, boolean editAble) {
        this.phaseLabel = new UiJLabel();
        this.phaseLabel.setText("\u5de5\u7a0b");
        this.phaseBox = new JComboBox();
        this.phaseBox.setFont(DetailStatic.defFont);
        if (!selectedValue.equals("")) {
            this.phaseBox.addItem("");
        }
        if (!valueList.contains(selectedValue)) {
            this.phaseBox.addItem(selectedValue);
        }
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.phaseBox.addItem(i.next());
            }
        }
        this.phaseBox.setSelectedItem(selectedValue);
        this.phaseBox.setEnabled(editAble);
    }

    private void createWork(String selectedValue, ArrayList<String> valueList, boolean editAble) {
        this.workLabel = new UiJLabel();
        this.workLabel.setText("\u4f5c\u696d");
        this.workBox = new JComboBox();
        this.workBox.setFont(DetailStatic.defFont);
        if (!selectedValue.equals("")) {
            this.workBox.addItem("");
        }
        if (!valueList.contains(selectedValue)) {
            this.workBox.addItem(selectedValue);
        }
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.workBox.addItem(i.next());
            }
        }
        this.workBox.setSelectedItem(selectedValue);
        this.workBox.setEnabled(editAble);
    }

    private void createProgress(int progressRatio, boolean editAble) {
        this.progressLabel = new UiJLabel();
        this.progressLabel.setText("\u5de5\u7a0b\u9032\u6357\u7387");
        this.progress = new JSpinner(new SpinnerNumberModel(progressRatio, 0, 100, 10));
        this.progress.enableInputMethods(false);
        this.progress.setEnabled(editAble);
        this.progressLabel2 = new UiJLabel();
        this.progressLabel2.setText("%");
    }

    private void createClosed(boolean closed, boolean editAble) {
        this.closed = new JCheckBox();
        this.closed.setSelected(closed);
        this.closed.setEnabled(editAble);
        this.closedLabel = new UiJLabel();
        this.closedLabel.setText("\u975e\u516c\u958b");
    }

    private void createUnFixed(boolean unFixed, boolean editAble) {
        this.unFixed = new JCheckBox();
        this.unFixed.setSelected(unFixed);
        this.unFixed.setEnabled(editAble);
        this.unFixedLabel = new UiJLabel();
        this.unFixedLabel.setText("\u4eee\u306e\u4e88\u5b9a");
    }

    private void createColorComboBox(boolean editAble, String[] dataList, int colorNo) {
        this.colorComboBox = new DetailScheduleJComboBox("Color", this);
        this.colorComboBox.setEnabled(editAble);
        this.colorComboBox.setModel(this.makeComboBoxModel(dataList));
        this.colorComboBox.setSelectedIndex(colorNo);
        this.colorComboBox.setPreferredSize(new Dimension(40, 22));
    }

    private DefaultComboBoxModel makeComboBoxModel(String[] dataList) {
        DefaultComboBoxModel<StringBuffer> comboBoxModel = new DefaultComboBoxModel<StringBuffer>();
        int i = 0;
        while (i < dataList.length) {
            StringBuffer sb = new StringBuffer();
            sb.append("<html><font color=\"");
            sb.append(dataList[i]);
            sb.append("\">\u25a0</font></html>");
            comboBoxModel.addElement(sb);
            ++i;
        }
        return comboBoxModel;
    }

    private void createCommentTextArea(String comment, boolean editAble) {
        this.commentTextArea = new JTextArea(comment);
        this.commentTextArea.setEditable(editAble);
        this.commentJsp = new JScrollPane(this.commentTextArea);
        this.commentJsp.setVerticalScrollBarPolicy(22);
        this.commentJsp.setHorizontalScrollBarPolicy(32);
        this.commentJsp.setPreferredSize(new Dimension(200, 100));
    }

    @Override
    public void notifyComboBoxChanged(String title, String selectedItem) {
        if (title.equals("\u6848\u4ef6")) {
            this.rebuildComboboxWhenProjectUnit(selectedItem);
        }
        if (title.equals("\u62c5\u5f53")) {
            this.rebuildComboboxWhenAssignment(selectedItem);
        }
        if (title.equals("\u5de5\u7a0b\u7d5e\u8fbc")) {
            this.rebuildComboboxWhenUpperPhase(selectedItem);
        }
    }

    private void rebuildComboboxWhenProjectUnit(String selectedItem) {
        if (this.projectCodeBox != null) {
            this.remove(this.projectCodeBox);
            String wkProjectCodeName = (String)this.projectCodeBox.getSelectedItem();
            this.createProjectCode(wkProjectCodeName, this.projectUnitList.getProjectUnit(selectedItem).getProjectItems().getAllProjectCodeNameList(), this.editAble);
        }
        if (this.phaseFilterBox != null) {
            this.remove(this.phaseFilterBox);
            String wkPhaseName = (String)this.phaseFilterBox.getSelectedItem();
            this.createPhaseFilter(wkPhaseName, this.phaseInfoListMap.getUpperLevelPhaseNameList(this.projectUnitList.getProjectUnit(selectedItem).getPhaseListFiles().makePhaseFileNameList(), 2), this.editAble);
        }
        if (this.assignmentBox != null) {
            this.remove(this.assignmentBox);
            String wkAssignmentName = (String)this.assignmentBox.getSelectedItem();
            this.createAssignment(wkAssignmentName, this.phaseInfoListMap.getAssignmentNameList(this.projectUnitList.getProjectUnit(selectedItem).getPhaseListFiles().makePhaseFileNameList()), this.editAble);
        }
        if (this.phaseBox != null) {
            this.remove(this.phaseBox);
            String wkPhase = (String)this.phaseBox.getSelectedItem();
            String wkAssign = (String)this.assignmentBox.getSelectedItem();
            if (wkAssign.equals("") || wkAssign.equals("----\u62c5\u5f53\u3067\u7d5e\u308a\u8fbc\u3080----")) {
                this.createPhase(wkPhase, this.phaseInfoListMap.getPhaseNameList(this.projectUnitList.getProjectUnit(selectedItem).getPhaseListFiles().makePhaseFileNameList()), this.editAble);
            } else {
                ArrayList<String> wkList = new ArrayList<String>();
                wkList.add(wkAssign);
                this.createPhase(wkPhase, this.phaseInfoListMap.getPhaseNameList(this.projectUnitList.getProjectUnit(selectedItem).getPhaseListFiles().makePhaseFileNameList(), wkList), this.editAble);
            }
        }
        if (this.workBox != null) {
            this.remove(this.workBox);
            String wkWork = (String)this.workBox.getSelectedItem();
            this.createWork(wkWork, this.projectUnitList.getProjectUnit(selectedItem).getWorkListFiles().makeWorkNameList(this.workInfoListMap), this.editAble);
        }
        if (this.phaseBox != null && this.workBox != null) {
            this.setLayoutManager();
        }
    }

    private void rebuildComboboxWhenAssignment(String selectedItem) {
        if (this.phaseBox != null) {
            this.remove(this.phaseBox);
            String wkPhase = (String)this.phaseBox.getSelectedItem();
            String wkProjectUnitName = (String)this.projectUnitBox.getSelectedItem();
            ArrayList<String> wkList = new ArrayList<String>();
            if (selectedItem.equals("") || selectedItem.equals("----\u62c5\u5f53\u3067\u7d5e\u308a\u8fbc\u3080----")) {
                this.createPhase(wkPhase, this.phaseInfoListMap.getPhaseNameList(this.projectUnitList.getProjectUnit(wkProjectUnitName).getPhaseListFiles().makePhaseFileNameList()), this.editAble);
            } else {
                wkList.add(selectedItem);
                this.createPhase(wkPhase, this.phaseInfoListMap.getPhaseNameList(this.projectUnitList.getProjectUnit(wkProjectUnitName).getPhaseListFiles().makePhaseFileNameList(), wkList), this.editAble);
            }
        }
        if (this.phaseBox != null && this.workBox != null) {
            this.setLayoutManager();
        }
    }

    private void rebuildComboboxWhenUpperPhase(String selectedItem) {
        if (this.phaseBox != null) {
            this.remove(this.phaseBox);
            String wkPhase = (String)this.phaseBox.getSelectedItem();
            String wkProjectUnitName = (String)this.projectUnitBox.getSelectedItem();
            if (selectedItem.equals("") || selectedItem.equals("----\u5de5\u7a0b\u3067\u7d5e\u308a\u8fbc\u3080----")) {
                this.createPhase(wkPhase, this.phaseInfoListMap.getPhaseNameList(this.projectUnitList.getProjectUnit(wkProjectUnitName).getPhaseListFiles().makePhaseFileNameList()), this.editAble);
            } else {
                this.createPhase(wkPhase, this.phaseInfoListMap.getPhaseNameListByUpperPhase(this.projectUnitList.getProjectUnit(wkProjectUnitName).getPhaseListFiles().makePhaseFileNameList(), selectedItem), this.editAble);
            }
        }
        if (this.phaseBox != null && this.workBox != null) {
            this.setLayoutManager();
        }
    }

    @Override
    public ScheduleData getScheduleData() {
        ScheduleData sd = new ScheduleData();
        sd.setTitle(this.title.getText());
        sd.setPlace(this.place.getText());
        DateInfo startDi = new DateInfo(this.startYyyy.getText(), this.startMm.getText(), this.startDd.getText(), this.startHH.getText(), this.startMM.getText());
        sd.setS_date(startDi);
        DateInfo endDi = new DateInfo(this.endYyyy.getText(), this.endMm.getText(), this.endDd.getText(), this.endHH.getText(), this.endMM.getText());
        sd.setE_date(endDi);
        sd.setProjectUnitName((String)this.projectUnitBox.getSelectedItem());
        sd.setPrj_code(this.extractProjectCode((String)this.projectCodeBox.getSelectedItem()));
        sd.setProjectName(this.extractProjectName((String)this.projectCodeBox.getSelectedItem()));
        sd.setSelectedPhaseFilter((String)this.phaseFilterBox.getSelectedItem());
        sd.setSelectedAssignment((String)this.assignmentBox.getSelectedItem());
        sd.setPhaseName(this.extractOnlyPhaseName((String)this.phaseBox.getSelectedItem()));
        sd.setWbsNo(this.extractWbsNo((String)this.phaseBox.getSelectedItem()));
        sd.setWork((String)this.workBox.getSelectedItem());
        sd.setProgressRatio((Integer)this.progress.getValue());
        sd.setClosed(this.closed.isSelected());
        sd.setUnFixed(this.unFixed.isSelected());
        sd.setColorInfo(this.colorComboBox.getSelectedIndex());
        sd.setComment(this.commentTextArea.getText());
        sd.setUniquieId(this.getUniquieIdByPhaseName((String)this.phaseBox.getSelectedItem(), (String)this.projectUnitBox.getSelectedItem()));
        return sd;
    }

    private String extractOnlyPhaseName(String phaseName) {
        Pattern patternValue = Pattern.compile("([[0-9]+.]+)(.+)");
        Matcher matcherValue = patternValue.matcher(phaseName);
        if (matcherValue.find() && matcherValue.group(2) != null) {
            return matcherValue.group(2);
        }
        return phaseName;
    }

    private String extractWbsNo(String phaseName) {
        WbsNo wbsNo = new WbsNo();
        wbsNo.setWbsNo(phaseName);
        return wbsNo.getWbsNoByString();
    }

    private String extractProjectCode(String projectCodeName) {
        String[] wkStr = projectCodeName.split(" ");
        return wkStr[0];
    }

    private String extractProjectName(String projectCodeName) {
        String[] wkStr = projectCodeName.split(" ");
        if (wkStr.length > 1) {
            String result = "";
            int i = 1;
            while (i < wkStr.length) {
                result = String.valueOf(result) + wkStr[i];
                result = String.valueOf(result) + " ";
                ++i;
            }
            return result;
        }
        return "";
    }

    private int getUniquieIdByPhaseName(String targetPhaseName, String projectUnitName) {
        for (String phaseFileName : this.projectUnitList.getProjectUnit(projectUnitName).getPhaseListFiles().makePhaseFileNameList()) {
            for (PhaseInfo2 phaseInfo : this.phaseInfoListMap.getPhaseInfoList(phaseFileName).getPhaseInfoList()) {
                if (!phaseInfo.getPhaseName().equals(targetPhaseName)) continue;
                return phaseInfo.getUniqueid();
            }
        }
        return -1;
    }
}

