/*
 * Decompiled with CFR 0.152.
 */
package uiDetailSchedule;

import commonData.CommonStatic;
import commonData.LimitedNumeralDocument;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import uiDetailSchedule.DetailStatic;

public class DetailSchedulePanel3
extends JPanel {
    static final long serialVersionUID = 0L;
    private JLabel progressRatioLabel;
    private JTextField progressRatioJText;
    private JLabel progressRatioLabel2;
    private JCheckBox closedCheckBox;
    private JLabel closedCheckBoxLabel;
    private JCheckBox unFixedCheckBox;
    private JLabel unFixedCheckBoxLabel;
    private JComboBox colorComboBox;
    private JScrollPane commentAreaJsp;
    private JTextArea commentAreaJta;

    public DetailSchedulePanel3(int frameWidth, boolean editAble, boolean closed, boolean unFixed, int progressRatio, int colorNo, String comment) {
        this.initDetailSchedulePanel3(frameWidth, editAble, closed, unFixed, progressRatio, colorNo, comment);
    }

    private void initDetailSchedulePanel3(int frameWidth, boolean editAble, boolean closed, boolean unFixed, int progressRatio, int colorNo, String comment) {
        this.setLayout(null);
        this.progressRatioLabel = this.makeProgressRatioLabel();
        this.progressRatioJText = this.makeProgressRatio(editAble, progressRatio);
        this.progressRatioLabel2 = new JLabel("%");
        this.closedCheckBox = this.makeClosedCheckBox(editAble, closed);
        this.closedCheckBoxLabel = this.makeClosedCheckBoxLabel();
        this.unFixedCheckBox = this.makeUnFixedCheckBox(editAble, unFixed);
        this.unFixedCheckBoxLabel = this.makeUnFixedCheckBoxLabel();
        this.colorComboBox = this.makeColorComboBox(editAble, CommonStatic.htmlScheduleColorList, colorNo);
        this.commentAreaJsp = this.makeCommentArea(editAble, comment, frameWidth);
        this.setRectangle();
        this.setPreferredSize(new Dimension(frameWidth, this.closedCheckBoxLabel.getHeight() + this.commentAreaJsp.getHeight()));
        this.add(this.progressRatioLabel);
        this.add(this.progressRatioJText);
        this.add(this.progressRatioLabel2);
        this.add(this.closedCheckBox);
        this.add(this.closedCheckBoxLabel);
        this.add(this.unFixedCheckBox);
        this.add(this.unFixedCheckBoxLabel);
        this.add(this.colorComboBox);
        this.add(this.commentAreaJsp);
    }

    private void setRectangle() {
        int x = 3;
        this.progressRatioLabel.setBounds(x, 0, this.progressRatioLabel.getPreferredSize().width, this.progressRatioLabel.getPreferredSize().height);
        this.progressRatioJText.setBounds(x += this.progressRatioLabel.getPreferredSize().width, 0, this.progressRatioJText.getPreferredSize().width, this.progressRatioJText.getPreferredSize().height);
        this.progressRatioLabel2.setBounds(x += this.progressRatioJText.getPreferredSize().width, 0, 10, this.progressRatioLabel.getPreferredSize().height);
        this.closedCheckBox.setBounds(x += this.progressRatioLabel2.getSize().width, 0, this.closedCheckBox.getPreferredSize().width, this.closedCheckBox.getPreferredSize().height);
        this.closedCheckBoxLabel.setBounds(x += this.closedCheckBox.getPreferredSize().width, 0, this.closedCheckBoxLabel.getPreferredSize().width, this.closedCheckBoxLabel.getPreferredSize().height);
        this.unFixedCheckBox.setBounds(x += this.closedCheckBoxLabel.getPreferredSize().width, 0, this.unFixedCheckBox.getPreferredSize().width, this.unFixedCheckBox.getPreferredSize().height);
        this.unFixedCheckBoxLabel.setBounds(x += this.unFixedCheckBox.getPreferredSize().width, 0, this.unFixedCheckBoxLabel.getPreferredSize().width, this.unFixedCheckBoxLabel.getPreferredSize().height);
        this.colorComboBox.setBounds(x += this.unFixedCheckBoxLabel.getPreferredSize().width, 0, this.colorComboBox.getPreferredSize().width, this.colorComboBox.getPreferredSize().height);
        this.commentAreaJsp.setBounds(0, 22, this.commentAreaJsp.getPreferredSize().width, this.commentAreaJsp.getPreferredSize().height);
    }

    public boolean getClosedCheckBox() {
        return this.closedCheckBox.isSelected();
    }

    public boolean isUnFixed() {
        return this.unFixedCheckBox.isSelected();
    }

    public int getColorInfo() {
        return this.colorComboBox.getSelectedIndex();
    }

    public String getComment() {
        return this.commentAreaJta.getText();
    }

    private JCheckBox makeClosedCheckBox(boolean editAble, boolean closed) {
        JCheckBox closedCheckBox = new JCheckBox();
        closedCheckBox.setSelected(closed);
        closedCheckBox.setEnabled(editAble);
        closedCheckBox.setPreferredSize(new Dimension(17, 22));
        closedCheckBox.setSize(closedCheckBox.getPreferredSize());
        return closedCheckBox;
    }

    private JLabel makeClosedCheckBoxLabel() {
        JLabel closedCheckBoxLabel = new JLabel();
        closedCheckBoxLabel.setFont(new Font("MS\u30b4\u30b7\u30c3\u30af", 0, 10));
        closedCheckBoxLabel.setText("\u975e\u516c\u958b");
        closedCheckBoxLabel.setPreferredSize(new Dimension(35, 22));
        return closedCheckBoxLabel;
    }

    private JCheckBox makeUnFixedCheckBox(boolean editAble, boolean unFixed) {
        JCheckBox unFixedCheckBox = new JCheckBox();
        unFixedCheckBox.setSelected(unFixed);
        unFixedCheckBox.setEnabled(editAble);
        unFixedCheckBox.setPreferredSize(new Dimension(17, 22));
        unFixedCheckBox.setSize(unFixedCheckBox.getPreferredSize());
        return unFixedCheckBox;
    }

    private JLabel makeUnFixedCheckBoxLabel() {
        JLabel unFixedCheckBoxLabel = new JLabel();
        unFixedCheckBoxLabel.setFont(new Font("MS\u30b4\u30b7\u30c3\u30af", 0, 10));
        unFixedCheckBoxLabel.setText("\u672a\u5b9a\u306e\u4e88\u5b9a");
        unFixedCheckBoxLabel.setPreferredSize(new Dimension(58, 22));
        return unFixedCheckBoxLabel;
    }

    private JTextField makeProgressRatio(boolean editAble, int progressRatio) {
        String aaa = Integer.toString(progressRatio);
        JTextField textField = new JTextField();
        textField.setFont(DetailStatic.defFont);
        textField.setDocument(new LimitedNumeralDocument(3));
        textField.setText(Integer.toString(progressRatio));
        textField.enableInputMethods(false);
        textField.setEditable(editAble);
        textField.setPreferredSize(new Dimension(28, 22));
        return textField;
    }

    private JLabel makeProgressRatioLabel() {
        JLabel label = new JLabel();
        label.setFont(new Font("MS\u30b4\u30b7\u30c3\u30af", 0, 10));
        label.setText("\u5de5\u7a0b\u9032\u6357\u7387");
        label.setPreferredSize(new Dimension(52, 22));
        return label;
    }

    private JComboBox makeColorComboBox(boolean editAble, String[] dataList, int colorNo) {
        JComboBox colorComboBox = new JComboBox();
        colorComboBox.setEnabled(editAble);
        colorComboBox.setModel(this.makeComboBoxModel(dataList));
        colorComboBox.setSelectedIndex(colorNo);
        colorComboBox.setPreferredSize(new Dimension(40, 22));
        return colorComboBox;
    }

    private DefaultComboBoxModel makeComboBoxModel(String[] dataList) {
        DefaultComboBoxModel<StringBuffer> comboBoxModel = new DefaultComboBoxModel<StringBuffer>();
        int i = 0;
        while (i < dataList.length) {
            StringBuffer sb = new StringBuffer();
            sb.append("<html><font color=\"");
            sb.append(dataList[i]);
            sb.append("\">\u25a0</font></html>");
            comboBoxModel.addElement(sb);
            ++i;
        }
        return comboBoxModel;
    }

    private JScrollPane makeCommentArea(boolean editAble, String comment, int frameWidth) {
        JTextArea jta = new JTextArea(comment);
        jta.setEditable(editAble);
        this.commentAreaJta = jta;
        JScrollPane jsp = new JScrollPane(jta);
        jsp.setVerticalScrollBarPolicy(22);
        jsp.setHorizontalScrollBarPolicy(32);
        jsp.setPreferredSize(new Dimension(frameWidth - 7, 146));
        return jsp;
    }

    public String getProgressRatioStr() {
        return this.progressRatioJText.getText();
    }
}

