/*
 * Decompiled with CFR 0.152.
 */
package uiDataConvert;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import uiCommon.UiJLabel;
import uiDetailSchedule.DetailStatic;
import workMasterData.ProjectItem;
import workMasterData.ProjectUnitList;

public class DataConvertProjectCodePanel
extends JPanel {
    static final long serialVersionUID = 0L;
    private ProjectUnitList projectUnitList;
    private UiJLabel beforeProjectCodeLabel;
    private JComboBox beforeProjectUnitBox;
    private UiJLabel afterProjectCodeLabel;
    private JComboBox afterProjectUnitBox;

    public DataConvertProjectCodePanel(ProjectUnitList projectUnitList) {
        this.projectUnitList = projectUnitList;
        this.initDeliveryStatementPanel(projectUnitList);
    }

    private void initDeliveryStatementPanel(ProjectUnitList projectUnitList) {
        this.setBorder(BorderFactory.createTitledBorder(null, "\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u30b3\u30fc\u30c9", 1, 0));
        this.beforeProjectCodeLabel = new UiJLabel();
        this.beforeProjectCodeLabel.setText("\u5909\u66f4\u524d");
        this.createBeforeProjectCodeBox(projectUnitList.getAllProjectCodeNameList());
        this.afterProjectCodeLabel = new UiJLabel();
        this.afterProjectCodeLabel.setText("\u5909\u66f4\u5f8c");
        this.createAfterProjectCodeBox(projectUnitList.getAllProjectCodeNameList());
        this.setLayoutManager();
    }

    private void setLayoutManager() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        hGroup.addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.beforeProjectCodeLabel).addGap(2).addComponent(this.beforeProjectUnitBox)).addGroup(layout.createSequentialGroup().addComponent(this.afterProjectCodeLabel).addGap(2).addComponent(this.afterProjectUnitBox)));
        layout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup();
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.beforeProjectCodeLabel).addComponent(this.beforeProjectUnitBox));
        vGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.afterProjectCodeLabel).addComponent(this.afterProjectUnitBox));
        layout.setVerticalGroup(vGroup);
    }

    private void createBeforeProjectCodeBox(ArrayList<String> valueList) {
        this.beforeProjectUnitBox = new JComboBox();
        this.beforeProjectUnitBox.setFont(DetailStatic.defFont);
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.beforeProjectUnitBox.addItem(i.next());
            }
        }
        this.beforeProjectUnitBox.setEditable(true);
    }

    private void createAfterProjectCodeBox(ArrayList<String> valueList) {
        this.afterProjectUnitBox = new JComboBox();
        this.afterProjectUnitBox.setFont(DetailStatic.defFont);
        if (valueList != null) {
            Iterator<String> i = valueList.iterator();
            while (i.hasNext()) {
                this.afterProjectUnitBox.addItem(i.next());
            }
        }
        this.afterProjectUnitBox.setEditable(true);
    }

    public ProjectItem getBeforeProjectCode() {
        ProjectItem projectItem = new ProjectItem();
        projectItem.setCode(this.extractProjectCode((String)this.beforeProjectUnitBox.getSelectedItem()));
        projectItem.setName(this.projectUnitList.getProjectName(projectItem.getCode()));
        return projectItem;
    }

    public ProjectItem getAfterProjectCode() {
        ProjectItem projectItem = new ProjectItem();
        projectItem.setCode(this.extractProjectCode((String)this.afterProjectUnitBox.getSelectedItem()));
        projectItem.setName(this.projectUnitList.getProjectName(projectItem.getCode()));
        return projectItem;
    }

    private String extractProjectCode(String projectCodeName) {
        String[] wkStr = projectCodeName.split(" ");
        return wkStr[0];
    }
}

