/*
 * Decompiled with CFR 0.152.
 */
package uiControlPanel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import javax.swing.JButton;

public class VectorButton
extends JButton
implements MouseListener {
    static final long serialVersionUID = 0L;
    protected boolean pressed = false;

    public VectorButton() {
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressed = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pressed = false;
    }

    @Override
    public Dimension getPreferredSize() {
        String text = this.getText();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        float scale = 1.6666666f * this.getFont().getSize2D();
        int w = fm.stringWidth(text);
        int h = fm.getHeight();
        return new Dimension(w += (int)(scale * 1.4f), h += (int)(scale * 0.3f));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        float scale = 1.6666666f * this.getFont().getSize2D();
        this.drawLiquidButton(this.getForeground(), this.getWidth(), this.getHeight(), this.getText(), scale, g2);
    }

    protected void drawLiquidButton(Color base, int width, int height, String text, float scale, Graphics2D g2) {
        int inset = (int)(scale * 0.04f);
        int w = width - inset * 2 - 1;
        int h = height - (int)(scale * 0.1f) - 1;
        g2.translate(inset, 0);
        this.drawDropShadow(w, h, scale, g2);
        if (this.pressed) {
            g2.translate(0.0, 0.04f * scale);
        }
        this.drawButtonBody(w, h, scale, base, g2);
        this.drawText(w, h, scale, text, g2);
        this.drawHighlight(w, h, scale, base, g2);
        this.drawBorder(w, h, scale, g2);
        if (this.pressed) {
            g2.translate(0.0, 0.04f * scale);
        }
        g2.translate(-inset, 0);
    }

    protected void drawDropShadow(int w, int h, float scale, Graphics2D g2) {
        g2.setColor(new Color(0, 0, 0, 50));
        VectorButton.fillRountRect(g2, -0.04f * scale, 0.02f * scale, (float)w + 0.08f * scale, (float)h + 0.08f * scale, scale * 1.04f, scale * 1.04f);
        g2.setColor(new Color(0, 0, 0, 100));
        VectorButton.fillRountRect(g2, 0.0f, 0.06f * scale, w, h, scale, scale);
    }

    protected void drawButtonBody(int w, int h, float scale, Color base, Graphics2D g2) {
        Color grad_top = base.brighter();
        Color grad_bot = base.darker();
        GradientPaint bg = new GradientPaint(new Point(0, 0), grad_top, new Point(0, h), grad_bot);
        g2.setPaint(bg);
        VectorButton.fillRountRect(g2, 0.0f * scale, 0.0f * scale, w, h, 1.0f * scale, 1.0f * scale);
        Color inner = base.brighter();
        inner = VectorButton.alphaColor(inner, 75);
        g2.setColor(inner);
        VectorButton.fillRountRect(g2, scale * 0.4f, scale * 0.4f, (float)w - scale * 0.8f, (float)h - scale * 0.5f, scale * 0.6f, scale * 0.4f);
    }

    protected void drawText(int w, int h, float scale, String text, Graphics2D g2) {
        int fw = g2.getFontMetrics().stringWidth(text);
        int fh = g2.getFontMetrics().getAscent() - g2.getFontMetrics().getDescent();
        int textx = (w - fw) / 2;
        int texty = h / 2 + fh / 2;
        g2.setColor(new Color(0, 0, 0, 70));
        g2.drawString(text, (int)((float)textx + scale * 0.04f), (int)((float)texty + scale * 0.04f));
        g2.setColor(Color.black);
        g2.drawString(text, textx, texty);
    }

    protected void drawHighlight(int w, int h, float scale, Color base, Graphics2D g2) {
        GradientPaint highlight = new GradientPaint(new Point2D.Float(scale * 0.2f, scale * 0.2f), new Color(255, 255, 255, 175), new Point2D.Float(scale * 0.2f, scale * 0.1f), new Color(255, 255, 255, 0));
        g2.setPaint(highlight);
        VectorButton.fillRountRect(g2, scale * 0.2f, scale * 0.1f, (float)w - scale * 0.4f, scale * 0.4f, scale * 0.8f, scale * 0.4f);
        VectorButton.drawRoundRect(g2, scale * 0.2f, scale * 0.1f, (float)w - scale * 0.4f, scale * 0.4f, scale * 0.8f, scale * 0.4f);
    }

    protected void drawBorder(int w, int h, float scale, Graphics2D g2) {
        g2.setColor(new Color(0, 0, 0, 150));
        VectorButton.drawRoundRect(g2, scale * 0.0f, scale * 0.0f, w, h, scale, scale);
    }

    protected static Color alphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    protected static void fillRountRect(Graphics2D g2, float x, float y, float w, float h, float ax, float ay) {
        g2.fillRoundRect((int)x, (int)y, (int)w, (int)h, (int)ax, (int)ay);
    }

    protected static void drawRoundRect(Graphics2D g2, float x, float y, float w, float h, float ax, float ay) {
        g2.drawRoundRect((int)x, (int)y, (int)w, (int)h, (int)ax, (int)ay);
    }
}

