/*
 * Decompiled with CFR 0.152.
 */
package sessionCommon;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class J2gCookieStore2
implements CookieStore {
    private Map<String, Map<String, Map<String, HttpCookie>>> cookie_tbl = new HashMap<String, Map<String, Map<String, HttpCookie>>>();
    private ReentrantLock lock = new ReentrantLock(false);

    @Override
    public void add(URI uri, HttpCookie cookie) {
        Map<Object, Object> path_map = null;
        Map<String, HttpCookie> cookie_map = null;
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        String domain_name = "";
        domain_name = cookie.getDomain() == null ? uri.getHost() : cookie.getDomain();
        this.lock.lock();
        path_map = this.cookie_tbl.get(domain_name) == null ? new HashMap() : this.cookie_tbl.get(domain_name);
        cookie_map = path_map.get(cookie.getPath()) == null ? new HashMap<String, HttpCookie>() : (Map)path_map.get(cookie.getPath());
        cookie_map.put(cookie.getName(), cookie);
        path_map.put(cookie.getPath(), cookie_map);
        this.cookie_tbl.put(domain_name, path_map);
        this.lock.unlock();
    }

    @Override
    public List<HttpCookie> get(URI uri) {
        ArrayList<HttpCookie> resp_list = new ArrayList<HttpCookie>();
        Map<String, Map<String, HttpCookie>> path_map = null;
        Map<String, HttpCookie> cookie_map = null;
        this.lock.lock();
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        for (String domain_name : this.cookie_tbl.keySet()) {
            if (!this.domain_check(uri.getHost(), domain_name)) continue;
            path_map = this.cookie_tbl.get(domain_name);
            for (String cookie_path : path_map.keySet()) {
                if (!this.path_check(uri.getPath(), cookie_path)) continue;
                cookie_map = path_map.get(cookie_path);
                Iterator<String> j = cookie_map.keySet().iterator();
                while (j.hasNext()) {
                    resp_list.add(cookie_map.get(j.next()));
                }
            }
        }
        this.lock.unlock();
        return resp_list;
    }

    @Override
    public List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> resp_list = new ArrayList<HttpCookie>();
        Map<String, Map<String, HttpCookie>> path_map = null;
        Map<String, HttpCookie> cookie_map = null;
        this.lock.lock();
        Iterator<String> domain = this.cookie_tbl.keySet().iterator();
        while (domain.hasNext()) {
            path_map = this.cookie_tbl.get(domain.next());
            Iterator<String> path = path_map.keySet().iterator();
            while (path.hasNext()) {
                cookie_map = path_map.get(path.next());
                Iterator<String> name = cookie_map.keySet().iterator();
                while (name.hasNext()) {
                    resp_list.add(cookie_map.get(name.next()));
                }
            }
        }
        this.lock.unlock();
        return resp_list;
    }

    @Override
    public List<URI> getURIs() {
        ArrayList<URI> resp_list = new ArrayList<URI>();
        this.lock.lock();
        Iterator<String> i = this.cookie_tbl.keySet().iterator();
        while (i.hasNext()) {
            try {
                URI uri = new URI(i.next());
                resp_list.add(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lock.unlock();
        return resp_list;
    }

    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        Map<String, Map<String, HttpCookie>> path_map = null;
        Map<String, HttpCookie> cookie_map = null;
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        this.lock.lock();
        Iterator<String> domain = this.cookie_tbl.keySet().iterator();
        while (domain.hasNext()) {
            path_map = this.cookie_tbl.get(domain.next());
            Iterator<String> path = path_map.keySet().iterator();
            while (path.hasNext()) {
                cookie_map = path_map.get(path.next());
                Iterator<String> name = cookie_map.keySet().iterator();
                while (name.hasNext()) {
                    if (!cookie.getName().equals(name)) continue;
                    cookie_map.remove(name);
                }
                path_map.put(path.next(), cookie_map);
            }
            this.cookie_tbl.put(domain.next(), path_map);
        }
        this.lock.unlock();
        return true;
    }

    @Override
    public boolean removeAll() {
        this.cookie_tbl.clear();
        return true;
    }

    private boolean path_check(String uri_path, String cookie_path) {
        return uri_path.matches("^" + cookie_path + "+.*");
    }

    private boolean domain_check(String host_name, String domain_name) {
        return host_name.matches(".*" + domain_name + "$");
    }
}

