/*
 * Decompiled with CFR 0.152.
 */
package sessionCommon;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sessionCommon.J2gCookieStore2;

public class J2gCookieManager
extends CookieHandler {
    private CookiePolicy policyCallback;
    private CookieStore cookieJar = null;

    public J2gCookieManager() {
        this(null, null);
    }

    public J2gCookieManager(CookieStore cookiestore, CookiePolicy cookiepolicy) {
        this.policyCallback = cookiepolicy != null ? cookiepolicy : CookiePolicy.ACCEPT_ORIGINAL_SERVER;
        this.cookieJar = cookiestore == null ? new J2gCookieStore2() : cookiestore;
    }

    public void setCookiePolicy(CookiePolicy cookiepolicy) {
        if (cookiepolicy != null) {
            this.policyCallback = cookiepolicy;
        }
    }

    public CookieStore getCookieStore() {
        return this.cookieJar;
    }

    public Map get(URI uri, Map map) throws IOException {
        if (uri == null || map == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        HashMap<String, Object> hashmap = new HashMap<String, Object>();
        if (this.cookieJar == null) {
            return Collections.unmodifiableMap(hashmap);
        }
        ArrayList<HttpCookie> arraylist = new ArrayList<HttpCookie>();
        if (this.cookieJar.get(uri) == null) {
            return Collections.unmodifiableMap(hashmap);
        }
        for (HttpCookie httpcookie : this.cookieJar.get(uri)) {
            if (!this.pathMatches(uri.getPath(), httpcookie.getPath())) continue;
            arraylist.add(httpcookie);
        }
        List obj = this.sortByPath(arraylist);
        hashmap.put("Cookie", obj);
        return Collections.unmodifiableMap(hashmap);
    }

    public void put(URI uri, Map map) throws IOException {
        if (uri == null || map == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (this.cookieJar == null) {
            return;
        }
        for (String s : map.keySet()) {
            if (s == null || !s.equalsIgnoreCase("Set-Cookie2") && !s.equalsIgnoreCase("Set-Cookie")) continue;
            for (String s1 : (List)map.get(s)) {
                try {
                    List<HttpCookie> list = HttpCookie.parse(s1);
                    for (HttpCookie httpcookie : list) {
                        if (!this.shouldAcceptInternal(uri, httpcookie)) continue;
                        this.cookieJar.add(uri, httpcookie);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean shouldAcceptInternal(URI uri, HttpCookie httpcookie) {
        try {
            return this.policyCallback.shouldAccept(uri, httpcookie);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean pathMatches(String s, String s1) {
        if (s == s1) {
            return true;
        }
        if (s == null || s1 == null) {
            return false;
        }
        return s.startsWith(s1);
    }

    private List sortByPath(List list) {
        Collections.sort(list, new CookiePathComparator());
        ArrayList<String> arraylist = new ArrayList<String>();
        for (HttpCookie httpcookie : list) {
            if (list.indexOf(httpcookie) == 0 && httpcookie.getVersion() > 0) {
                arraylist.add("$Version=\"1\"");
            }
            arraylist.add(httpcookie.toString());
        }
        return arraylist;
    }

    static class CookiePathComparator
    implements Comparator {
        private int compare2(HttpCookie httpcookie, HttpCookie httpcookie1) {
            if (httpcookie == httpcookie1) {
                return 0;
            }
            if (httpcookie == null) {
                return -1;
            }
            if (httpcookie1 == null) {
                return 1;
            }
            if (!httpcookie.getName().equals(httpcookie1.getName())) {
                return 0;
            }
            if (httpcookie.getPath().startsWith(httpcookie1.getPath())) {
                return -1;
            }
            return !httpcookie1.getPath().startsWith(httpcookie.getPath()) ? 0 : 1;
        }

        public int compare(Object obj, Object obj1) {
            return this.compare2((HttpCookie)obj, (HttpCookie)obj1);
        }

        CookiePathComparator() {
        }
    }
}

