/*
 * Decompiled with CFR 0.152.
 */
package sessionCommon;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sessionCommon.FormAnalyser;
import sessionCommon.J2gCookieManager;
import sessionCommon.J2gCookiePolicy;
import sessionCommon.J2gCookieStore2;
import sessionCommon.PostParamData;

public class HttpHeaderInfo {
    private J2gCookieManager cookieManager;
    private HashMap<String, String> hiddenMap;
    private FormAnalyser formAnalyser;

    public HttpHeaderInfo() {
        J2gCookieStore2 cookie_store = new J2gCookieStore2();
        J2gCookiePolicy cookie_policy = new J2gCookiePolicy();
        this.cookieManager = new J2gCookieManager(cookie_store, cookie_policy);
        this.hiddenMap = new HashMap();
        this.formAnalyser = new FormAnalyser();
    }

    public J2gCookieManager getCookieManager() {
        return this.cookieManager;
    }

    public void setCookieManager(J2gCookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public FormAnalyser getFormAnalyser() {
        return this.formAnalyser;
    }

    public void setFormAnalyser(FormAnalyser htmlAnalyser) {
        this.formAnalyser = htmlAnalyser;
    }

    private void setHiddenMap(BufferedReader urlInput) {
        String input_line = "";
        try {
            while ((input_line = urlInput.readLine()) != null) {
                this.setHiddenMap(input_line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setHiddenMap(String inputLine) {
        Pattern pattern = Pattern.compile(".*< *input +type *= *\"hidden\" +name *= *\"(.*)\" +value *= *\"(.*)\"");
        Matcher matcher = pattern.matcher(inputLine);
        while (matcher.find()) {
            String hiddenName = "";
            String hiddenValue = "";
            if (matcher.group(1) != null) {
                hiddenName = matcher.group(1);
            }
            if (matcher.group(2) != null) {
                hiddenValue = matcher.group(2);
            }
            if (hiddenName.equals("employeeName")) {
                String string = "";
            }
            this.hiddenMap.put(hiddenName, hiddenValue);
        }
    }

    private ArrayList<PostParamData> careatePostParamData() {
        ArrayList<PostParamData> paramList = new ArrayList<PostParamData>();
        Set<String> keySet = this.hiddenMap.keySet();
        for (String paramName : keySet) {
            paramList.add(new PostParamData(paramName, this.hiddenMap.get(paramName)));
        }
        return paramList;
    }
}

