/*
 * Decompiled with CFR 0.152.
 */
package sessionCommon;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sessionCommon.FormInfoHolder;
import sessionCommon.InputInfoHolder;
import sessionCommon.PostParamData;
import sessionCommon.SelectInfoHolder;

public class FormAnalyser {
    private ArrayList<FormInfoHolder> formInfoList = new ArrayList();
    private ArrayList<HashMap<String, InputInfoHolder>> inputInfoList = new ArrayList();
    private ArrayList<HashMap<String, InputInfoHolder>> textareaList = new ArrayList();
    private ArrayList<HashMap<String, SelectInfoHolder>> selectInfoList = new ArrayList();
    private int formCount = 0;
    private FormInfoHolder currentFormInfo = null;
    private SelectInfoHolder tmpSelectInfo = null;

    public ArrayList<HashMap<String, InputInfoHolder>> getInputInfoList() {
        return this.inputInfoList;
    }

    public void setInputInfoList(ArrayList<HashMap<String, InputInfoHolder>> inputInfoList) {
        this.inputInfoList = inputInfoList;
    }

    public ArrayList<HashMap<String, InputInfoHolder>> getTextareaList() {
        return this.textareaList;
    }

    public void setTextareaList(ArrayList<HashMap<String, InputInfoHolder>> textareaList) {
        this.textareaList = textareaList;
    }

    public ArrayList<HashMap<String, SelectInfoHolder>> getSelectInfoList() {
        return this.selectInfoList;
    }

    public void setSelectInfoList(ArrayList<HashMap<String, SelectInfoHolder>> selectInfoList) {
        this.selectInfoList = selectInfoList;
    }

    public void setFormData(BufferedReader urlInput) {
        String inputStr = "";
        try {
            while ((inputStr = urlInput.readLine()) != null) {
                this.setFormData(inputStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFormData(String inputStr) {
        FormInfoHolder formInfo = null;
        formInfo = this.searchFormTag(inputStr);
        if (formInfo != null) {
            this.formInfoList.add(this.formCount, formInfo);
            this.inputInfoList.add(this.formCount, new HashMap());
            this.textareaList.add(this.formCount, new HashMap());
            this.selectInfoList.add(this.formCount, new HashMap());
            this.currentFormInfo = formInfo;
            ++this.formCount;
        }
        ArrayList<InputInfoHolder> wkInputInfoList = null;
        wkInputInfoList = this.searchInputTag(inputStr);
        for (InputInfoHolder inputInfo : wkInputInfoList) {
            this.inputInfoList.get(this.formCount - 1).put(inputInfo.name, inputInfo);
        }
        InputInfoHolder inputInfo = null;
        inputInfo = this.searchTextareaTag(inputStr);
        if (inputInfo != null && this.currentFormInfo != null) {
            this.textareaList.get(this.formCount - 1).put(inputInfo.name, inputInfo);
        }
        SelectInfoHolder selectInfo = null;
        selectInfo = this.searchSelectTag(inputStr);
        if (selectInfo != null) {
            if (this.currentFormInfo != null) {
                this.selectInfoList.get(this.formCount - 1).put(selectInfo.name, selectInfo);
            }
            return;
        }
    }

    public HashMap<String, String> getHiddenMap(int formNo) {
        HashMap<String, String> hiddenMap = new HashMap<String, String>();
        if (this.inputInfoList.size() < formNo + 1) {
            System.err.println("caution@getHiddenMap " + this.getClass().getName() + " formNo is " + formNo);
            this.printAll();
            StackTraceElement[] ste = new Throwable().getStackTrace();
            System.err.println("illigal argument " + this.getClass().getName());
            int i = 0;
            while (i < ste.length) {
                System.err.println("\t" + ste[i].getClassName() + "(" + ste[i].getLineNumber() + ")");
                ++i;
            }
            return hiddenMap;
        }
        Collection<InputInfoHolder> collectionInputInfo = this.inputInfoList.get(formNo).values();
        for (InputInfoHolder inputInfo : collectionInputInfo) {
            if (!inputInfo.type.equals("hidden")) continue;
            hiddenMap.put(inputInfo.name, inputInfo.value);
        }
        return hiddenMap;
    }

    public ArrayList<PostParamData> getHiddenPostParamList(int formNo) {
        ArrayList<PostParamData> paramList = new ArrayList<PostParamData>();
        HashMap<String, String> tmpMap = this.getHiddenMap(formNo);
        Set<String> keySet = tmpMap.keySet();
        for (String paramName : keySet) {
            paramList.add(new PostParamData(paramName, tmpMap.get(paramName)));
        }
        return paramList;
    }

    public void allClear() {
        this.formInfoList = new ArrayList();
        this.inputInfoList = new ArrayList();
        this.selectInfoList = new ArrayList();
        this.formCount = 0;
        this.currentFormInfo = null;
        this.tmpSelectInfo = null;
    }

    public SelectInfoHolder getSelectInfo(int formNo, String selectName) {
        Collection<SelectInfoHolder> sic = this.selectInfoList.get(formNo).values();
        for (SelectInfoHolder si : sic) {
            if (!selectName.equals(si.name)) continue;
            return si;
        }
        return null;
    }

    public InputInfoHolder getInputInfo(int formNo, String inputName) {
        Collection<InputInfoHolder> iic = this.inputInfoList.get(formNo).values();
        for (InputInfoHolder iih : iic) {
            if (!inputName.equals(iih.name)) continue;
            return iih;
        }
        return null;
    }

    public InputInfoHolder getTextareaInfo(int formNo, String inputName) {
        Collection<InputInfoHolder> iic = this.textareaList.get(formNo).values();
        for (InputInfoHolder iih : iic) {
            if (!inputName.equals(iih.name)) continue;
            return iih;
        }
        return null;
    }

    public void printAll() {
        int formNo = 0;
        System.out.println("================");
        System.out.println("    printAll");
        System.out.println("================");
        for (FormInfoHolder formInfo : this.formInfoList) {
            System.out.println("================");
            System.out.println("formInfoList[" + formNo + "] form Name:" + formInfo.name + ", method:" + formInfo.method + ", action:" + formInfo.action);
            System.out.println("================");
            int inputCount = 0;
            Set<String> inputNameList = this.inputInfoList.get(formNo).keySet();
            System.out.println("----inputInfoList[" + formNo + "]");
            for (String inputName : inputNameList) {
                System.out.println("   [" + inputCount + "] input name:" + this.inputInfoList.get((int)formNo).get((Object)inputName).name + ", type:" + this.inputInfoList.get((int)formNo).get((Object)inputName).type + ", value:" + this.inputInfoList.get((int)formNo).get((Object)inputName).value);
                ++inputCount;
            }
            int textareaCount = 0;
            Set<String> textareaNameList = this.textareaList.get(formNo).keySet();
            System.out.println("----textareaList[" + formNo + "]");
            for (String textareaName : textareaNameList) {
                System.out.println("   [" + textareaCount + "] textarea name:" + this.textareaList.get((int)formNo).get((Object)textareaName).name + ", type:" + this.textareaList.get((int)formNo).get((Object)textareaName).type + ", value:" + this.textareaList.get((int)formNo).get((Object)textareaName).value);
                ++textareaCount;
            }
            Collection<SelectInfoHolder> selectCollection = this.selectInfoList.get(formNo).values();
            System.out.println("----selectInfoList[" + formNo + "]");
            Iterator<SelectInfoHolder> k = selectCollection.iterator();
            while (k.hasNext()) {
                k.next().printAll();
            }
            ++formNo;
        }
    }

    private FormInfoHolder searchFormTag(String inputStr) {
        FormInfoHolder formInfo = new FormInfoHolder();
        Pattern pattern = Pattern.compile("< *form[^>]+>");
        Matcher matcher = pattern.matcher(inputStr);
        if (matcher.find()) {
            Pattern patternAction;
            Matcher matcherAction;
            Pattern patternMethod;
            Matcher matcherMethod;
            Pattern patternName = Pattern.compile("< *form[^>]+name *= *\"([^\"]*)\"[^>]*>");
            Matcher matcherName = patternName.matcher(inputStr);
            if (matcherName.find() && matcherName.group(1) != null) {
                formInfo.name = matcherName.group(1);
            }
            if ((matcherMethod = (patternMethod = Pattern.compile("< *form[^>]+method *= *\"([^\"]*)\"[^>]*>")).matcher(inputStr)).find() && matcherMethod.group(1) != null) {
                formInfo.method = matcherMethod.group(1);
            }
            if ((matcherAction = (patternAction = Pattern.compile("< *form[^>]+action *= *\"([^\"]*)\"[^>]*>")).matcher(inputStr)).find() && matcherAction.group(1) != null) {
                formInfo.action = matcherAction.group(1);
            }
        } else {
            formInfo = null;
        }
        return formInfo;
    }

    private ArrayList<InputInfoHolder> searchInputTag(String inputStr) {
        ArrayList<InputInfoHolder> inputInfoList = new ArrayList<InputInfoHolder>();
        Pattern easyPattern = Pattern.compile("input");
        Matcher easyMatcher = easyPattern.matcher(inputStr);
        if (!easyMatcher.find()) {
            return inputInfoList;
        }
        Pattern pattern = Pattern.compile("< *input +[^>]+>");
        Matcher matcher = pattern.matcher(inputStr);
        while (matcher.find()) {
            Pattern patternValue;
            Matcher matcherValue;
            Pattern patternName;
            Matcher matcherName;
            String wkStr = inputStr.substring(matcher.start(), matcher.end());
            InputInfoHolder inputInfo = new InputInfoHolder();
            Pattern patternType = Pattern.compile("[^>]*< *input +[^>]*type *= *\"([^\"]*)\"");
            Matcher matcherType = patternType.matcher(wkStr);
            if (matcherType.find() && matcherType.group(1) != null) {
                inputInfo.type = matcherType.group(1);
            }
            if ((matcherName = (patternName = Pattern.compile("[^>]*< *input +[^>]*name *= *\"([^\"]*)\"")).matcher(wkStr)).find() && matcherName.group(1) != null) {
                inputInfo.name = matcherName.group(1);
            }
            if ((matcherValue = (patternValue = Pattern.compile("[^>]*< *input +[^>]*value *= *\"([^\"]*)\"")).matcher(wkStr)).find() && matcherValue.group(1) != null) {
                inputInfo.value = matcherValue.group(1);
            }
            inputInfoList.add(inputInfo);
        }
        return inputInfoList;
    }

    private InputInfoHolder searchInputTag2(String inputStr) {
        InputInfoHolder inputInfo = new InputInfoHolder();
        Pattern pattern = Pattern.compile(".*< *input .*name.*>");
        Matcher matcher = pattern.matcher(inputStr);
        if (matcher.find()) {
            Pattern patternValue;
            Matcher matcherValue;
            Pattern patternName;
            Matcher matcherName;
            Pattern patternType = Pattern.compile(".*type *= *\"([^\"]*)\"");
            Matcher matcherType = patternType.matcher(inputStr);
            if (matcherType.find() && matcherType.group(1) != null) {
                inputInfo.type = matcherType.group(1);
            }
            if ((matcherName = (patternName = Pattern.compile(".*name *= *\"([^\"]*)\"")).matcher(inputStr)).find() && matcherName.group(1) != null) {
                inputInfo.name = matcherName.group(1);
            }
            if ((matcherValue = (patternValue = Pattern.compile(".*value *= *\"([^\"]*)\"")).matcher(inputStr)).find() && matcherValue.group(1) != null) {
                inputInfo.value = matcherValue.group(1);
            }
        } else {
            inputInfo = null;
        }
        return inputInfo;
    }

    private SelectInfoHolder searchSelectTag(String inputStr) {
        Pattern patternName;
        Matcher matcherName;
        Pattern pattern = Pattern.compile("< *select +name *= *\"([^\"]*)\".*>");
        Matcher matcher = pattern.matcher(inputStr);
        if (matcher.find() && (matcherName = (patternName = Pattern.compile(".*name *= *\"([^\"]*)\"")).matcher(inputStr)).find() && matcherName.group(1) != null) {
            this.tmpSelectInfo = new SelectInfoHolder();
            this.tmpSelectInfo.name = matcherName.group(1);
        }
        if (this.tmpSelectInfo != null) {
            Pattern patternEnd;
            Matcher matcherEnd;
            Pattern patternValue = Pattern.compile(".*< *option +value *= *\"([^\"]*)\".*>(.*)</option>.*");
            Matcher matcherValue = patternValue.matcher(inputStr);
            if (matcherValue.find()) {
                Pattern patternSelected;
                Matcher matcherSelected;
                String value = "";
                String writtenValue = "";
                if (matcherValue.group(1) != null) {
                    value = matcherValue.group(1);
                    if (matcherValue.group(2) != null) {
                        writtenValue = matcherValue.group(2);
                        this.tmpSelectInfo.setValueList(value, writtenValue);
                    } else {
                        this.tmpSelectInfo.setValueList(value, "");
                    }
                }
                if ((matcherSelected = (patternSelected = Pattern.compile("selected *= *\"selected\"")).matcher(inputStr)).find()) {
                    this.tmpSelectInfo.selected.value = value;
                    this.tmpSelectInfo.selected.writtenValue = writtenValue;
                }
            }
            if ((matcherEnd = (patternEnd = Pattern.compile("</select>")).matcher(inputStr)).find()) {
                SelectInfoHolder result = this.tmpSelectInfo;
                this.tmpSelectInfo = null;
                return result;
            }
        }
        return null;
    }

    private InputInfoHolder searchTextareaTag(String inputStr) {
        Pattern pattern = Pattern.compile("< *textarea name *= *\"([^\"]*)\".+>(.+)</textarea>");
        Matcher matcher = pattern.matcher(inputStr);
        if (matcher.find() && matcher.group(1) != null) {
            InputInfoHolder inputInfo = new InputInfoHolder();
            inputInfo.name = matcher.group(1);
            inputInfo.type = "textarea";
            if (matcher.group(2) != null) {
                inputInfo.value = matcher.group(2);
            }
            return inputInfo;
        }
        return null;
    }
}

