/*
 * Decompiled with CFR 0.152.
 */
package mtroom;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import mtroom.DateInfoUtil;
import mtroom.EmptyRoom;
import mtroom.ReservationList;
import org.apache.commons.lang.time.DateUtils;
import schema.DateInfoType;

public class EmptyRoomsFactory {
    private static final EmptyRoomsFactory instance = new EmptyRoomsFactory();
    private int start_hour = 9;
    private int start_min = 0;
    private int end_hour = 18;
    private int end_min = 0;
    public static final int DURATION_MINUTE = 30;

    private EmptyRoomsFactory() {
    }

    public static EmptyRoomsFactory getInstance() {
        return instance;
    }

    public void configure(Date starttime, Date endtime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(starttime);
        this.start_hour = cal.get(11);
        this.start_min = cal.get(12);
        cal.setTime(endtime);
        this.end_hour = cal.get(11);
        this.end_min = cal.get(12);
    }

    public void configure(int start_hour, int start_min, int end_hour, int end_min) {
        this.start_hour = start_hour;
        this.start_min = start_min;
        this.end_hour = end_hour;
        this.end_min = end_min;
    }

    public List<EmptyRoom> create(Calendar date_from, Calendar date_to, int minutes, Collection<String> room_names, ReservationList reserved) {
        Logger log = Logger.getLogger(this.getClass().getName());
        ArrayList<EmptyRoom> list = new ArrayList<EmptyRoom>();
        Date datetime_from = this.setTime(date_from.getTime(), this.start_hour, this.start_min, 0, 0);
        Date datetime_to = this.setTime(date_to.getTime(), this.end_hour, this.end_min, 0, 0);
        datetime_to = DateUtils.addSeconds(datetime_to, -30);
        int empty_need_times = minutes / 30;
        log.finest("before loop...");
        log.finest("datetime_from=" + datetime_from);
        for (String room : room_names) {
            Date datetime = (Date)datetime_from.clone();
            int empty_times = 0;
            Date empty_start_time = null;
            while (datetime.compareTo(datetime_to) <= 0) {
                if (!reserved.isReserved(room, datetime)) {
                    log.finest("empty room found :" + room + " " + DateFormat.getInstance().format(datetime));
                    if (empty_times++ == 0) {
                        empty_start_time = (Date)datetime.clone();
                        log.finest("remember start time=" + DateFormat.getInstance().format(datetime));
                    }
                } else {
                    if (empty_times >= empty_need_times) {
                        EmptyRoom emp = new EmptyRoom();
                        emp.setDate(this.getCalendar(datetime));
                        emp.setRoomName(room);
                        emp.setTimeFrom(this.getCalendar(empty_start_time));
                        emp.setTimeTo(this.getCalendar(datetime));
                        list.add(emp);
                        log.finest("Added " + emp);
                    }
                    empty_times = 0;
                }
                if (DateUtils.getFragmentInMinutes(datetime, 5) >= (long)(this.end_hour * 60 + this.end_min)) {
                    datetime = this.setTime(datetime, this.start_hour, this.start_min, 0, 0);
                    datetime = DateUtils.addDays(datetime, 1);
                    empty_times = 0;
                    log.finest("skip and forward datetime to " + DateFormat.getInstance().format(datetime));
                    continue;
                }
                datetime = DateUtils.addMinutes(datetime, 30);
            }
        }
        return list;
    }

    private Date setTime(Date datetime, int hour, int min, int sec, int msec) {
        Date tmp = DateUtils.setHours(DateUtils.setMinutes(DateUtils.setSeconds(DateUtils.setMilliseconds(datetime, msec), sec), min), hour);
        return tmp;
    }

    private Calendar getCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public List<EmptyRoom> create(DateInfoType[] dateinfos, Collection<String> mtrooms, ReservationList reserved) throws ParseException {
        ArrayList<EmptyRoom> list = new ArrayList<EmptyRoom>();
        for (String room : mtrooms) {
            int i = 0;
            while (i < dateinfos.length) {
                Date timeto;
                Date timefrom;
                DateInfoType dateinfo = dateinfos[i];
                Date date = DateInfoUtil.getDateFormat().parse(dateinfo.getDateFrom());
                if (!reserved.isReserved(room, date, timefrom = DateInfoUtil.getTimeFormat().parse(dateinfo.getTimeFrom()), timeto = DateInfoUtil.getTimeFormat().parse(dateinfo.getTimeTo()))) {
                    EmptyRoom emp = new EmptyRoom();
                    emp.setDate(this.getCalendar(date));
                    emp.setRoomName(room);
                    emp.setTimeFrom(this.getCalendar(timefrom));
                    emp.setTimeTo(this.getCalendar(timeto));
                    list.add(emp);
                }
                ++i;
            }
        }
        return list;
    }
}

