/*
 * Decompiled with CFR 0.152.
 */
package mtroom;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import mtroom.DateInfoUtil;
import schema.DateInfoType;
import schema.ReserveRoomRequestType;

public class DateInfoValidator {
    private Date dateFrom;
    private Date timeFrom;
    private Date timeTo;
    private boolean valid = false;
    private Object invalidValue;
    private String invalidName;

    public void validate(ReserveRoomRequestType req) {
        Date timeTo;
        Date timeFrom;
        Date date;
        DateInfoType dateinfo = req.getDateInfo();
        try {
            date = DateInfoUtil.parseDate(dateinfo.getDateFrom());
        }
        catch (ParseException e) {
            this.invalidName = "DateFrom";
            this.invalidValue = dateinfo.getDateFrom();
            this.valid = false;
            return;
        }
        try {
            timeFrom = DateInfoUtil.parseTime(dateinfo.getTimeFrom());
        }
        catch (ParseException e) {
            this.invalidName = "TimeFrom";
            this.invalidValue = dateinfo.getTimeFrom();
            this.valid = false;
            return;
        }
        try {
            timeTo = DateInfoUtil.parseTime(dateinfo.getTimeTo());
        }
        catch (ParseException e) {
            this.invalidName = "DateTo";
            this.invalidValue = dateinfo.getTimeTo();
            this.valid = false;
            return;
        }
        this.dateFrom = date;
        this.timeFrom = timeFrom;
        this.timeTo = timeTo;
        this.valid = true;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public Date getTimeTo() {
        return this.timeTo;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Object getInvalidValue() {
        return this.invalidValue;
    }

    public String getInvalidName() {
        return this.invalidName;
    }

    public String toString() {
        DateFormat df = DateFormat.getDateInstance();
        DateFormat tf = DateFormat.getTimeInstance();
        return String.valueOf(df.format(this.dateFrom)) + " " + tf.format(this.timeFrom) + " " + tf.format(this.timeTo);
    }
}

