/*
 * Decompiled with CFR 0.152.
 */
package manHourData;

public class ManHourOneData {
    private final String userId;
    private final String item;
    private final String workTimeResult;
    private final String workTimePlan;
    private final String workTimeTotal;
    private final String manHourResult;
    private final String manHourPlan;
    private final String manHourTotal;

    public ManHourOneData(String userId, String item, String workTimeResult, String workTimePlan, String manHourResult, String manHourPlan) {
        this.userId = userId;
        this.item = item;
        this.workTimeResult = workTimeResult;
        this.workTimePlan = workTimePlan;
        this.workTimeTotal = this.calcTotal(workTimeResult, workTimePlan);
        this.manHourResult = manHourResult;
        this.manHourPlan = manHourPlan;
        this.manHourTotal = this.calcTotal(manHourResult, manHourPlan);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getItem() {
        return this.item;
    }

    public String getWorkTimeResult() {
        return this.roundString(this.workTimeResult, 5);
    }

    public String getWorkTimePlan() {
        return this.roundString(this.workTimePlan, 5);
    }

    public String getWorkTimeTotal() {
        return this.roundString(this.workTimeTotal, 5);
    }

    public String getManHourResult() {
        return this.roundString(this.manHourResult, 4);
    }

    public String getManHourPlan() {
        return this.roundString(this.manHourPlan, 4);
    }

    public String getManHourTotal() {
        return this.roundString(this.manHourTotal, 4);
    }

    private String roundString(String tmpStr, int length) {
        String result = tmpStr.length() > length ? new String(tmpStr.substring(0, length)) : new String(tmpStr);
        return result;
    }

    private String calcTotal(String a, String b) {
        String result = "";
        if (a.equals("-") || b.equals("-")) {
            result = "-";
        } else {
            double total = Double.valueOf(a) + Double.valueOf(b);
            result = Double.toString(total);
        }
        return result;
    }
}

