/*
 * Decompiled with CFR 0.152.
 */
package jScheduleData;

import commonData.UserInfo;
import configInfo.NotesConfig;
import jScheduleData.JScheduleData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import mtroom.Reservation;
import mtroom.RoomSearchCriteria;
import mtroom.notes.MeetingRoom;
import mtroom.notes.MeetingRoomOak;
import mtroom.notes.OakMeetingRoomReserver;
import scheduleData.DateInfo;
import scheduleData.NotesScheduleData;
import scheduleData.ScheduleData;

public class JScheduleDataNotes
extends JScheduleData {
    private NotesConfig notesConfig;
    private MeetingRoom meetingRoom;
    private static long SERVER_WAIT_TIME = 30000L;

    public JScheduleDataNotes(UserInfo userInfo, NotesConfig notesConfig) {
        super(userInfo);
        if (this.notesConfig == null) {
            this.notesConfig = notesConfig;
        }
    }

    @Override
    public int readScheduleData(DateInfo dateScope) {
        if (this.readNotesMeetingRoomSchedule(dateScope) < 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int addScheduleData(ArrayList<ScheduleData> sdList) {
        for (ScheduleData sd : sdList) {
            this.reserveNotesRoom(sd);
        }
        return 0;
    }

    @Override
    public int delScheduleData(ArrayList<ScheduleData> sdList) {
        return 0;
    }

    private void reserveNotesRoom(ScheduleData sd) {
        OakMeetingRoomReserver omrr = new OakMeetingRoomReserver(this.notesConfig.getNotesIdFile(), this.notesConfig.getPassword(), this.notesConfig.getNotesServer(), this.notesConfig.getNotesFile());
        Reservation rsv = new Reservation();
        rsv.setCreater(this.notesConfig.getUserName());
        Calendar cal = Calendar.getInstance();
        cal.set(Integer.valueOf(sd.getS_date().getYyyy()), Integer.valueOf(sd.getS_date().getMm()) - 1, Integer.valueOf(sd.getS_date().getDd()));
        rsv.setDate(cal.getTime());
        rsv.setPlace(this.userInfo.getUserId());
        rsv.setTel1(this.notesConfig.getTelNumber());
        rsv.setTime1(String.valueOf(sd.getS_date().getHH()) + ":" + sd.getS_date().getMM());
        rsv.setTime2(String.valueOf(sd.getE_date().getHH()) + ":" + sd.getE_date().getMM());
        rsv.setUser(this.notesConfig.getUserName());
        rsv.setKanriBumon(this.notesConfig.getSectionName());
        rsv.setPurpose(this.notesConfig.getPurpose());
        rsv.setNumOfPeople(4);
        omrr.reserve(rsv);
    }

    private int readNotesMeetingRoomSchedule(DateInfo dateScope) {
        DateInfo targetDi = new DateInfo();
        int i = 0;
        while (i < 1) {
            targetDi.incrementMm();
            ++i;
        }
        this.meetingRoom = new MeetingRoomOak(this.notesConfig.getNotesIdFile(), this.notesConfig.getPassword(), this.notesConfig.getNotesServer(), this.notesConfig.getNotesFile());
        this.meetingRoom.setRoomSearchCriteria(this.createRoomSearchCriteria(targetDi));
        this.meetingRoom.start();
        try {
            this.meetingRoom.join(SERVER_WAIT_TIME);
        }
        catch (InterruptedException e) {
            throw new IllegalThreadStateException("server access interrupted");
        }
        this.setNotes2JscheduleMap();
        return 0;
    }

    private RoomSearchCriteria createRoomSearchCriteria(DateInfo toDi) {
        RoomSearchCriteria rsc = new RoomSearchCriteria();
        DateInfo todayDi = new DateInfo();
        Calendar calfromDate = Calendar.getInstance();
        calfromDate.set(Integer.valueOf(todayDi.getYyyy()), Integer.valueOf(todayDi.getMm()) - 1, 1);
        rsc.setDateFrom(calfromDate);
        Calendar calfromTime = Calendar.getInstance();
        calfromTime.set(Integer.valueOf(todayDi.getYyyy()), Integer.valueOf(todayDi.getMm()) - 1, 1, 0, 0, 0);
        rsc.setTimeFrom(calfromTime);
        Calendar caltoDate = Calendar.getInstance();
        caltoDate.set(Integer.valueOf(toDi.getYyyy()), Integer.valueOf(toDi.getMm()) - 1, 30);
        rsc.setDateTo(caltoDate);
        Calendar caltoTime = Calendar.getInstance();
        caltoTime.set(Integer.valueOf(toDi.getYyyy()), Integer.valueOf(toDi.getMm()) - 1, 30, 23, 30, 0);
        rsc.setTimeTo(caltoTime);
        rsc.setRoomName(this.getUserName());
        System.out.println(rsc.toString());
        return rsc;
    }

    private void setNotes2JscheduleMap() {
        this.createDataMap();
        for (Reservation reservation : this.meetingRoom.getReservationList().getRList()) {
            NotesScheduleData sd = this.createScheduleData(reservation);
            this.addSchedule2ScheduleDataMap2(sd);
            this.addSchedule2DayScheduleDataMap(sd);
        }
    }

    private NotesScheduleData createScheduleData(Reservation reservation) {
        NotesScheduleData sd = new NotesScheduleData();
        sd.setTitle(reservation.getUser());
        sd.setPlace(reservation.getKanriBumon());
        sd.setPurpose(reservation.getPurpose());
        sd.setKanriBumon(reservation.getKanriBumon());
        sd.setCreater(reservation.getCreater());
        sd.setTel1(reservation.getTel1());
        sd.setUser(reservation.getUser());
        sd.setNumOfPeople(reservation.getNumOfPeople());
        sd.setS_date(this.convert2DateInofo(reservation.getDate(), reservation.getTime1()));
        sd.setE_date(this.convert2DateInofo(reservation.getDate(), reservation.getTime2()));
        return sd;
    }

    private DateInfo convert2DateInofo(Date date, String time) {
        SimpleDateFormat sdfYyyy = new SimpleDateFormat("yyyy");
        SimpleDateFormat sdfMm = new SimpleDateFormat("MM");
        SimpleDateFormat sdfDd = new SimpleDateFormat("dd");
        String[] wkStr = time.split(":");
        DateInfo di = new DateInfo(sdfYyyy.format(date), sdfMm.format(date), sdfDd.format(date), wkStr[0], wkStr[1]);
        return di;
    }
}

