/*
 * Decompiled with CFR 0.152.
 */
package jScheduleData;

import commonData.UserInfo;
import configInfo.GaroonConfig;
import configInfo.GoogleCalendarConfig;
import configInfo.NotesConfig;
import jScheduleData.JScheduleData;
import jScheduleData.JScheduleDataCreateConfig;
import jScheduleData.JScheduleDataCreator;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import scheduleData.ScheduleData;

public class AllUserJScheduleData {
    private HashMap<String, JScheduleData> allUserJscheduleDataMap = new HashMap();
    private String currentFileName;
    private GaroonConfig garoonConfig;
    private NotesConfig notesConfig;
    private GoogleCalendarConfig googleCalendarConfig;

    public AllUserJScheduleData(String fileName, GaroonConfig garoonConfig, NotesConfig notesConfig, GoogleCalendarConfig googleCalendarConfig, UserInfo userInfo) {
        this.currentFileName = fileName;
        this.garoonConfig = garoonConfig;
        this.notesConfig = notesConfig;
        this.googleCalendarConfig = googleCalendarConfig;
        this.readJScheduleDataFile(fileName, userInfo);
    }

    private void readJScheduleDataFile(String fileName, UserInfo userInfo) {
        File jsmFile;
        JScheduleDataCreator jsdc = new JScheduleDataCreator();
        JScheduleDataCreateConfig.JScheduleDataKind userKind = userInfo.isGaoonUser() ? JScheduleDataCreateConfig.JScheduleDataKind.GAROON : (userInfo.isNotesRoom() ? JScheduleDataCreateConfig.JScheduleDataKind.NOTES : JScheduleDataCreateConfig.JScheduleDataKind.JSM);
        JScheduleDataCreateConfig jsdcc = new JScheduleDataCreateConfig(userKind, userInfo, jsmFile = new File(fileName), this.garoonConfig, this.notesConfig, this.googleCalendarConfig);
        JScheduleData jsd = jsdc.createJScheduleData(jsdcc);
        if (jsd == null || jsd.readScheduleData() < 0) {
            System.err.println("\u30b9\u30b1\u30b8\u30e5\u30fc\u30eb\u30c7\u30fc\u30bf\u306e\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.allUserJscheduleDataMap.put(userInfo.getUserId(), jsd);
    }

    public JScheduleData getJScheduleData(UserInfo userInfo) {
        if (this.allUserJscheduleDataMap.containsKey(userInfo.getUserId())) {
            return this.allUserJscheduleDataMap.get(userInfo.getUserId());
        }
        String fileName = this.makeJsmFileName(userInfo.getUserId(), this.currentFileName);
        this.readJScheduleDataFile(fileName, userInfo);
        if (this.allUserJscheduleDataMap.containsKey(userInfo.getUserId())) {
            return this.allUserJscheduleDataMap.get(userInfo.getUserId());
        }
        return null;
    }

    public void addScheduleData(UserInfo userInfo, ScheduleData sd) {
        if (this.allUserJscheduleDataMap.containsKey(userInfo.getUserId())) {
            JScheduleData jsd = this.allUserJscheduleDataMap.get(userInfo.getUserId());
            jsd.addSchedule(sd);
        } else {
            System.err.println("UserId is error in  AllUserJScheduleData.addScheduleData " + userInfo.getUserId());
        }
    }

    public void delScheduleData(UserInfo userInfo, ScheduleData sd) {
        if (this.allUserJscheduleDataMap.containsKey(userInfo.getUserId())) {
            JScheduleData jsd = this.allUserJscheduleDataMap.get(userInfo.getUserId());
            jsd.delSchedule(sd);
        } else {
            System.err.println("UserId is error in  AllUserJScheduleData.delScheduleData");
        }
    }

    private String makeJsmFileName(String userId, String currentFileName) {
        File file = new File(currentFileName);
        String dirName = file.getAbsoluteFile().getParent();
        return String.valueOf(dirName) + "\\" + userId + ".jsm";
    }

    public void printAllScheduleData() {
        Set<String> userIdList = this.allUserJscheduleDataMap.keySet();
        for (String userId : userIdList) {
            this.allUserJscheduleDataMap.get(userId).printScheduleData();
            System.out.println("UserId is " + userId);
        }
    }
}

