/*
 * Decompiled with CFR 0.152.
 */
package googleSession;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.CookieHandler;
import java.net.URI;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import sessionCommon.HttpResult;
import sessionCommon.J2gCookieManager;
import sessionCommon.J2gCookiePolicy;
import sessionCommon.J2gCookieStore2;
import sessionCommon.PostParamData;

public class GoogleLogin {
    public HttpResult googleLogin(String url_name, String user_id, String password) {
        HttpResult httpResult = new HttpResult();
        if (CookieHandler.getDefault() == null) {
            J2gCookieStore2 cookie_store = new J2gCookieStore2();
            J2gCookiePolicy cookie_policy = new J2gCookiePolicy();
            J2gCookieManager manager = new J2gCookieManager(cookie_store, cookie_policy);
            CookieHandler.setDefault(manager);
            httpResult.headerInfo.setCookieManager(manager);
        }
        try {
            URI uri = new URI(url_name);
            HttpsURLConnection url_connection = (HttpsURLConnection)uri.toURL().openConnection();
            if (url_connection == null) {
                httpResult.result = -1;
                return httpResult;
            }
            url_connection.setRequestMethod("POST");
            url_connection.setDoOutput(true);
            PrintWriter url_out = new PrintWriter(url_connection.getOutputStream());
            url_out.print(this.createLoginMessage(user_id, password));
            url_out.close();
            if (url_connection.getResponseCode() != 200) {
                httpResult.result = -2;
                return httpResult;
            }
            BufferedReader url_in = new BufferedReader(new InputStreamReader(url_connection.getInputStream(), "UTF-8"));
            httpResult.headerInfo.getFormAnalyser().setFormData(url_in);
        }
        catch (Exception e) {
            e.printStackTrace();
            httpResult.result = -1;
            return httpResult;
        }
        httpResult.result = 0;
        return httpResult;
    }

    private String createLoginMessage(String user_id, String password) {
        String msg = "";
        ArrayList<PostParamData> paramBody = new ArrayList<PostParamData>();
        paramBody.add(new PostParamData("Email", user_id));
        paramBody.add(new PostParamData("Passwd", password));
        for (PostParamData body : paramBody) {
            msg = String.valueOf(msg) + body.makeMessageURLEncode2UTF8();
        }
        return msg;
    }
}

