/*
 * Decompiled with CFR 0.152.
 */
package garoonSession;

import garoonSession.GaroonHeaderInfo;
import garoonSession.GaroonHttpResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;
import sessionCommon.HttpSession;

public class GaroonMonthSchedule {
    public List<ScheduleData> schedule_list = new ArrayList<ScheduleData>();
    private List<DetailScheduleUrlInfo> detail_url_list = new ArrayList<DetailScheduleUrlInfo>();

    public GaroonHttpResult read(String url_name, GaroonHeaderInfo h_info, String yyyy, String mm, String dd) {
        GaroonHttpResult http_result = this.read_month_schedule(url_name, h_info, yyyy, mm, dd);
        for (DetailScheduleUrlInfo dsui : this.detail_url_list) {
            http_result = this.read_detail_schedule(dsui.detailUrl, http_result.headerInfo, dsui.yyyy, dsui.mm, dsui.dd);
            if (http_result.result >= 0) continue;
            return http_result;
        }
        http_result.result = 0;
        return http_result;
    }

    private GaroonHttpResult read_month_schedule(String url_name, GaroonHeaderInfo h_info, String yyyy, String mm, String dd) {
        GaroonHttpResult http_result = new GaroonHttpResult();
        CookieHandler.setDefault(h_info.getCookieManager());
        String url_data = this.make_month_url_data(url_name, h_info.uid, h_info.gid, yyyy, mm);
        HttpSession gcon = new HttpSession();
        HttpURLConnection url_connection = gcon.create_connection(url_data);
        if (url_connection == null) {
            http_result.result = -1;
            return http_result;
        }
        try {
            url_connection.setRequestMethod("GET");
            if (url_connection.getResponseCode() != 200) {
                http_result.result = -1;
                return http_result;
            }
            BufferedReader url_in = new BufferedReader(new InputStreamReader(url_connection.getInputStream()));
            http_result.headerInfo.uid = h_info.uid;
            http_result.headerInfo.gid = h_info.gid;
            http_result = this.extractDetailUrl(url_name, url_in, yyyy, mm, dd);
            if (http_result.result < 0) {
                return http_result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            http_result.result = -1;
            return http_result;
        }
        if (http_result.headerInfo.uid.length() < 1) {
            http_result.headerInfo.uid = h_info.uid;
        }
        if (http_result.headerInfo.gid.length() < 1) {
            http_result.headerInfo.gid = h_info.gid;
        }
        http_result.headerInfo.setCookieManager(h_info.getCookieManager());
        return http_result;
    }

    private String make_month_url_data(String url_name, String uid, String gid, String yyyy, String mm) {
        String result = null;
        result = String.valueOf(url_name) + "?bdate=" + yyyy + "-" + mm + "-" + "01" + "&uid=" + uid + "&gid=" + gid;
        return result;
    }

    private GaroonHttpResult read_detail_schedule(String url_name, GaroonHeaderInfo h_info, String yyyy, String mm, String dd) {
        GaroonHttpResult http_result = new GaroonHttpResult();
        HttpSession gcon = new HttpSession();
        CookieHandler.setDefault(h_info.getCookieManager());
        HttpURLConnection url_connection = gcon.create_connection(url_name);
        if (url_connection == null) {
            http_result.result = -1;
            return http_result;
        }
        try {
            url_connection.setRequestMethod("GET");
            if (url_connection.getResponseCode() != 200) {
                http_result.result = -1;
                return http_result;
            }
            BufferedReader url_in = new BufferedReader(new InputStreamReader(url_connection.getInputStream(), "UTF-8"));
            if (this.extractScheduleData(url_in, yyyy, mm, dd) < 0) {
                http_result.result = -1;
                return http_result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            http_result.result = -1;
            return http_result;
        }
        http_result.headerInfo = h_info;
        return http_result;
    }

    private GaroonHttpResult extractDetailUrl(String urlName, BufferedReader urlIn, String yyyy, String mm, String dd) {
        String inputLine = "";
        GaroonHttpResult httpResult = new GaroonHttpResult();
        String scheduleInfo = "< *a +href *= *\"(/cgi-bin/cbgrn/grn\\.cgi/schedule/view\\?event=\\d*&amp;bdate=)(\\d+)(-)(\\d+)(-)(\\d+)(&amp;uid=\\d+&amp;gid=\\d*)\">";
        Pattern schedulePattern = Pattern.compile(scheduleInfo);
        try {
            while ((inputLine = urlIn.readLine()) != null) {
                DateInfo di2;
                String scheDd;
                String scheMm;
                Matcher matcher = schedulePattern.matcher(inputLine);
                if (!matcher.find()) continue;
                ArrayList<String> tmpStrList = new ArrayList<String>();
                int i = 1;
                while (i <= matcher.groupCount()) {
                    if (matcher.group(i) != null) {
                        tmpStrList.add(matcher.group(i));
                    } else {
                        tmpStrList.add("");
                    }
                    ++i;
                }
                String scheYyyy = (String)tmpStrList.get(1);
                DateInfo di1 = new DateInfo(scheYyyy, scheMm = (String)tmpStrList.get(3), scheDd = (String)tmpStrList.get(5), "00", "00");
                if (di1.compareDateInfo(di2 = new DateInfo(yyyy, mm, dd, "00", "00")) != -1) {
                    this.detail_url_list.add(this.getDetailScheduleUrlInfo(urlName, tmpStrList, scheYyyy, scheMm, scheDd));
                }
                httpResult.headerInfo.setUidGid(inputLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            httpResult.result = -1;
            return httpResult;
        }
        httpResult.result = 0;
        return httpResult;
    }

    private DetailScheduleUrlInfo getDetailScheduleUrlInfo(String urlName, ArrayList<String> tmpStrList, String yyyy, String mm, String dd) {
        DetailScheduleUrlInfo dsui = new DetailScheduleUrlInfo();
        String[] tmpStr = urlName.split("/");
        String hostName = tmpStr[2];
        String wkDtlUrl = "http://" + hostName;
        Iterator<String> i = tmpStrList.iterator();
        while (i.hasNext()) {
            wkDtlUrl = String.valueOf(wkDtlUrl) + i.next();
        }
        dsui.detailUrl = wkDtlUrl;
        dsui.yyyy = yyyy;
        dsui.mm = mm;
        dsui.dd = dd;
        return dsui;
    }

    private int extractScheduleData(BufferedReader url_in, String yyyy, String mm, String dd) {
        ScheduleData scheduleData = new ScheduleData();
        DetailTimeHolder dth = new DetailTimeHolder();
        String input_line = "";
        int date_info_result = -1;
        int title_info_result = -1;
        scheduleData.getS_date().setYyyy(yyyy);
        scheduleData.getS_date().setMm(mm);
        scheduleData.getS_date().setDd(dd);
        scheduleData.getE_date().setYyyy(yyyy);
        scheduleData.getE_date().setMm(mm);
        scheduleData.getE_date().setDd(dd);
        try {
            while ((input_line = url_in.readLine()) != null) {
                Pattern pattern3;
                Matcher matcher3;
                Pattern pattern = Pattern.compile("< *th +nowrap *> *\u65e5\u6642 *< */th *>");
                Matcher matcher = pattern.matcher(input_line);
                if (matcher.find() && (dth = this.extractHhMm(url_in.readLine())) != null) {
                    scheduleData.getS_date().setHH(dth.sHH);
                    scheduleData.getS_date().setMM(dth.sMM);
                    scheduleData.getE_date().setHH(dth.eHH);
                    scheduleData.getE_date().setMM(dth.eMM);
                    date_info_result = 1;
                }
                if (!(matcher3 = (pattern3 = Pattern.compile("< *th +nowrap *> *\u30bf\u30a4\u30c8\u30eb *< */th *>")).matcher(input_line)).find()) continue;
                scheduleData.setTitle(this.extract_title_info(url_in.readLine()));
                title_info_result = 1;
                break;
            }
            if (date_info_result > 0 && title_info_result > 0) {
                this.schedule_list.add(scheduleData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private DetailTimeHolder extractHhMm(String input_line) {
        DetailTimeHolder dth = new DetailTimeHolder();
        try {
            Pattern pattern = Pattern.compile("<td>|</td>");
            String[] tmp_str_list1 = pattern.split(input_line);
            pattern = Pattern.compile(" +");
            String[] tmp_str_list2 = pattern.split(tmp_str_list1[1]);
            if (tmp_str_list2.length > 4) {
                pattern = Pattern.compile("[\u6642\u5206]");
                String[] tmp_str_list4 = pattern.split(tmp_str_list2[1]);
                dth.sHH = String.format("%02d", Integer.valueOf(tmp_str_list4[0]));
                dth.sMM = String.format("%02d", Integer.valueOf(tmp_str_list4[1]));
                pattern = Pattern.compile("[\u6642\u5206]");
                tmp_str_list4 = pattern.split(tmp_str_list2[4]);
                dth.eHH = String.format("%02d", Integer.valueOf(tmp_str_list4[0]));
                dth.eMM = String.format("%02d", Integer.valueOf(tmp_str_list4[1]));
            } else {
                pattern = Pattern.compile(";");
                String[] tmp_str_list3 = pattern.split(tmp_str_list2[0]);
                pattern = Pattern.compile("\uff5e");
                String[] tmp_str_list4 = pattern.split(tmp_str_list3[1]);
                pattern = Pattern.compile("[\u6642\u5206]");
                String[] tmp_str_list5 = pattern.split(tmp_str_list4[0]);
                dth.sHH = String.format("%02d", Integer.valueOf(tmp_str_list5[0]));
                dth.sMM = String.format("%02d", Integer.valueOf(tmp_str_list5[1]));
                String[] tmp_str_list6 = pattern.split(tmp_str_list4[1]);
                dth.eHH = String.format("%02d", Integer.valueOf(tmp_str_list6[0]));
                dth.eMM = String.format("%02d", Integer.valueOf(tmp_str_list6[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("inputLine : " + input_line);
            return null;
        }
        return dth;
    }

    private String extract_title_info(String input_line) {
        Pattern pattern = Pattern.compile("<td>|</td>");
        String[] tmp_str_list1 = pattern.split(input_line);
        return tmp_str_list1[1];
    }

    private class DetailScheduleUrlInfo {
        String detailUrl = "";
        String yyyy = "";
        String mm = "";
        String dd = "";

        private DetailScheduleUrlInfo() {
        }
    }

    private class DetailTimeHolder {
        String sHH = "";
        String sMM = "";
        String eHH = "";
        String eMM = "";

        private DetailTimeHolder() {
        }
    }
}

