/*
 * Decompiled with CFR 0.152.
 */
package garoonSession;

import garoonSession.GaroonHttpResult;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scheduleData.ScheduleData;
import sessionCommon.HttpSession;
import sessionCommon.J2gCookieManager;

public class GaroonLightMonthSchedule {
    private ArrayList<ScheduleData> scheduleList = new ArrayList();

    public GaroonHttpResult read(String urlName, J2gCookieManager cookieManger, String userId, String grpId, String yyyy, String mm, String dd) {
        GaroonHttpResult http_result = new GaroonHttpResult();
        HttpSession gcon = new HttpSession();
        String url_data = this.makeMonthGetParam(urlName, userId, grpId, yyyy, mm);
        HttpURLConnection url_connection = gcon.create_connection(url_data);
        if (url_connection == null) {
            http_result.result = -1;
            return http_result;
        }
        try {
            url_connection.setRequestMethod("GET");
            if (url_connection.getResponseCode() != 200) {
                http_result.result = -1;
                return http_result;
            }
            BufferedReader url_in = new BufferedReader(new InputStreamReader(url_connection.getInputStream(), "UTF-8"));
            http_result.headerInfo.uid = userId;
            http_result.headerInfo.gid = grpId;
            if (this.extractScheduleData(url_in) < 0) {
                return http_result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            http_result.result = -1;
            return http_result;
        }
        if (http_result.headerInfo.uid.length() < 1) {
            http_result.headerInfo.uid = userId;
        }
        if (http_result.headerInfo.gid.length() < 1) {
            http_result.headerInfo.gid = grpId;
        }
        http_result.headerInfo.setCookieManager(cookieManger);
        return http_result;
    }

    private String makeMonthGetParam(String url_name, String uid, String gid, String yyyy, String mm) {
        String result = String.valueOf(url_name) + "?bdate=" + yyyy + "-" + mm + "-" + "01" + "&uid=" + uid + "&gid=" + gid;
        return result;
    }

    private int extractScheduleData(BufferedReader urlIn) {
        String inputLine = "";
        String scheduleInfo = "< *a +href *= *\"/cgi-bin/cbgrn/grn\\.cgi/schedule/view\\?event=(\\d+)&amp;bdate=(\\d+)-(\\d+)-(\\d+)&amp;uid=[0-9|a-z]+&amp;gid=[0-9|a-z]*&amp;referer_key=[a-z|\\d]+\"[^>]+>(\\d{1,2}):(\\d{1,2})-(\\d{1,2}):(\\d{1,2})([^<]*)<";
        Pattern schedulePattern = Pattern.compile(scheduleInfo);
        try {
            while ((inputLine = urlIn.readLine()) != null) {
                Matcher matcher = schedulePattern.matcher(inputLine);
                if (!matcher.find()) continue;
                ScheduleData sd = new ScheduleData();
                try {
                    sd.setEventCode(matcher.group(1));
                    sd.getS_date().setYyyy(matcher.group(2));
                    sd.getS_date().setMm(matcher.group(3));
                    sd.getS_date().setDd(matcher.group(4));
                    sd.getS_date().setHH(matcher.group(5));
                    sd.getS_date().setMM(matcher.group(6));
                    sd.getE_date().setYyyy(matcher.group(2));
                    sd.getE_date().setMm(matcher.group(3));
                    sd.getE_date().setDd(matcher.group(4));
                    sd.getE_date().setHH(matcher.group(7));
                    sd.getE_date().setMM(matcher.group(8));
                    sd.setTitle(matcher.group(9));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println(inputLine);
                }
                this.scheduleList.add(sd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public ArrayList<ScheduleData> getScheduleList() {
        return this.scheduleList;
    }
}

