/*
 * Decompiled with CFR 0.152.
 */
package garoonSchedule;

import configInfo.GaroonConfig;
import garoonSession.GaroonAdd;
import garoonSession.GaroonDel;
import garoonSession.GaroonGetAdd;
import garoonSession.GaroonHeaderInfo;
import garoonSession.GaroonHttpResult;
import garoonSession.GaroonLightMonthSchedule;
import garoonSession.GaroonLogin;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;

public class GaroonScheduleData {
    private ArrayList<ScheduleData> scheduleList = new ArrayList();
    private HashMap<String, ScheduleData> scheduleMap = new HashMap();
    private boolean scheduleReaded = false;
    private GaroonHeaderInfo h_info = new GaroonHeaderInfo();
    private DateInfo scopeDateInfo;
    private GaroonConfig garoonConfig;
    private final String garoonUid;
    private final String garoonGid;

    public GaroonScheduleData(GaroonConfig garoonConfig, DateInfo di) {
        this.garoonConfig = garoonConfig;
        this.scopeDateInfo = di;
        this.garoonUid = "";
        this.garoonGid = "";
    }

    public GaroonScheduleData(GaroonConfig garoonConfig, DateInfo di, String garoonUid, String garoonGid) {
        this.garoonConfig = garoonConfig;
        this.scopeDateInfo = di;
        this.garoonUid = garoonUid;
        this.garoonGid = garoonGid;
    }

    public int changeScopeDate(DateInfo di) {
        int target;
        int result = 0;
        int scope = Integer.valueOf(this.scopeDateInfo.getYyyy()) * 100 + Integer.valueOf(this.scopeDateInfo.getMm());
        if (scope < (target = Integer.valueOf(di.getYyyy()) * 100 + Integer.valueOf(di.getMm()))) {
            result = this.schedule_read(this.scopeDateInfo.getYyyy(), this.scopeDateInfo.getMm(), this.scopeDateInfo.getDd());
            this.scopeDateInfo = di;
        }
        return result;
    }

    public int schedule_read(String yyyy, String mm, String dd) {
        GaroonLogin g_login = new GaroonLogin();
        GaroonHttpResult h_result = g_login.garoon_login(this.garoonConfig.getUrl_login(), this.garoonConfig.getUser_id(), this.garoonConfig.getPassword());
        if (h_result.result < 0) {
            System.err.println(String.valueOf(this.getClass().getName()) + " schedule_read garoon_login error " + h_result.result);
            return -1;
        }
        this.h_info = h_result.headerInfo;
        while (this.checkScope(this.scopeDateInfo, yyyy, mm)) {
            GaroonLightMonthSchedule g_month = new GaroonLightMonthSchedule();
            h_result = g_month.read(this.garoonConfig.getUrl_month(), this.h_info.getCookieManager(), this.getGaroonUid(), this.getGaroonGid(), yyyy, mm, dd);
            if (h_result.result < 0) {
                this.scheduleList = null;
                return -2;
            }
            this.h_info = h_result.headerInfo;
            for (ScheduleData sd : g_month.getScheduleList()) {
                if (this.scheduleMap.containsKey(sd.createScheduleDataKey())) continue;
                this.scheduleList.add(sd);
                this.scheduleMap.put(sd.createScheduleDataKey(), sd);
            }
            if (mm == "12") {
                mm = "01";
                dd = "01";
                Integer tmp_yyyy = new Integer(yyyy);
                tmp_yyyy = tmp_yyyy + 1;
                yyyy = tmp_yyyy.toString();
                continue;
            }
            Integer tmp_mm = new Integer(mm);
            tmp_mm = tmp_mm + 1;
            DecimalFormat dec_format = new DecimalFormat("00");
            mm = dec_format.format(tmp_mm);
            dd = "01";
        }
        this.scheduleReaded = true;
        return 0;
    }

    public int addSchedule(String url_name, List<ScheduleData> schedule_list) {
        GaroonLogin g_login = new GaroonLogin();
        GaroonHttpResult h_result = g_login.garoon_login(this.garoonConfig.getUrl_login(), this.garoonConfig.getUser_id(), this.garoonConfig.getPassword());
        if (h_result.result < 0) {
            System.err.println(String.valueOf(this.getClass().getName()) + " schedule_read garoon_login error " + h_result.result);
            return -1;
        }
        for (ScheduleData sd : schedule_list) {
            GaroonGetAdd garoonGetAdd = new GaroonGetAdd();
            h_result = garoonGetAdd.getAdd(this.garoonConfig.getUrl_get_add(), h_result.headerInfo, sd);
            if (h_result.result < 0) {
                System.err.println(String.valueOf(this.getClass().getName()) + " garoonGet" + h_result.result);
                continue;
            }
            GaroonAdd g_add = new GaroonAdd();
            h_result = g_add.add(url_name, h_result.headerInfo, sd);
            if (h_result.headerInfo.getFormAnalyser().getHiddenMap(0).containsKey("event")) {
                sd.setEventCode(h_result.headerInfo.getFormAnalyser().getHiddenMap(0).get("event"));
            }
            this.scheduleList.add(sd);
            this.h_info = h_result.headerInfo;
        }
        return 0;
    }

    public int delSchedule(String del_url_name, String del_confirm_url_name, List<ScheduleData> schedule_list) {
        ArrayList<ScheduleData> notDelScheduleDataList = new ArrayList<ScheduleData>();
        HashMap<String, ScheduleData> notDelScheduleDataMap = new HashMap<String, ScheduleData>();
        GaroonLogin g_login = new GaroonLogin();
        GaroonHttpResult h_result = g_login.garoon_login(this.garoonConfig.getUrl_login(), this.garoonConfig.getUser_id(), this.garoonConfig.getPassword());
        if (h_result.result < 0) {
            System.err.println(String.valueOf(this.getClass().getName()) + " schedule_read garoon_login error " + h_result.result);
            return -1;
        }
        this.h_info = h_result.headerInfo;
        for (ScheduleData garoonSd : this.scheduleList) {
            boolean isDeleted = false;
            for (ScheduleData targetSd : schedule_list) {
                if (!targetSd.compare(garoonSd)) continue;
                GaroonDel g_del = new GaroonDel();
                h_result = g_del.del(del_url_name, del_confirm_url_name, this.h_info, garoonSd, this.getGaroonUid(), this.getGaroonGid());
                this.h_info = h_result.headerInfo;
                if (h_result.result != 0) break;
                isDeleted = true;
                break;
            }
            if (isDeleted) continue;
            notDelScheduleDataList.add(garoonSd);
            notDelScheduleDataMap.put(garoonSd.createScheduleDataKey(), garoonSd);
        }
        this.scheduleList = notDelScheduleDataList;
        this.scheduleMap = notDelScheduleDataMap;
        return 0;
    }

    public ArrayList<ScheduleData> getScheduleList() {
        return this.scheduleList;
    }

    private boolean checkScope(DateInfo scopeDateInfo, String yyyy, String mm) {
        int scope = Integer.valueOf(scopeDateInfo.getYyyy()) * 10 + Integer.valueOf(scopeDateInfo.getMm());
        int target = Integer.valueOf(yyyy) * 10 + Integer.valueOf(mm);
        return target <= scope;
    }

    public boolean getScheduleReaded() {
        return this.scheduleReaded;
    }

    private String getGaroonUid() {
        if (this.garoonUid.equals("")) {
            return this.h_info.uid;
        }
        return this.garoonUid;
    }

    private String getGaroonGid() {
        if (this.garoonGid.equals("")) {
            return this.h_info.gid;
        }
        return this.garoonGid;
    }

    public void printAll() {
        int count = 0;
        System.out.println("GaroonScheduleData.printAll()");
        for (ScheduleData sd : this.scheduleList) {
            System.out.println("   [" + ++count + "] " + sd.createScheduleDataKey() + ",eventCode:" + sd.getEventCode());
        }
        System.out.println("   total count :" + count);
    }
}

