/*
 * Decompiled with CFR 0.152.
 */
package evmResultData;

import commonData.UserInfo;
import commonData.WbsNo;
import commonData.YyyyMmDdHolder;
import evmResultData.OneEvmResultData2;
import evmResultData.OneEvmResultData2Creater;
import jScheduleData.AllUserJScheduleData;
import jScheduleData.JScheduleData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;
import workMasterData.PhaseInfo2;
import workMasterData.PhaseInfoList2;
import workMasterData.ProjectUnit;

public class EvmResultData2 {
    ProjectUnit projectUnit;
    HashMap<String, OneEvmResultData2> phaseEvmResultMap = new HashMap();
    ArrayList<OneEvmResultData2> evmResultDataList;
    HashMap<Integer, OneEvmResultData2> uniquieEvmResultMap = new HashMap();
    HashMap<String, ArrayList<ScheduleData>> noPhaseScheduleDataMap;

    public EvmResultData2() {
        this.evmResultDataList = new ArrayList();
        this.noPhaseScheduleDataMap = new HashMap();
    }

    public void createEvmResultDataList(ProjectUnit projectUnit, PhaseInfoList2 phaseInfoList, AllUserJScheduleData aujsd, ArrayList<UserInfo> userInfoList, YyyyMmDdHolder startYyyyMmDd, YyyyMmDdHolder endYyyyMmDd) {
        this.projectUnit = projectUnit;
        this.createEvmResultDataByPlan(phaseInfoList);
        this.createEvmResultDataByResult(projectUnit, aujsd, userInfoList, startYyyyMmDd, endYyyyMmDd);
    }

    private void createEvmResultDataByPlan(PhaseInfoList2 phaseInfoList) {
        for (PhaseInfo2 phaseInfo : phaseInfoList.getPhaseInfoList()) {
            OneEvmResultData2 oerd = this.createOneEvmResultDataByPlan(phaseInfo);
            this.uniquieEvmResultMap.put(oerd.getUniqueId(), oerd);
            this.phaseEvmResultMap.put(oerd.getPhaseNameWithWbsno(), oerd);
            this.evmResultDataList.add(oerd);
        }
    }

    private OneEvmResultData2 createOneEvmResultDataByPlan(PhaseInfo2 phaseInfo) {
        OneEvmResultData2Creater oerdc = new OneEvmResultData2Creater();
        DateInfo planStartDateInfo = new DateInfo(phaseInfo.getPlanStart().getYyyy(), phaseInfo.getPlanStart().getMm(), phaseInfo.getPlanStart().getDd(), "", "");
        DateInfo planEndDateInfo = new DateInfo(phaseInfo.getPlanFinish().getYyyy(), phaseInfo.getPlanFinish().getMm(), phaseInfo.getPlanFinish().getDd(), "", "");
        OneEvmResultData2 oerd = oerdc.createOneEvmResultData2(phaseInfo.getUniqueid(), phaseInfo.getWbsno().getWbsNoByString(), phaseInfo.getName(), phaseInfo.getParentId(), planStartDateInfo, planEndDateInfo, phaseInfo.getPlanWorkHour(), phaseInfo.isOutputed(), phaseInfo.isPeaceWork());
        return oerd;
    }

    private void createEvmResultDataByResult(ProjectUnit projectUnit, AllUserJScheduleData aujsd, ArrayList<UserInfo> userInfoList, YyyyMmDdHolder startYyyyMmDd, YyyyMmDdHolder endYyyyMmDd) {
        for (UserInfo userInfo : userInfoList) {
            JScheduleData jsd = aujsd.getJScheduleData(userInfo);
            this.createEvmResultDataByResultAtUserInfo(projectUnit, jsd, startYyyyMmDd, endYyyyMmDd, userInfo);
        }
    }

    private void createEvmResultDataByResultAtUserInfo(ProjectUnit projectUnit, JScheduleData jsd, YyyyMmDdHolder startYyyyMmDd, YyyyMmDdHolder endYyyyMmDd, UserInfo userInfo) {
        YyyyMmDdHolder targetYyyyMmDd = new YyyyMmDdHolder(startYyyyMmDd.getYyyy(), startYyyyMmDd.getMm(), startYyyyMmDd.getDd());
        while (this.checkYyyyMmDd(targetYyyyMmDd, endYyyyMmDd)) {
            ArrayList<ScheduleData> sdList = jsd.getDayScheduleList2(targetYyyyMmDd);
            for (ScheduleData sd : sdList) {
                if (!projectUnit.getName().equals(sd.getProjectUnitName()) || this.addScheduleDataByResult(sd)) continue;
                this.setNoPhaseScheduleData(userInfo, sd);
            }
            targetYyyyMmDd.inclementDd();
        }
    }

    private void setNoPhaseScheduleData(UserInfo userInfo, ScheduleData sd) {
        if (this.noPhaseScheduleDataMap.containsKey(userInfo.getUserId())) {
            this.noPhaseScheduleDataMap.get(userInfo.getUserId()).add(sd);
        } else {
            ArrayList<ScheduleData> sdList = new ArrayList<ScheduleData>();
            sdList.add(sd);
            this.noPhaseScheduleDataMap.put(userInfo.getUserId(), sdList);
        }
    }

    private boolean addScheduleDataByResult(ScheduleData sd) {
        OneEvmResultData2 oerd;
        if (this.uniquieEvmResultMap.containsKey(sd.getUniquieId())) {
            oerd = this.uniquieEvmResultMap.get(sd.getUniquieId());
        } else {
            WbsNo wbsno = new WbsNo();
            wbsno.setWbsNo(sd.getWbsNo());
            String wbsPhaseName = new String(String.valueOf(wbsno.getWbsNoWithConnection()) + sd.getPhaseName());
            if (this.phaseEvmResultMap.containsKey(wbsPhaseName)) {
                oerd = this.phaseEvmResultMap.get(wbsPhaseName);
            } else {
                return false;
            }
        }
        oerd.addOneResultData(sd.getS_date(), sd.getTimeByHour(), sd.getProgressRatio());
        return true;
    }

    private boolean checkYyyyMmDd(YyyyMmDdHolder targetYyyyMmDd, YyyyMmDdHolder endYyyyMmDd) {
        DateInfo endDi;
        DateInfo targetDi = new DateInfo(targetYyyyMmDd.getYyyy(), targetYyyyMmDd.getMm(), targetYyyyMmDd.getDd(), "00", "00");
        return targetDi.compareDateInfo(endDi = new DateInfo(endYyyyMmDd.getYyyy(), endYyyyMmDd.getMm(), endYyyyMmDd.getDd(), "00", "00")) != 1;
    }

    public ArrayList<OneEvmResultData2> getOneEvmResultDataList() {
        return this.evmResultDataList;
    }

    public void printNoPhaseSchedule() {
        Set<String> userIdList = this.noPhaseScheduleDataMap.keySet();
        int count = 1;
        System.out.println("--------\u5de5\u7a0b\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u306a\u3044\u30c7\u30fc\u30bf\uff08\u3053\u3053\u304b\u3089\uff09--------");
        System.out.println("No,userId,startDate,title,projectUnitName,phaseName,uniquieId");
        for (String userId : userIdList) {
            for (ScheduleData sd : this.noPhaseScheduleDataMap.get(userId)) {
                System.out.println(String.valueOf(count) + "," + userId + "," + sd.getS_date().createDateInfoKey() + "," + sd.getTitle() + "," + sd.getProjectUnitName() + "," + sd.getWbsNo() + sd.getPhaseName() + "," + sd.getUniquieId());
                ++count;
            }
        }
        System.out.println("--------\u5de5\u7a0b\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u306a\u3044\u30c7\u30fc\u30bf\uff08\u3053\u3053\u307e\u3067\uff09--------");
    }
}

