/*
 * Decompiled with CFR 0.152.
 */
package evmResultData;

import commonData.UserInfo;
import commonData.YyyyMmDdHolder;
import evmResultData.OneEvmResultData;
import jScheduleData.AllUserJScheduleData;
import jScheduleData.JScheduleData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import scheduleData.DateInfo;
import scheduleData.ScheduleData;
import workMasterData.PhaseInfo;
import workMasterData.PhaseInfoList;
import workMasterData.ProjectUnit;

public class EvmResultData {
    HashMap<String, OneEvmResultData> phaseEvmResultMap = new HashMap();
    ArrayList<OneEvmResultData> evmResultDataList = new ArrayList();
    HashMap<String, ArrayList<ScheduleData>> noPhaseScheduleDataMap = new HashMap();

    public void createEvmResultDataList(ProjectUnit projectUnit, PhaseInfoList phaseInfoList, AllUserJScheduleData aujsd, ArrayList<UserInfo> userInfoList, YyyyMmDdHolder startYyyyMmDd, YyyyMmDdHolder endYyyyMmDd) {
        HashMap<String, PhaseInfo> phaseCheckMap = this.createPhaseCheckMap(phaseInfoList);
        this.createPhaseEvmResultMap(projectUnit, aujsd, userInfoList, startYyyyMmDd, endYyyyMmDd, phaseCheckMap);
        for (PhaseInfo phaseInfo : phaseInfoList.getPhaseInfoList()) {
            if (this.phaseEvmResultMap.containsKey(phaseInfo.getName())) {
                this.evmResultDataList.add(this.phaseEvmResultMap.get(phaseInfo.getName()));
                continue;
            }
            this.evmResultDataList.add(new OneEvmResultData(phaseInfo.getName()));
        }
    }

    private HashMap<String, PhaseInfo> createPhaseCheckMap(PhaseInfoList phaseInfoList) {
        HashMap<String, PhaseInfo> phaseCheckMap = new HashMap<String, PhaseInfo>();
        for (PhaseInfo phaseInfo : phaseInfoList.getPhaseInfoList()) {
            phaseCheckMap.put(phaseInfo.getName(), phaseInfo);
        }
        return phaseCheckMap;
    }

    private void createPhaseEvmResultMap(ProjectUnit projectUnit, AllUserJScheduleData aujsd, ArrayList<UserInfo> userInfoList, YyyyMmDdHolder startYyyyMmDd, YyyyMmDdHolder endYyyyMmDd, HashMap<String, PhaseInfo> phaseCheckMap) {
        for (UserInfo userInfo : userInfoList) {
            JScheduleData jsd = aujsd.getJScheduleData(userInfo);
            this.createPhaseEvmResultMap2(projectUnit, jsd, startYyyyMmDd, endYyyyMmDd, userInfo, phaseCheckMap);
        }
    }

    private void createPhaseEvmResultMap2(ProjectUnit projectUnit, JScheduleData jsd, YyyyMmDdHolder startYyyyMmDd, YyyyMmDdHolder endYyyyMmDd, UserInfo userInfo, HashMap<String, PhaseInfo> phaseCheckMap) {
        YyyyMmDdHolder targetYyyyMmDd = new YyyyMmDdHolder(startYyyyMmDd.getYyyy(), startYyyyMmDd.getMm(), startYyyyMmDd.getDd());
        while (this.checkYyyyMmDd(targetYyyyMmDd, endYyyyMmDd)) {
            ArrayList<ScheduleData> sdList = jsd.getDayScheduleList2(targetYyyyMmDd);
            for (ScheduleData sd : sdList) {
                if (!projectUnit.getName().equals(sd.getProjectUnitName())) continue;
                this.setPhaseEvmResultMap(sd);
                if (phaseCheckMap.containsKey(sd.getPhaseName())) continue;
                this.setNoPhaseScheduleData(userInfo, sd);
            }
            targetYyyyMmDd.inclementDd();
        }
    }

    private void setNoPhaseScheduleData(UserInfo userInfo, ScheduleData sd) {
        if (this.noPhaseScheduleDataMap.containsKey(userInfo.getUserId())) {
            this.noPhaseScheduleDataMap.get(userInfo.getUserId()).add(sd);
        } else {
            ArrayList<ScheduleData> sdList = new ArrayList<ScheduleData>();
            sdList.add(sd);
            this.noPhaseScheduleDataMap.put(userInfo.getUserId(), sdList);
        }
    }

    private void setPhaseEvmResultMap(ScheduleData sd) {
        OneEvmResultData oerd = this.phaseEvmResultMap.containsKey(sd.getPhaseName()) ? this.phaseEvmResultMap.get(sd.getPhaseName()) : new OneEvmResultData(sd.getPhaseName());
        oerd.addResult(sd.getS_date(), sd.getTimeByMinute(), sd.getProgressRatio());
        this.phaseEvmResultMap.put(sd.getPhaseName(), oerd);
    }

    private boolean checkYyyyMmDd(YyyyMmDdHolder targetYyyyMmDd, YyyyMmDdHolder endYyyyMmDd) {
        DateInfo endDi;
        DateInfo targetDi = new DateInfo(targetYyyyMmDd.getYyyy(), targetYyyyMmDd.getMm(), targetYyyyMmDd.getDd(), "00", "00");
        return targetDi.compareDateInfo(endDi = new DateInfo(endYyyyMmDd.getYyyy(), endYyyyMmDd.getMm(), endYyyyMmDd.getDd(), "00", "00")) != 1;
    }

    public ArrayList<OneEvmResultData> getOneEvmResultDataList() {
        return this.evmResultDataList;
    }

    public void printNoPhaseSchedule() {
        Set<String> userIdList = this.noPhaseScheduleDataMap.keySet();
        System.out.println("--------\u5de5\u7a0b\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u306a\u3044\u30c7\u30fc\u30bf\uff08\u3053\u3053\u304b\u3089\uff09--------");
        for (String userId : userIdList) {
            for (ScheduleData sd : this.noPhaseScheduleDataMap.get(userId)) {
                System.out.println(String.valueOf(userId) + "," + sd.getS_date().createDateInfoKey() + "," + sd.getTitle() + "," + sd.getProjectUnitName() + "," + sd.getPhaseName());
            }
        }
        System.out.println("--------\u5de5\u7a0b\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u306a\u3044\u30c7\u30fc\u30bf\uff08\u3053\u3053\u307e\u3067\uff09--------");
    }
}

