/*
 * Decompiled with CFR 0.152.
 */
package commonData;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MmDdHolder {
    private String targetMm = "";
    private String targetDd = "";
    private boolean overYyyyFlag = false;

    public MmDdHolder() {
    }

    public MmDdHolder(String mm, String dd) {
        this.setTargetMm(mm);
        this.setTargetDd(dd);
    }

    public String getTargetMm() {
        return this.targetMm;
    }

    public boolean setTargetMm(String targetMm) {
        if (this.checkMmRange(targetMm)) {
            this.targetMm = String.format("%02d", Integer.valueOf(targetMm));
            return true;
        }
        return false;
    }

    public String getTargetDd() {
        return this.targetDd;
    }

    public boolean setTargetDd(String targetDd) {
        if (this.checkDdRange(targetDd)) {
            this.targetDd = String.format("%02d", Integer.valueOf(targetDd));
            return true;
        }
        return false;
    }

    private boolean checkMmRange(String mm) {
        try {
            return Integer.valueOf(mm) > 0 && Integer.valueOf(mm) < 13;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean checkDdRange(String dd) {
        try {
            return Integer.valueOf(dd) > 0 && Integer.valueOf(dd) < 32;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean compareUnder(MmDdHolder targetMmDdHolder) {
        if (this.overYyyyFlag) {
            return false;
        }
        return this.getTotalValue() <= targetMmDdHolder.getTotalValue();
    }

    public boolean incrementDd(String yyyy) {
        boolean result = false;
        int intMm = Integer.valueOf(this.targetMm);
        int intDd = Integer.valueOf(this.targetDd);
        Calendar cal = Calendar.getInstance();
        try {
            cal.set(1, Integer.valueOf(yyyy));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            System.err.println(String.valueOf(this.getClass().getName()) + " yyyy :" + yyyy);
        }
        cal.set(2, intMm - 1);
        int monthDays = cal.getActualMaximum(5);
        if (intDd < monthDays) {
            ++intDd;
        } else if (intMm < 12) {
            ++intMm;
            intDd = 1;
        } else {
            intMm = 1;
            intDd = 1;
            this.overYyyyFlag = true;
            result = true;
        }
        this.setTargetMm(Integer.toString(intMm));
        this.setTargetDd(Integer.toString(intDd));
        return result;
    }

    public boolean incrementDd(int daysOfMonth) {
        boolean result = false;
        int intMm = Integer.valueOf(this.targetMm);
        int intDd = Integer.valueOf(this.targetDd);
        if (intDd < daysOfMonth) {
            ++intDd;
        } else if (intMm < 12) {
            ++intMm;
            intDd = 1;
        } else {
            intMm = 1;
            intDd = 1;
            this.overYyyyFlag = true;
            result = true;
        }
        this.setTargetMm(Integer.toString(intMm));
        this.setTargetDd(Integer.toString(intDd));
        return result;
    }

    private int getTotalValue() {
        int totalValue = Integer.valueOf(this.targetMm) * 100;
        return totalValue += Integer.valueOf(this.targetDd).intValue();
    }

    public void setToday() {
        Date nowDate = new Date();
        SimpleDateFormat sdMm = new SimpleDateFormat("MM");
        SimpleDateFormat sdDd = new SimpleDateFormat("dd");
        this.setTargetMm(sdMm.format(nowDate));
        this.setTargetDd(sdDd.format(nowDate));
    }
}

