/*
 * Decompiled with CFR 0.152.
 */
package commonData;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedNumeralDocument
extends PlainDocument {
    static final long serialVersionUID = 1L;
    private int limit;

    public LimitedNumeralDocument(int limit) {
        this.limit = limit;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null || str.length() == 0) {
            return;
        }
        if (str.length() + this.getLength() > this.limit) {
            return;
        }
        String strNew = new String();
        char[] strings = str.toCharArray();
        int i = 0;
        while (i < strings.length) {
            char ch = strings[i];
            if (!LimitedNumeralDocument.isNumeral(ch)) {
                strNew = String.valueOf(strNew) + String.valueOf(ch);
            }
            ++i;
        }
        super.insertString(offs, strNew, a);
    }

    private static boolean isNumeral(char ch) {
        return ch < '0' || ch > '9';
    }
}

