/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.common.action.MosPWorkflowAction;
import jp.mosp.workflow.dto.AmRouteDto;
import jp.mosp.workflow.dto.AmUnitDto;
import jp.mosp.workflow.vo.ApprovalRouteCardVo;

/**
 * @author yoshida
 *
 */
public class ApprovalRouteCardAction extends MosPWorkflowAction {
	
	// R}h
	private static final String	CMD_ROUTE_CARD_SHOW		= "S2825";	// \(ǉ)
	private static final String	CMD_ROUTE_CARD_SELECT	= "S2826";	// \(I)
	private static final String	CMD_ROUTE_CARD_INSERT	= "S2827";	// o^
	private static final String	CMD_ROUTE_CARD_UPDATE	= "S2828";	// XV
																	
	
	/**
	 * RXgN^
	 */
	public ApprovalRouteCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_ROUTE_CARD_SHOW)) {
			show();
		} else if (cmd.equals(CMD_ROUTE_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_ROUTE_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_ROUTE_CARD_UPDATE)) {
			// XV
			update();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ApprovalRouteCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// v_ẼZbg
		ApprovalRouteCardVo vo = (ApprovalRouteCardVo)getVo();
		// FjbgR[hꗗ
		vo.aryPltUnit = getUnitArrayAvailable();
		vo.setParams(request);
	}
	
	@Override
	protected void show() throws Exception {
		ApprovalRouteCardVo vo = (ApprovalRouteCardVo)getVo();
		vo.setDefaultValues();
		// [hݒ
		setMode();
	}
	
	@Override
	protected void select() throws Exception {
		ApprovalRouteCardVo vo = (ApprovalRouteCardVo)getVo();
		// f[^̎擾
		AmRouteDto dto = routeDao().findForKey(key1);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		vo.setMode(ApprovalRouteCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		ApprovalRouteCardVo vo = (ApprovalRouteCardVo)getVo();
		// p[^̑ÓmF
		vo.validate();
		// ݃`FbN
		chkDuplicate(routeDao().findForKey(vo.getTxtRouteCode()));
		// DTȌ
		AmRouteDto dto = new AmRouteDto();
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		vo.setDtoFields(dto);
		// f[^̑}
		routeDao().insert(dto);
		// DTO̍Ď擾
		dto = routeDao().findForKey(dto.getRtCode());
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ApprovalRouteCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		AmRouteDto dto = (AmRouteDto)getSessionDto();
		ApprovalRouteCardVo vo = (ApprovalRouteCardVo)getVo();
		// R[h擾
		vo.setTxtRouteCode(dto.getRtCode());
		// p[^̑ÓmF
		vo.validate();
		// rmF
		chkExclusive(dto, routeDao().findForUpdate(vo.getTxtRouteCode()));
		// DTȌ
		vo.setDtoFields(dto);
		// f[^̍XV
		routeDao().update(dto);
		// DTO̍Ď擾
		AmRouteDto retDto = routeDao().findForKey(dto.getRtCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(ApprovalRouteCardVo.MODE_UPDATE);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * FjbgR[h擾iAM_UNITj
	 * @return p\ȏFjbgR[hXg
	 * @throws Exception 	Oꍇ
	 */
	private String[][] getUnitArrayAvailable() throws Exception {
		// ̎擾
		List<AmUnitDto> listUnit = unitDao().findForSelectableUnitArray(
				DateUtil.convDateFormattedByHyphen(DateUtil.getSystemDate()));
		// z̍쐬
		String[][] aryUnit = new String[listUnit.size()][3];
		for (int i = 0; i < aryUnit.length; i++) {
			aryUnit[i][0] = listUnit.get(i).getUnitCode();
			StringBuffer sb = new StringBuffer();
			sb.append(getKName(listUnit.get(i).getMain()));
			sb.append(CommonConst.STR_2BYTE_SLASH_SEPARATOR);
			sb.append(getKName(listUnit.get(i).getAgent()));
			sb.append(CommonConst.BRACKET_LEFT);
			sb.append(DateUtil.convDateToFormatDateJPShort(listUnit.get(i).getStartDate()));
			sb.append(CommonConst.STR_TERM);
			sb.append(CommonConst.BRACKET_RIGHT);
			aryUnit[i][1] = sb.toString();
		}
		return aryUnit;
	}
	
	/**
	 * [hݒ
	 */
	private void setMode() {
		ApprovalRouteCardVo vo = (ApprovalRouteCardVo)getVo();
		// [hݒ
		if (vo.aryPltUnit.length == 0) {
			vo.setMode(ApprovalRouteCardVo.MODE_IMPOSSIBLE);
		} else {
			vo.setMode(ApprovalRouteCardVo.MODE_INSERT);
		}
	}
	
}
