/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.system.vo.CodeMasterListVo;

/**
 * @author yoshida
 *
 */
public class CodeMasterListAction extends MosPAction {
	
	// R}h
	private static final String	CMD_CODE_LIST_SHOW		= "S2020";	// \
	private static final String	CMD_CODE_LIST_SEARCH	= "S2021";	// 
	private static final String	CMD_CODE_LIST_RE_SEARCH	= "S2022";	// Č
	private static final String	CMD_CODE_LIST_SORT		= "S2023";	// \[g
																	
	
	/**
	 * RXgN^
	 */
	public CodeMasterListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CODE_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_CODE_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_CODE_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_CODE_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new CodeMasterListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		CodeMasterListVo vo = (CodeMasterListVo)getVo();
		// R[h敪v_EXg쐬
		vo.aryPltTId = getMosPCodeArray();
	}
	
	@Override
	protected void show() throws Exception {
		CodeMasterListVo vo = (CodeMasterListVo)getVo();
		// lɃZbg
		vo.setSearchmode(CodeMasterListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		CodeMasterListVo vo = (CodeMasterListVo)getVo();
		vo.setParams(request);
		searchCodeList();
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(CodeMasterListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		CodeMasterListVo vo = (CodeMasterListVo)getVo();
		if (vo.getSearchmode() == CodeMasterListVo.SEARCH_ON) {
			removeSessionDto();
			searchCodeList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * R[hXg
	 * @throws Exception   Oꍇ
	 */
	private void searchCodeList() throws Exception {
		CodeMasterListVo vo = (CodeMasterListVo)getVo();
		// 
		vo.setFields(part().mospcode().getMCodeDao().findForSearch(vo.getPltTId(), vo.getTxtTCode(), vo.getTxtTName()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryTCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		CodeMasterListVo vo = (CodeMasterListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		CodeMasterListVo vo = (CodeMasterListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		CodeMasterListVo vo = (CodeMasterListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_T_ID)) {
			comp = new CompTId();
		} else if (key.equals(vo.KEY_T_CODE)) {
			comp = new CompTCode();
		} else if (key.equals(vo.KEY_T_NAME)) {
			comp = new CompTName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * R[hɂrNX
	 */
	protected static class CompTId implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 7210303772053153377L;
		

		public int compare(Object obj1, Object obj2) {
			MCodeDto dto1 = (MCodeDto)obj1;
			MCodeDto dto2 = (MCodeDto)obj2;
			return dto1.getTId().compareTo(dto2.getTId());
		}
	}
	
	/**
	 * R[hɂrNX
	 */
	protected static class CompTCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 5672044129524635759L;
		

		public int compare(Object obj1, Object obj2) {
			MCodeDto dto1 = (MCodeDto)obj1;
			MCodeDto dto2 = (MCodeDto)obj2;
			return dto1.getTCode().compareTo(dto2.getTCode());
		}
	}
	
	/**
	 * R[ĥɂrNX
	 */
	protected static class CompTName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -8615320106870669507L;
		

		public int compare(Object obj1, Object obj2) {
			MCodeDto dto1 = (MCodeDto)obj1;
			MCodeDto dto2 = (MCodeDto)obj2;
			return dto1.getTName().compareTo(dto2.getTName());
		}
	}
	
}
