/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dao.MCodeDao;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.system.vo.CodeMasterCardVo;

/**
 * @author yoshida
 *
 */
public class CodeMasterCardAction extends MosPAction {
	
	// R}h
	private static final String	CMD_CODE_CARD_SHOW		= "S2025";	// \(ǉ)
	private static final String	CMD_CODE_CARD_SELECT	= "S2026";	// \(I)
	private static final String	CMD_CODE_CARD_INSERT	= "S2027";	// o^
	private static final String	CMD_CODE_CARD_UPDATE	= "S2028";	// XV
	private static final String	CMD_CODE_CARD_DELETE	= "S2029";	// 폜
																	
	
	/**
	 * RXgN^
	 */
	public CodeMasterCardAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CODE_CARD_SHOW)) {
			// \(VK)
			show();
		} else if (cmd.equals(CMD_CODE_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_CODE_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_CODE_CARD_UPDATE)) {
			// XV
			update();
		} else if (cmd.equals(CMD_CODE_CARD_DELETE)) {
			// 폜
			delete();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new CodeMasterCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		CodeMasterCardVo vo = (CodeMasterCardVo)getVo();
		// R[h敪v_EXg쐬
		vo.aryPltTId = getMosPCodeArray();
	}
	
	@Override
	protected void show() {
		CodeMasterCardVo vo = (CodeMasterCardVo)getVo();
		vo.setPltTId("");
		vo.setTxtTCode("");
		vo.setTxtTName("");
		vo.setTxtTChange("");
		vo.setMode(CodeMasterCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		CodeMasterCardVo vo = (CodeMasterCardVo)getVo();
		// f[^̎擾
		MCodeDto dto = part().mospcode().findForKey(key1, key2);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		setMode();
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		CodeMasterCardVo vo = (CodeMasterCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		MCodeDto dto = new MCodeDto();
		vo.setDtoFields(dto);
		// DAȌ
		MCodeDao dao = part().mospcode().getMCodeDao();
		// ݃`FbN
		chkDuplicate(dao.findForKey(dto.getTId(), dto.getTCode()));
		// f[^̑}
		dao.insert(dto);
		// DTO̍Ď擾
		MCodeDto retDto = dao.findForKey(dto.getTId(), dto.getTCode());
		chkInsert(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		MCodeDto dto = (MCodeDto)getSessionDto();
		CodeMasterCardVo vo = (CodeMasterCardVo)getVo();
		vo.setParams(request);
		// R[h敪擾
		vo.setPltTId(dto.getTId());
		vo.setTxtTCode(dto.getTCode());
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto);
		// DAȌ
		MCodeDao dao = part().mospcode().getMCodeDao();
		// rmF
		chkExclusive(dto, dao.findForUpdate(dto.getTId(), dto.getTCode()));
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		MCodeDto retDto = dao.findForKey(dto.getTId(), dto.getTCode());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		setMode();
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	/**
	 * f[^폜
	 * @throws Exception 	Oꍇ
	 */
	private void delete() throws Exception {
		// DTO̎擾
		MCodeDto dto = (MCodeDto)getSessionDto();
		CodeMasterCardVo vo = (CodeMasterCardVo)getVo();
		// f[^̍폜
		part().mospcode().getMCodeDao().delete(dto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(CodeMasterCardVo.MODE_INSERT);
		// bZ[Wݒ
		vo.setMessage(getMessage(MospConst.MSG_DELETE, ""));
	}
	
	/**
	 * [hݒ
	 * @throws Exception 	Oꍇ
	 */
	private void setMode() throws Exception {
		CodeMasterCardVo vo = (CodeMasterCardVo)getVo();
		// [hݒ
		if (hasSystemAuth()) {
			vo.setMode(CodeMasterCardVo.MODE_SYSTEM);
		} else {
			vo.setMode(CodeMasterCardVo.MODE_UPDATE);
		}
	}
	
}
