/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.DetailMoneyDto;

/**
 * e햾׃e[u𑀍@\񋟂B<br><br>
 * {@link DetailMoneyDto}pāADBJavavOԂŃR[hLB<br>
 */
public class DetailMoneyDao extends PayrollDao {
	
	/**
	 *  L[1B<br>
	 */
	public static final String	KEY_01			= "KCODE";
	
	/**
	 *  L[2B<br>
	 */
	public static final String	KEY_02			= "CALC_DATE";
	
	/**
	 *  L[3B<br>
	 */
	public static final String	KEY_03			= "DETAIL_CODE";
	
	public static final String	COL_KCODE		= "KCODE";
	public static final String	COL_CALC_DATE	= "CALC_DATE";
	public static final String	COL_DETAIL_CODE	= "DETAIL_CODE";
	public static final String	COL_AMOUNT		= "AMOUNT";
	

	/**
	 * {@link PayrollDao#PayrollDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * sB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public DetailMoneyDao(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		super(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * ʂDTOƂĎ擾B<br>
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	protected DetailMoneyDto mapping() throws SQLException {
		DetailMoneyDto dto = new DetailMoneyDto();
		dto.setKCode(rs.getString(COL_KCODE));
		dto.setCalcDate(rs.getDate(COL_CALC_DATE));
		dto.setDetailCode(rs.getString(COL_DETAIL_CODE));
		dto.setAmount(rs.getInt(COL_AMOUNT));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * ʂDTOListƂĎ擾B<br>
	 * @return ʃXg
	 * @throws SQLException
	 */
	private List<DetailMoneyDto> mappingAll() throws SQLException {
		List<DetailMoneyDto> all = new ArrayList<DetailMoneyDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ɂf[^擾B<br>
	 * @param kCode     ЈR[h
	 * @param calcDate vZN
	 * @return (DTOList)
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public List<DetailMoneyDto> find(String kCode, Date calcDate) throws SQLException, NoSuchFieldException,
			IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_CALC_DATE + " = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setDateParam(index++, calcDate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}B<br>
	 * @param list }ΏۃXg
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 */
	public int insert(List<?> list) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (list == null || list.size() == 0) {
				return 0;
			}
			int count = 0;
			int max = 3; // xɍXV郌R[h̍ől
			// }
			index = 1;
			prepareStatement(getInsertQuery(getClass(), list.size(), max));
			for (int i = 0; i < list.size(); i++) {
				setParams((DetailMoneyDto)list.get(i), true);
				executeUpdate(getClass(), list.size(), max, i);
				count += cnt;
			}
			return count;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂ폜sB
	 * @param calcDate vZN
	 * @return 폜()
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public int delete(Date calcDate) throws SQLException, NoSuchFieldException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("DELETE FROM " + getTable(getClass()) + " ");
		sb.append("WHERE ");
		sb.append(COL_CALC_DATE + " = ? ");
		try {
			prepareStatement(sb.toString());
			setDateParam(index++, calcDate);
			executeUpdate(false);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂ폜sB
	 * @param kCode    ЈR[h
	 * @param calcDate vZN
	 * @return 폜()
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public int delete(String kCode, Date calcDate) throws SQLException, NoSuchFieldException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("DELETE FROM " + getTable(getClass()) + " ");
		sb.append("WHERE ");
		sb.append(COL_KCODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_CALC_DATE + " = ? ");
		try {
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			setDateParam(index++, calcDate);
			executeUpdate(false);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ肷B<br>
	 * @param dto      XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException
	 */
	private void setParams(DetailMoneyDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode());
		setDateParam(index++, dto.getCalcDate());
		setParam(index++, dto.getDetailCode());
		setParam(index++, dto.getAmount());
		setCommonParams(isInsert);
	}
	
	/**
	 * ɂf[^擾B(ЈR[hAvZNA׃R[h)<br>
	 * @param kCode     ЈR[h
	 * @param calcDate vZN
	 * @return (DTOList)
	 * @throws SQLException 
	 * @throws IllegalAccessException 
	 * @throws NoSuchFieldException 
	 */
	public DetailMoneyDto findDetailCode(String kCode, Date calcDate, String detailCode) throws SQLException,
			NoSuchFieldException, IllegalAccessException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE + " = ? ");
		sb.append("AND ");
		sb.append(COL_CALC_DATE + " = ? ");
		sb.append("AND ");
		sb.append(COL_DETAIL_CODE + " = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setDateParam(index++, calcDate);
			setParam(index++, detailCode);
			executeQuery();
			DetailMoneyDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
}
