/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.BankFrikomListDto;

/**
 * @author koike
 *
 */
public class BankFrikomListDao extends PayrollDao {
	
//	 
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE				= PhPaymentDao.COL_KCODE;
	/**
	 * vZN
	 */
	public static final String	COL_CALC_DATE			= PhPaymentDao.COL_CALC_MONTH;
	/**
	 * ^x
	 */
	public static final String	COL_PAYDAY				= PhPaymentDao.COL_PAY_DATE;
	/**
	 * Ј
	 */
	public static final String	COL_K_NAME				= MKihonPayrollDao.COL_SIMEI;
	/**
	 * x@A
	 */
	public static final String	COL_MEANS_SEQUENCE		= CmPaymentMeansDao.COL_MEANS_SEQUENCE;
	/**
	 * x敪
	 */
	public static final String	COL_ALLOWANCE_TYPE		= CmPaymentMeansDao.COL_ALLOWANCE_TYPE;
	/**
	 * ЋsR[h
	 */
	public static final String	COL_CO_BANK_CODE		= CmPaymentMeansDao.COL_CO_BANK_CODE;
	/**
	 * Ћs
	 */
	public static final String	COL_CO_BANK_NAME		= CmBankDao.COL_BANK_NAME;
	/**
	 * Ћsض
	 */
	public static final String	COL_CO_BANK_KANA		= CmBankDao.COL_BANK_KANA;
	/**
	 * UsR[h
	 */
	public static final String	COL_PAID_BANK_CODE		= CmPaymentMeansDao.COL_PAID_BANK_CODE;
	/**
	 * Us
	 */
	public static final String	COL_PAID_BANK_NAME		= CmBankDao.COL_BANK_NAME;
	/**
	 * Usض
	 */
	public static final String	COL_PAID_BANK_KANA		= CmBankDao.COL_BANK_KANA;
	/**
	 * UsxXR[h
	 */
	public static final String	COL_PAID_BRANCH_CODE	= CmPaymentMeansDao.COL_PAID_BRANCH_CODE;
	/**
	 * UsxX
	 */
	public static final String	COL_PAID_BRANCH_NAME	= CmBranchDao.COL_BRANCH_NAME;
	/**
	 * UsxXض
	 */
	public static final String	COL_PAID_BRANCH_KANA	= CmBranchDao.COL_BRANCH_KANA;
	/**
	 * a敪
	 */
	public static final String	COL_ACCOUNT_TYPE		= CmPaymentMeansDao.COL_ACCOUNT_TYPE;
	/**
	 * ԍ
	 */
	public static final String	COL_ACCOUNT_NO			= CmPaymentMeansDao.COL_ACCOUNT_NO;
	/**
	 * `
	 */
	public static final String	COL_HOLDER_NAME			= CmPaymentMeansDao.COL_HOLDER_NAME;
	/**
	 * `ض
	 */
	public static final String	COL_HOLDER_KANA			= CmPaymentMeansDao.COL_HOLDER_KANA;
	/**
	 * x@
	 */
	public static final String	COL_PAYMENT_MEANS		= CmPaymentMeansDao.COL_PAYMENT_MEANS;
	/**
	 * z敪
	 */
	public static final String	COL_AMOUNT_TYPE			= CmPaymentMeansDao.COL_AMOUNT_TYPE;
	/**
	 * ЋsR[h
	 */
	public static final String	COL_CO_BANK_CODE_CO		= CmCoBankDao.COL_CO_BANK_CODE;
	
	/**
	 * 
	 */
	public static final String	COL_BANK_PAY_AMOUNT		= "BANK_PAY_AMOUNT";
	/**
	 * 
	 */
	public static final String	COL_BANK_CD				= "BANK_CODE";
	/**
	 * 
	 */
	public static final String	COL_BRANCH_CD			= "BRANCH_CODE";
	/**
	 * 
	 */
	public static final String	CM_CODE_TABLE			= "CM_CODE";
	/**
	 * 
	 */
	public static final String	COL_T_CODE				= "T_CODE";
	/**
	 * 
	 */
	public static final String	COL_T_NAME				= "T_NAME";
	/**
	 * 
	 */
	public static final String	COL_DETAIL_CODE_PS011	= "PS011";
	/**
	 * 
	 */
	public static final String	COL_DETAIL_CODE_PS012	= "PS012";
	

	/**
	 * RXgN^
	 */
	public BankFrikomListDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<BankFrikomListDto> mappingAll() throws SQLException {
		List<BankFrikomListDto> all = new ArrayList<BankFrikomListDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return AdjustmentListDto NR[h
	 * @throws SQLException SQLOꍇ
	 */
	private BankFrikomListDto mapping() throws SQLException {
		BankFrikomListDto dto = new BankFrikomListDto();
		dto.setKCode(rs.getString(COL_K_CODE)); // ЈR[h
		dto.setCalcDate(rs.getDate(COL_CALC_DATE)); // vZN
		dto.setPayday(rs.getDate(COL_PAYDAY)); // ^x
		dto.setKName(rs.getString(COL_K_NAME)); // Ј
		dto.setBankPayAmount(rs.getInt(COL_BANK_PAY_AMOUNT)); // sUz
		dto.setAllowanceType(rs.getString(COL_ALLOWANCE_TYPE)); // x敪
		dto.setCoBankCode(rs.getString(COL_CO_BANK_CODE)); // ЋsR[h
		dto.setBankCode(rs.getString("COBANKCODE")); // Ћs̋sR[h
		dto.setCoBankName(rs.getString("COBANKNAME")); // Ћs
		dto.setCoBankKana(rs.getString("COBANKKANA")); // Ћsض
		dto.setBranchCode(rs.getString("COBRANCHCODE")); // Ћs̎xXR[h
		dto.setCoBranchName(rs.getString("COBRANCHNAME")); // ЎxX
		dto.setCoBranchKana(rs.getString("COBRANCHKANA")); // ЎxXض
		dto.setPaidBankCode(rs.getString(COL_PAID_BANK_CODE)); // UsR[h
		dto.setPaidBankName(rs.getString("PAIDBANKNAME")); // Us
		dto.setPaidBankKana(rs.getString("PAIDBANKKANA")); // Usض
		dto.setPaidBranchCode(rs.getString(COL_PAID_BRANCH_CODE)); // UsxXR[h
		dto.setPaidBranchName(rs.getString("PAIDBRANCHNAME")); // UsxX
		dto.setPaidBranchKana(rs.getString("PAIDBRANCHKANA")); // UsxXض
		dto.setMeansSequence(rs.getInt(COL_MEANS_SEQUENCE)); // x@A
		dto.setAccountType(rs.getString(COL_ACCOUNT_TYPE)); // a敪
		dto.setAccountName(rs.getString(COL_T_NAME)); // a敪
		dto.setCoAccountName(rs.getString("CO_T_NAME")); // a敪(Ћs)
		dto.setAccountNo(rs.getString("ACCOUNT_NO")); // ԍ
		dto.setCoAccountNo(rs.getString("CO_ACCOUNT_NO")); // ԍ(Ћs)
		dto.setHolderName(rs.getString(COL_HOLDER_NAME)); // `
		dto.setHolderKana(rs.getString(COL_HOLDER_KANA)); // `ض
		dto.setPaymentMeans(rs.getString(COL_PAYMENT_MEANS)); // x@
		dto.setAmountType(rs.getString(COL_AMOUNT_TYPE)); // z敪
		return dto;
	}
	
	/**
	 * ɂNf[^擾
	 * @param calcDate Ώ۔N
	 * @return List (DTOList)
	 * @throws SQLException SQLOꍇ
	 */
	public List<BankFrikomListDto> findForCondition(Date calcDate) throws SQLException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			setBankPayment(sb, 1);
			sb.append(" UNION ALL ");
			setBankPayment(sb, 2);
			sb.append(" ");
			sb.append(getOrderBy());
			sb.append(COL_CO_BANK_CODE);
			sb.append(" , ");
			sb.append(COL_PAID_BANK_CODE);
			sb.append(", ");
			sb.append(COL_PAID_BRANCH_CODE);
			sb.append(", ");
			sb.append(COL_K_CODE);
			prepareStatement(sb.toString());
			//^̏ꍇvZݒ
			setDateParam(index++, calcDate);
			setDateParam(index++, calcDate);
			setDateParam(index++, calcDate);
			setDateParam(index++, calcDate);
			setDateParam(index++, calcDate);
			setDateParam(index++, calcDate);
			// s
			executeQuery();
			List<BankFrikomListDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	private void setBankPayment(StringBuffer sb, int bankPayAmount) {
		sb.append("SELECT ");
		sb.append(" PHPAY.");
		sb.append(COL_K_CODE);
		sb.append(", ");
		sb.append(" PHPAY.");
		sb.append(COL_CALC_DATE);
		sb.append(", ");
		sb.append(" PHPAY.");
		sb.append(COL_PAYDAY);
		sb.append(", ");
		sb.append(" MKIHON.");
		sb.append(COL_K_NAME);
		sb.append(", ");
		if (bankPayAmount == 1) {
			sb.append(" PDPAY.");
			sb.append(PdPaySumDao.COL_AMOUNT + " AS " + COL_BANK_PAY_AMOUNT);
			
		} else {
			sb.append(" PDPAY.");
			sb.append(PdPaySumDao.COL_AMOUNT + " AS " + COL_BANK_PAY_AMOUNT);
		}
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_MEANS_SEQUENCE);
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_ALLOWANCE_TYPE);
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_CO_BANK_CODE);
		sb.append(", ");
		sb.append(" COCMBANK.");
		sb.append(COL_BANK_CD + " AS COBANKCODE ");
		sb.append(", ");
		sb.append(" COCMBANK.");
		sb.append(COL_CO_BANK_NAME + " AS COBANKNAME ");
		sb.append(", ");
		sb.append(" COCMBANK.");
		sb.append(COL_CO_BANK_KANA + " AS COBANKKANA ");
		sb.append(", ");
		sb.append(" COCMBRANCH.");
		sb.append(COL_BRANCH_CD + " AS COBRANCHCODE ");
		sb.append(", ");
		sb.append(" COCMBRANCH.");
		sb.append(COL_PAID_BRANCH_NAME + " AS COBRANCHNAME ");
		sb.append(", ");
		sb.append(" COCMBRANCH.");
		sb.append(COL_PAID_BRANCH_KANA + " AS COBRANCHKANA ");
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_PAID_BANK_CODE);
		sb.append(", ");
		sb.append(" CMBANK.");
		sb.append(COL_PAID_BANK_NAME + " AS PAIDBANKNAME ");
		sb.append(", ");
		sb.append(" CMBANK.");
		sb.append(COL_PAID_BANK_KANA + " AS PAIDBANKKANA ");
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_PAID_BRANCH_CODE);
		sb.append(", ");
		sb.append(" CMBRANCH.");
		sb.append(COL_PAID_BRANCH_NAME + " AS PAIDBRANCHNAME ");
		sb.append(", ");
		sb.append(" CMBRANCH.");
		sb.append(COL_PAID_BRANCH_KANA + " AS PAIDBRANCHKANA ");
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_ACCOUNT_TYPE);
		sb.append(", ");
		sb.append(" CMCODE.");
		sb.append(COL_T_NAME + " AS T_NAME ");
		sb.append(", ");
		sb.append(" COCMCODE.");
		sb.append(COL_T_NAME + " AS CO_T_NAME ");
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_ACCOUNT_NO + " AS ACCOUNT_NO ");
		sb.append(", ");
		sb.append(" COBANK3.");
		sb.append(COL_ACCOUNT_NO + " AS CO_ACCOUNT_NO ");
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_HOLDER_NAME);
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_HOLDER_KANA);
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_PAYMENT_MEANS);
		sb.append(", ");
		sb.append(" CMPAY.");
		sb.append(COL_AMOUNT_TYPE);
		sb.append(" FROM ");
		sb.append(CmPaymentMeansDao.TABLE + " CMPAY");
		sb.append(" INNER JOIN " + PdPaySumDao.TABLE + " PDPAY");
		sb.append(" ON PDPAY.KCODE = CMPAY.K_CODE ");
		sb.append(" INNER JOIN " + MKihonPayrollDao.TABLE + " MKIHON");
		sb.append(" ON MKIHON.KCODE = CMPAY.K_CODE ");
		
		sb.append(" INNER JOIN " + PhPaymentDao.TABLE + " PHPAY");
		sb.append(" ON PHPAY.KCODE = CMPAY.K_CODE AND PHPAY.CALC_MONTH = ? ");
		
		sb.append(" LEFT JOIN " + CmBankDao.TABLE + " COCMBANK");
		sb.append(" ON COCMBANK.BANK_CODE");
		sb.append(" = ");
		sb.append(" (SELECT ");
		sb.append(" COBANK. ");
		sb.append(COL_BANK_CD);
		sb.append(" FROM ");
		sb.append(CmCoBankDao.TABLE + " COBANK ");
		sb.append(" WHERE ");
		sb.append(" COBANK.CO_BANK_CODE = CMPAY.CO_BANK_CODE) ");
		
		sb.append(" LEFT JOIN " + CmBranchDao.TABLE + " COCMBRANCH");
		sb.append(" ON COCMBRANCH.BANK_CODE ");
		sb.append(" = ");
		sb
			.append(" (SELECT  COBANK. BANK_CODE FROM CM_CO_BANK COBANK  WHERE  COBANK.CO_BANK_CODE = CMPAY.CO_BANK_CODE) ");
		sb.append(" AND ");
		sb.append(" COCMBRANCH.BRANCH_CODE ");
		sb.append(" = ");
		sb
			.append(" (SELECT  COBRANCH.BRANCH_CODE FROM CM_CO_BANK COBRANCH  WHERE COBRANCH.CO_BANK_CODE = CMPAY.CO_BANK_CODE) ");
		
		sb.append(" LEFT JOIN " + CmBankDao.TABLE + " CMBANK ");
		sb.append(" ON CMBANK.BANK_CODE = CMPAY.PAID_BANK_CODE ");
		sb.append(" LEFT JOIN " + CmBranchDao.TABLE + " CMBRANCH ");
		sb.append(" ON CMBRANCH.BANK_CODE = CMPAY.PAID_BANK_CODE AND CMBRANCH.BRANCH_CODE = CMPAY.PAID_BRANCH_CODE ");
		sb.append(" LEFT JOIN " + CM_CODE_TABLE + " CMCODE ");
		sb.append(" ON CMCODE.T_ID = '" + "ACCOUNT' AND CMCODE.T_CODE = CMPAY.ACCOUNT_TYPE ");
		sb.append(" LEFT JOIN " + CM_CODE_TABLE + " COCMCODE ");
		sb.append(" ON COCMCODE.T_ID = '" + "ACCOUNT' AND COCMCODE.T_CODE ");
		sb.append(" = ");
		sb.append(" (SELECT ");
		sb.append(" COBANK2. ");
		sb.append(" ACCOUNT_TYPE ");
		sb.append(" FROM ");
		sb.append(CmCoBankDao.TABLE + " COBANK2 ");
		sb.append(" WHERE ");
		sb.append(" COBANK2.CO_BANK_CODE = CMPAY.CO_BANK_CODE) ");
		sb.append(" LEFT JOIN " + CmCoBankDao.TABLE + " COBANK3 ");
		sb.append(" ON COBANK3.CO_BANK_CODE = CMPAY.CO_BANK_CODE");
		sb.append(" WHERE ");
		sb.append(" PHPAY.");
		sb.append(COL_CALC_DATE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(" CMPAY.");
		sb.append(COL_MEANS_SEQUENCE);
		sb.append(" = ");
		if (bankPayAmount == 1) {
			sb.append("'" + PayrollConst.PAYMENT_MEANS_SEQ_1 + "'");
		} else {
			sb.append("'" + PayrollConst.PAYMENT_MEANS_SEQ_2 + "'");
			
		}
		sb.append(" AND ");
		sb.append(" CMPAY.");
		sb.append(CmPaymentMeansDao.COL_PAYMENT_MEANS);
		sb.append(" = ");
		sb.append("'" + PayrollConst.PAYMENT_MEANS_ACCOUNT + "'");
		sb.append(" AND ");
		sb.append(" PDPAY.");
		sb.append("CALC_DATE");
		sb.append(" = ? ");
		sb.append(" AND ");
		if (bankPayAmount == 1) {
			sb.append(" PDPAY.");
			sb.append(PdPaySumDao.COL_DETAIL_CODE);
			sb.append(" = ");
			sb.append("'" + COL_DETAIL_CODE_PS011 + "'");
		} else {
			sb.append(" PDPAY.");
			sb.append(PdPaySumDao.COL_DETAIL_CODE);
			sb.append(" = ");
			sb.append("'" + COL_DETAIL_CODE_PS012 + "'");
			
		}
		
		sb.append(" AND ");
		if (bankPayAmount == 1) {
			sb.append(" PDPAY.");
			sb.append(PdPaySumDao.COL_AMOUNT);
			sb.append(" <> ");
			sb.append(PayrollConst.AMOUNT_ZERO);
		} else {
			sb.append(" PDPAY.");
			sb.append(PdPaySumDao.COL_AMOUNT);
			sb.append(" <> ");
			sb.append(PayrollConst.AMOUNT_ZERO);
			
		}
	}
}
