/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.utils.DateUtil;
import jp.mosp.kintai.common.dao.MKihonDao;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.AdjustmentDto;

/**
 * @author koike 
 *
 */
public class AdjustmentDao extends PayrollDao {
	
	// 
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE_KIHON			= MKihonDao.TABLE + "." + MKihonDao.COL_KCODE;
	
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE_INC_TAX			= CmIncomeTaxDao.TABLE + "." + CmIncomeTaxDao.COL_K_CODE;
	
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE_MID_ENT			= CmMidwayEnterDao.TABLE + "."
																	+ CmMidwayEnterDao.COL_K_CODE;
	/**
	 * ЈR[h
	 */
	public static final String	COL_K_CODE_ADJUST			= CdAdjustmentDao.TABLE + "." + CdAdjustmentDao.COL_K_CODE;
	
	/**
	 * Ј
	 */
	public static final String	COL_K_NAME					= MKihonDao.TABLE + "." + MKihonDao.COL_SIMEI;
	
	/**
	 * Јض
	 */
	public static final String	COL_K_KANA					= MKihonDao.TABLE + "." + MKihonDao.COL_FURIGANA;
	
	/**
	 * R[h
	 */
	public static final String	COL_STATION_CODE			= MKihonDao.TABLE + "." + MKihonDao.COL_SCODE;
	
	/**
	 * EʃR[h
	 */
	public static final String	COL_POSITION_CODE			= MKihonDao.TABLE + "." + MKihonDao.COL_YCODE;
	
	/**
	 * Г
	 */
	public static final String	COL_ENTRANCE_DATE			= MKihonDao.TABLE + "." + MKihonDao.COL_NYDATE;
	
	/**
	 * ގГ
	 */
	public static final String	COL_RETIREMENT_DATE			= MKihonDao.TABLE + "." + MKihonDao.COL_TSDATE;
	
	/**
	 * œKpN
	 */
	public static final String	COL_INC_EXPECTED_DATE		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_INC_EXPECTED_DATE;
	/**
	 * ېŋ敪
	 */
	public static final String	COL_INCOME_TAX_TYPE			= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_INCOME_TAX_TYPE;
	/**
	 * N敪
	 */
	public static final String	COL_ADJUSTMENT_TYPE			= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_ADJUSTMENT_TYPE;
	/**
	 * {lǕw敪
	 */
	public static final String	COL_SELF_WIDOW_TYPE			= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SELF_WIDOW_TYPE;
	/**
	 * {lQ敪
	 */
	public static final String	COL_SELF_HANDICAP_TYPE		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SELF_HANDICAP_TYPE;
	/**
	 * {lw敪
	 */
	public static final String	COL_SELF_STUDENT_TYPE		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SELF_STUDENT_TYPE;
	/**
	 * zҋ敪
	 */
	public static final String	COL_SPOUSE_INTEND_TYPE		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SPOUSE_INTEND_TYPE;
	/**
	 * ʕ}{e
	 */
	public static final String	COL_GENERAL_DEPENDENT		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_GENERAL_DEPENDENT;
	/**
	 * }{e
	 */
	public static final String	COL_SPECIFIC_DEPENDENT		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SPECIFIC_DEPENDENT;
	/**
	 * Vl}{e
	 */
	public static final String	COL_ELDERLY_DEPENDENT		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_ELDERLY_DEPENDENT;
	/**
	 * Ve
	 */
	public static final String	COL_LIVE_WITH_ELD_REL		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_LIVE_WITH_ELD_REL;
	/**
	 * 
	 */
	public static final String	COL_LIVE_WITH_HANDI_GE		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_LIVE_WITH_HANDI_GE;
	/**
	 * 
	 */
	public static final String	COL_LIVE_WITH_HANDI_SP		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_LIVE_WITH_HANDI_SP;
	/**
	 * Vl
	 */
	public static final String	COL_LIVE_WITH_HANDI_EL		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_LIVE_WITH_HANDI_EL;
	/**
	 * Ve
	 */
	public static final String	COL_LIVE_WITH_HANDI_ER		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_LIVE_WITH_HANDI_ER;
	/**
	 * ʏQ
	 */
	public static final String	COL_GENERAL_HANDICAP		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_GENERAL_HANDICAP;
	/**
	 * ʏQ
	 */
	public static final String	COL_SPECIFIC_HANDICAP		= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_SPECIFIC_HANDICAP;
	/**
	 * }{̐
	 */
	public static final String	COL_DEPENDENT_COUNT			= CmIncomeTaxDao.TABLE + "."
																	+ CmIncomeTaxDao.COL_DEPENDENT_COUNT;
	/**
	 * rЋ敪
	 */
	public static final String	COL_MIDWAY_TYPE				= CmMidwayEnterDao.TABLE + "."
																	+ CmMidwayEnterDao.COL_MIDWAY_TYPE;
	/**
	 * OΖz
	 */
	public static final String	COL_FORMER_INCOME			= CmMidwayEnterDao.TABLE + "."
																	+ CmMidwayEnterDao.COL_FORMER_INCOME;
	/**
	 * OΖЉیz
	 */
	public static final String	COL_FORMER_INSURANCE		= CmMidwayEnterDao.TABLE + "."
																	+ CmMidwayEnterDao.COL_FORMER_INSURANCE;
	/**
	 * OΖ揊Ŋz
	 */
	public static final String	COL_FORMER_TAX				= CmMidwayEnterDao.TABLE + "."
																	+ CmMidwayEnterDao.COL_FORMER_TAX;
	/**
	 * N
	 */
	public static final String	COL_ADJUST_YEAR				= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_ADJUST_YEAR;
	/**
	 * NvZ
	 */
	public static final String	COL_ADJUST_STATUS			= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_ADJUST_STATUS;
	/**
	 * ʂ̐ی
	 */
	public static final String	COL_GENERAL_LIFE_INS		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_GENERAL_LIFE_INS;
	/**
	 * lNی
	 */
	public static final String	COL_PRIVATE_PENSION			= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_PRIVATE_PENSION;
	/**
	 * یTz
	 */
	public static final String	COL_LIFE_INS_DEDUCTION		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_LIFE_INS_DEDUCTION;
	/**
	 * nkی
	 */
	public static final String	COL_EARTHQUAKE_INS			= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_EARTHQUAKE_INS;
	/**
	 * Qی
	 */
	public static final String	COL_LONG_TERM_DAMAGE_INS	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_LONG_TERM_DAMAGE_INS;
	/**
	 * QیTz
	 */
	public static final String	COL_DAMAGE_INS_DEDUCTION	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_DAMAGE_INS_DEDUCTION;
	/**
	 * ЉیTz
	 */
	public static final String	COL_SOCIAL_INS_DEDUCTION	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_SOCIAL_INS_DEDUCTION;
	/**
	 * K͊Ƌϓ|Tz
	 */
	public static final String	COL_MUTUAL_AID_DEDUCTION	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_MUTUAL_AID_DEDUCTION;
	/**
	 * z҂̖{N̍vžϊz
	 */
	public static final String	COL_SPOUSE_SUM_INCOME		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_SPOUSE_SUM_INCOME;
	/**
	 * zғʍTz
	 */
	public static final String	COL_SPOUSE_SP_DEDUCTION		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_SPOUSE_SP_DEDUCTION;
	/**
	 * ZؓʍTz
	 */
	public static final String	COL_HOUSE_LOAN_DEDUCTION	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_HOUSE_LOAN_DEDUCTION;
	/**
	 * xz
	 */
	public static final String	COL_ALLOWANCE_ADJUSTMENT	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_ALLOWANCE_ADJUSTMENT;
	/**
	 * ېŒz
	 */
	public static final String	COL_TAX_FREE_ADJUSTMENT		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_TAX_FREE_ADJUSTMENT;
	/**
	 * Љیz
	 */
	public static final String	COL_SOC_INS_ADJUSTMENT		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_SOC_INS_ADJUSTMENT;
	/**
	 * Œz
	 */
	public static final String	COL_TAX_INC_ADJUSTMENT		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_TAX_INC_ADJUSTMENT;
	/**
	 * 򒥎[Ev
	 */
	public static final String	COL_WITHHOLD_SLIP_NOTES		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_WITHHOLD_SLIP_NOTES;
	/**
	 * ^A蓖z
	 */
	public static final String	COL_PAYMENT_ALLOWANCE		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_PAYMENT_ALLOWANCE;
	/**
	 * ^A蓖Ŋz
	 */
	public static final String	COL_PAYMENT_INCOME_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_PAYMENT_INCOME_TAX;
	/**
	 * ܗ^z
	 */
	public static final String	COL_BONUS_ALLOWANCE			= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_BONUS_ALLOWANCE;
	/**
	 * ܗ^Ŋz
	 */
	public static final String	COL_BONUS_INCOME_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_BONUS_INCOME_TAX;
	/**
	 * rAz
	 */
	public static final String	COL_MIDWAY_ADJUST_INCOME	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_MIDWAY_ADJUST_INCOME;
	/**
	 * rAŊz
	 */
	public static final String	COL_MIDWAY_ADJUST_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_MIDWAY_ADJUST_TAX;
	/**
	 * ^T̋^̋z
	 */
	public static final String	COL_AFTER_DEDUCT_INCOME		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_AFTER_DEDUCT_INCOME;
	
	/**
	 * Љی^̍T
	 */
	public static final String	COL_PAY_INS_DEDUCTION		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_PAY_INS_DEDUCTION;
	/**
	 * zҍTzA}{TzAbTzyяQғ̍Tz̍vz
	 */
	public static final String	COL_DEPENDENTS_DEDUCTION	= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_DEPENDENTS_DEDUCTION;
	/**
	 * ېŋ^z
	 */
	public static final String	COL_CALC_TAXED_INCOME		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_CALC_TAXED_INCOME;
	/**
	 * ZoNŊz
	 */
	public static final String	COL_CALC_INCOME_TAX			= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_CALC_INCOME_TAX;
	/**
	 * NNŊz
	 */
	public static final String	COL_ADJUSTED_INCOME_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_ADJUSTED_INCOME_TAX;
	/**
	 * N藦TzŊz
	 */
	public static final String	COL_DEDUCTED_INCOME_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_DEDUCTED_INCOME_TAX;
	/**
	 * NŊz
	 */
	public static final String	COL_FINAL_INCOME_TAX		= CdAdjustmentDao.TABLE + "."
																	+ CdAdjustmentDao.COL_FINAL_INCOME_TAX;
	

	/**
	 * RXgN^
	 */
	public AdjustmentDao() {
		super();
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<AdjustmentDto> mappingAll() throws SQLException {
		List<AdjustmentDto> all = new ArrayList<AdjustmentDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return AdjustmentListDto NR[h
	 * @throws SQLException SQLOꍇ
	 */
	private AdjustmentDto mapping() throws SQLException {
		AdjustmentDto dto = new AdjustmentDto();
		dto.setKCode(rs.getString(COL_K_CODE_KIHON)); // ЈR[h
		
		dto.setKName(rs.getString(COL_K_NAME)); // Ј
		dto.setKKana(rs.getString(COL_K_KANA)); // Јض
		dto.setStationCode(rs.getString(COL_STATION_CODE)); // R[h
		dto.setPositionCode(rs.getString(COL_POSITION_CODE)); // EʃR[h
		dto.setEntranceDate(rs.getInt(COL_ENTRANCE_DATE)); // Г
		dto.setRetirementDate(rs.getInt(COL_RETIREMENT_DATE)); // ގГ
		
		dto.setIncExpectedDate(rs.getDate(COL_INC_EXPECTED_DATE)); // œKpN
		dto.setIncomeTaxType(rs.getString(COL_INCOME_TAX_TYPE)); // ېŋ敪
		dto.setAdjustmentType(rs.getString(COL_ADJUSTMENT_TYPE)); // N敪
		dto.setSelfWidowType(rs.getString(COL_SELF_WIDOW_TYPE)); // {lǕw敪
		dto.setSelfHandicapType(rs.getString(COL_SELF_HANDICAP_TYPE)); // {lQ敪
		dto.setSelfStudentType(rs.getString(COL_SELF_STUDENT_TYPE)); // {lw敪
		dto.setSpouseIntendType(rs.getString(COL_SPOUSE_INTEND_TYPE)); // zҋ敪
		dto.setGeneralDependent(rs.getInt(COL_GENERAL_DEPENDENT)); // ʕ}{e
		dto.setSpecificDependent(rs.getInt(COL_SPECIFIC_DEPENDENT)); // }{e
		dto.setElderlyDependent(rs.getInt(COL_ELDERLY_DEPENDENT)); // Vl}{e
		dto.setLiveWithEldRel(rs.getInt(COL_LIVE_WITH_ELD_REL)); // Ve
		dto.setLiveWithHandiGe(rs.getInt(COL_LIVE_WITH_HANDI_GE)); // 
		dto.setLiveWithHandiSp(rs.getInt(COL_LIVE_WITH_HANDI_SP)); // 
		dto.setLiveWithHandiEl(rs.getInt(COL_LIVE_WITH_HANDI_EL)); // Vl
		dto.setLiveWithHandiEr(rs.getInt(COL_LIVE_WITH_HANDI_ER)); // Ve
		dto.setGeneralHandicap(rs.getInt(COL_GENERAL_HANDICAP)); // ʏQ
		dto.setSpecificHandicap(rs.getInt(COL_SPECIFIC_HANDICAP)); // ʏQ
		dto.setDependentCount(rs.getInt(COL_DEPENDENT_COUNT)); // }{̐
		
		dto.setMidwayType(rs.getString(COL_MIDWAY_TYPE)); // rЋ敪
		dto.setFormerIncome(rs.getInt(COL_FORMER_INCOME)); // OΖz
		dto.setFormerInsurance(rs.getInt(COL_FORMER_INSURANCE)); // OΖЉیz
		dto.setFormerTax(rs.getInt(COL_FORMER_TAX)); // OΖ揊Ŋz
		
		dto.setAdjustYear(rs.getInt(COL_ADJUST_YEAR)); // N
		dto.setAdjustStatus(rs.getString(COL_ADJUST_STATUS)); // NvZ
		dto.setGeneralLifeIns(rs.getInt(COL_GENERAL_LIFE_INS)); // ʂ̐ی
		dto.setPrivatePension(rs.getInt(COL_PRIVATE_PENSION)); // lNی
		dto.setLifeInsDeduction(rs.getInt(COL_LIFE_INS_DEDUCTION)); // یTz
		dto.setEarthquakeIns(rs.getInt(COL_EARTHQUAKE_INS)); // nkی
		dto.setLongTermDamageIns(rs.getInt(COL_LONG_TERM_DAMAGE_INS)); // Qی
		dto.setDamageInsDeduction(rs.getInt(COL_DAMAGE_INS_DEDUCTION)); // QیTz
		dto.setSocialInsDeduction(rs.getInt(COL_SOCIAL_INS_DEDUCTION)); // ЉیTz
		dto.setMutualAidDeduction(rs.getInt(COL_MUTUAL_AID_DEDUCTION)); // K͊Ƌϓ|Tz
		dto.setSpouseSumIncome(rs.getInt(COL_SPOUSE_SUM_INCOME)); // z҂̖{N̍vžϊz
		dto.setSpouseSpDeduction(rs.getInt(COL_SPOUSE_SP_DEDUCTION)); // zғʍTz
		dto.setHouseLoanDeduction(rs.getInt(COL_HOUSE_LOAN_DEDUCTION)); // ZؓʍTz
		dto.setAllowanceAdjustment(rs.getInt(COL_ALLOWANCE_ADJUSTMENT)); // xz
		dto.setTaxFreeAdjustment(rs.getInt(COL_TAX_FREE_ADJUSTMENT)); // ېŒz
		dto.setSocInsAdjustment(rs.getInt(COL_SOC_INS_ADJUSTMENT)); // Љیz
		dto.setTaxIncAdjustment(rs.getInt(COL_TAX_INC_ADJUSTMENT)); // Œz
		dto.setWithholdSlipNotes(rs.getString(COL_WITHHOLD_SLIP_NOTES)); // 򒥎[Ev
		dto.setPaymentAllowance(rs.getInt(COL_PAYMENT_ALLOWANCE)); // ^A蓖z
		dto.setPaymentIncomeTax(rs.getInt(COL_PAYMENT_INCOME_TAX)); // ^A蓖Ŋz
		dto.setBonusAllowance(rs.getInt(COL_BONUS_ALLOWANCE)); // ܗ^z
		dto.setBonusIncomeTax(rs.getInt(COL_BONUS_INCOME_TAX)); // ܗ^Ŋz
		dto.setMidwayAdjustIncome(rs.getInt(COL_MIDWAY_ADJUST_INCOME)); // rAz
		dto.setMidwayAdjustTax(rs.getInt(COL_MIDWAY_ADJUST_TAX)); // rAŊz
		dto.setAfterDeductIncome(rs.getInt(COL_AFTER_DEDUCT_INCOME)); // ^T̋^̋z
		dto.setPayInsDeduction(rs.getInt(COL_PAY_INS_DEDUCTION)); // Љی^̍T
		dto.setDependentsDeduction(rs.getInt(COL_DEPENDENTS_DEDUCTION)); // zҍTzA}{TzAbTzyяQғ̍Tz̍vz
		dto.setCalcTaxedIncome(rs.getInt(COL_CALC_TAXED_INCOME)); // ېŋ^z
		dto.setCalcIncomeTax(rs.getInt(COL_CALC_INCOME_TAX)); // ZoNŊz
		dto.setAdjustedIncomeTax(rs.getInt(COL_ADJUSTED_INCOME_TAX)); // NNŊz
		dto.setDeductedIncomeTax(rs.getInt(COL_DEDUCTED_INCOME_TAX)); // N藦TzŊz
		dto.setFinalIncomeTax(rs.getInt(COL_FINAL_INCOME_TAX)); // NŊz
		
		return dto;
	}
	
	/**
	 * ɂNf[^擾
	 * @param adjustYear N
	 * @param lastDate NŏI
	 * @param kCode ЈR[h
	 * @param kName 
	 * @param kKana 
	 * @param retirementFlag 
	 * @param positionCode 
	 * @param adjustmentType 
	 * @param midwayType 
	 * @param adjustStatus 
	 * @return List (DTOList)
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	public List<AdjustmentDto> findForCondition(int adjustYear, Date lastDate, String kCode, String kName,
			String kKana, String retirementFlag, String positionCode, String adjustmentType, String midwayType,
			String adjustStatus) throws IllegalAccessException, SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE_KIHON + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_NAME + " LIKE ? ");
		sb.append("AND ");
		sb.append(COL_K_KANA + " LIKE ? ");
		if (retirementFlag != null && retirementFlag.equals(String.valueOf(PayrollConst.RETIREMENT_FLAG_ON))) {
			sb.append("AND ");
			sb.append(COL_RETIREMENT_DATE + " <= ? ");
		} else if (retirementFlag != null && retirementFlag.equals(String.valueOf(PayrollConst.RETIREMENT_FLAG_OFF))) {
			sb.append("AND ");
			sb.append("( ");
			sb.append(COL_RETIREMENT_DATE + " = 0 ");
			sb.append("OR ");
			sb.append(COL_RETIREMENT_DATE + " > ? ");
			sb.append(") ");
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_POSITION_CODE + " = ? ");
		}
		if (adjustmentType != null && !adjustmentType.equals("")) {
			sb.append("AND ");
			sb.append(COL_ADJUSTMENT_TYPE + " = ? ");
		}
		if (midwayType != null && !midwayType.equals("")) {
			sb.append("AND ");
			sb.append(COL_MIDWAY_TYPE + " = ? ");
		}
		if (adjustStatus != null && adjustStatus.equals(PayrollConst.ADJU_STATUS_NON)) {
			sb.append("AND ");
			sb.append(COL_ADJUST_STATUS + " IS NULL ");
		} else if (adjustStatus != null && !adjustStatus.equals("")) {
			sb.append("AND ");
			sb.append(COL_ADJUST_STATUS + " = ? ");
		}
		try {
			prepareStatement(getSelectStatement(getClass()) + getAdjustmentTable() + sb.toString());
			setParam(index++, DateUtil.convDateToInteger(lastDate));
			setParam(index++, lastDate);
			setParam(index++, adjustYear);
			setParam(index++, "%" + kCode + "%");
			setParam(index++, "%" + kName + "%");
			setParam(index++, "%" + kKana + "%");
			if (retirementFlag != null && !retirementFlag.equals("")) {
				setParam(index++, DateUtil.convDateToInteger(lastDate));
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			if (adjustmentType != null && !adjustmentType.equals("")) {
				setParam(index++, adjustmentType);
			}
			if (midwayType != null && !midwayType.equals("")) {
				setParam(index++, midwayType);
			}
			if (adjustStatus != null && !adjustStatus.equals("") && !adjustStatus.equals(PayrollConst.ADJU_STATUS_NON)) {
				setParam(index++, adjustStatus);
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂNf[^擾
	 * @param adjustDate N
	 * @param endDate    NŏI
	 * @param kCode      ЈR[h
	 * @return List (DTOList)
	 * @throws IllegalAccessException  \bhɃANZXłȂꍇ
	 * @throws SQLException SQLOꍇ
	 */
	public AdjustmentDto findForEmployee(Date adjustDate, Date endDate, String kCode) throws IllegalAccessException,
			SQLException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_K_CODE_KIHON + " = ? ");
		try {
			prepareStatement(getSelectStatement(getClass()) + getAdjustmentTable() + sb.toString());
			setParam(index++, endDate);
			setParam(index++, adjustDate);
			setParam(index++, adjustDate);
			setParam(index++, kCode);
			executeQuery();
			AdjustmentDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Nf[^r[SQL擾
	 * @return Nf[^r[擾SQL
	 * @throws IllegalAccessException \bhɃANZXłȂꍇ
	 */
	public String getAdjustmentTable() throws IllegalAccessException {
		MKihonPayrollDao kihonPayrollDao = new MKihonPayrollDao();
		CmIncomeTaxDao cmIncomeTaxDao = new CmIncomeTaxDao();
		CdAdjustmentDao cdAdjustmentDao = new CdAdjustmentDao();
		StringBuffer sb = new StringBuffer();
		sb.append(" ");
		sb.append("FROM ");
		sb.append("(");
		sb.append("(");
		sb.append("(");
		sb.append(kihonPayrollDao.getHistoryTable() + " ");
		sb.append("LEFT JOIN ");
		sb.append(cmIncomeTaxDao.getHistoryTableForDate() + " ");
		sb.append("ON " + COL_K_CODE_KIHON + " = " + COL_K_CODE_INC_TAX);
		sb.append(") ");
		sb.append("LEFT JOIN ");
		sb.append(CmMidwayEnterDao.TABLE + " ");
		sb.append("ON " + COL_K_CODE_KIHON + " = " + COL_K_CODE_MID_ENT);
		sb.append(") ");
		sb.append("LEFT JOIN ");
		sb.append(cdAdjustmentDao.getTableForDate() + " ");
		sb.append("ON " + COL_K_CODE_KIHON + " = " + COL_K_CODE_ADJUST);
		sb.append(") ");
		return sb.toString();
	}
	
}
