/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.vo;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MosPConfDto;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;

public class FirmBankingOutputVo extends PayrollVo {
	
	private static final long	serialVersionUID		= 3281945937471826907L;
	
	// URLACSS
	private static final String	RETURN_URL				= "/jsp/payroll/common/firmBankingOutput.jsp";
	private static final String	EXTRA_JS				= "/pub/payroll/common/js/firmBankingOutput.js";
	private static final String	EXTRA_CSS				= "/pub/payroll/common/css/firmBankingOutput.css";
	
	// ʃTu^Cg
	public final String			SUB_TITLE				= PayrollConst.TTL_FIRM_BANKING;
	
	public static final String	PRM_PLT_OUTPUT_DETAIL	= "pltOutputDetail";								// o͓e
	public static final String	PRM_PLT_SPECIFY_YEAR	= "pltSpecifyYear";								// wN(N)
	public static final String	PRM_PLT_SPECIFY_MONTH	= "pltSpecifyMonth";								// wN()
	public static final String	PRM_PLT_SPECIFY_DAY		= "pltSpecifyDay";									// wN()
	public static final String	PRM_PLT_CODE_TYPE		= "pltCodeType";									// R[h敪 
	public static final String	PRM_PLT_RECORD_TYPE		= "pltRecordType";									// R[h敪
	public static final String	PRM_PLT_END_RECORD		= "pltEndRecord";									// GhR[h敪
	public static final String	PRM_PLT_DEADLINE_YEAR	= "pltDeadlineYear";								// [(N)
	public static final String	PRM_PLT_DEADLINE_MONTH	= "pltDeadlineMonth";								// [()
	public static final String	PRM_PLT_DEADLINE_DAY	= "pltDeadlineDay";								// [()
	public static final String	PRM_PLT_COBANK_CODE		= "pltCobankCode";									// ЋsR[h
																											
	public static final String	PRM_TXT_COMPANY_CODE	= "txtCompanyCode";								// ЃR[h
	public static final String	PRM_TXT_RECORD_LENGTH	= "txtRecordLength";								// R[h
	public static final String	PRM_TXT_TYPE_CODE		= "txtTypeCode";									// ʃR[h
	public static final String	PRM_TXT_CO_ADDRESS		= "txtCoAddress";									// ЏZ
	public static final String	PRM_TXT_COMPANY_NAME	= "txtCompanyName";								// Ж
																											
	public final String			CMD_MENU_PAYROLL		= "P1910";
	
	// 萔
	public static final int		MODE_SHOW				= 0;
	public static final int		MODE_SELECT				= 1;
	
	// [h(0F\A1F)
	private int					mode;
	
	// tB[h
	private String				pltOutputDetail;
	private String				pltSpecifyYear;
	private String				pltSpecifyMonth;
	private String				pltSpecifyDay;
	private String				pltCodeType;
	private String				pltRecordType;
	private String				pltEndRecord;
	private String				pltDeadlineYear;
	private String				pltDeadlineMonth;
	private String				pltDeadlineDay;
	private String				pltCoBankCode;
	
	private String				txtCompanyCode;
	private String				txtRecordLength;
	private String				txtTypeCode;
	private String				txtCoAddress;
	private String				txtCompanyName;
	
	private String				key1;
	
	// tB[hyѐ
	public static final String	NAM_OUTPUT_DETAIL		= PayrollConst.NAM_OUTPUT_DETAIL;
	public static final String	NAM_SPECIFY_MONTH		= PayrollConst.NAM_SPECIFY_MONTH;
	public static final String	NAM_PAYDAY				= PayrollConst.NAM_PAYDAY;
	public static final String	NAM_CO_BANK_CODE		= PayrollConst.NAM_CO_BANK_CODE;
	public static final String	NAM_COMPANY_CODE		= PayrollConst.NAM_COMPANY_CODE;
	public static final String	NAM_RECORD_LENGTH		= PayrollConst.NAM_RECORD_LENGTH;
	public static final String	NAM_TYPE_CODE			= PayrollConst.NAM_TYPE_CODE;
	public static final String	NAM_CODE_TYPE			= PayrollConst.NAM_CODE_TYPE;
	public static final String	NAM_RECORD_TYPE			= PayrollConst.NAM_RECORD_TYPE;
	public static final String	NAM_END_RECORD			= PayrollConst.NAM_END_RECORD;
	public static final String	NAM_DEADLINE_DATE		= PayrollConst.NAM_DEADLINE_DATE;
	public static final String	NAM_CO_ADDRESS			= PayrollConst.NAM_CO_ADDRESS;
	public static final String	NAM_COMPANY_NAME		= PayrollConst.NAM_COMPANY_NAME;
	
	public static final int		LEN_FB_COMPANY_CODE		= PayrollConst.LEN_FB_COMPANY_CODE;
	public static final int		LEN_FB_RECORD_LENGTH	= PayrollConst.LEN_FB_RECORD_LENGTH;
	public static final int		LEN_FB_TYPE_CODE		= PayrollConst.LEN_FB_TYPE_CODE;
	
	public static final int		LEN_FB_CO_ADDRESS		= PayrollConst.LEN_FB_CO_ADDRESS;
	public static final int		LEN_FB_COMPANY_NAME		= PayrollConst.LEN_FB_COMPANY_NAME;
	
	// v_EXg
	public String[][]			aryPltOutputDetail;
	public String[][]			aryPltSpecifyYear;
	public String[][]			aryPltSpecifyMonth;
	public String[][]			aryPltSpecifyDay;
	public String[][]			aryPltCodeType;
	public String[][]			aryPltRecordType;
	public String[][]			aryPltEndRecord;
	public String[][]			aryPltDeadlineYear;
	public String[][]			aryPltDeadlineMonth;
	public String[][]			aryPltDeadlineDay;
	public String[][]			aryPltCoBankCode;
	
	public List<MosPConfDto>	listConf;
	
	//	 tB[h
	Date						calcDate;
	

	// p[^
	
	/**
	 * RXgN^
	 */
	public FirmBankingOutputVo() {
		super();
		setRetUrl(RETURN_URL);
		setExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
	}
	
	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		pltOutputDetail = request.getParameter(PRM_PLT_OUTPUT_DETAIL);
		pltSpecifyYear = request.getParameter(PRM_PLT_SPECIFY_YEAR);
		pltSpecifyMonth = request.getParameter(PRM_PLT_SPECIFY_MONTH);
		pltSpecifyDay = request.getParameter(PRM_PLT_SPECIFY_DAY);
		pltCodeType = request.getParameter(PRM_PLT_CODE_TYPE);
		pltRecordType = request.getParameter(PRM_PLT_RECORD_TYPE);
		pltEndRecord = request.getParameter(PRM_PLT_END_RECORD);
		pltDeadlineYear = request.getParameter(PRM_PLT_DEADLINE_YEAR);
		pltDeadlineMonth = request.getParameter(PRM_PLT_DEADLINE_MONTH);
		pltDeadlineDay = request.getParameter(PRM_PLT_DEADLINE_DAY);
		pltCoBankCode = request.getParameter(PRM_PLT_COBANK_CODE);
		
		txtCompanyCode = request.getParameter(PRM_TXT_COMPANY_CODE);
		txtRecordLength = request.getParameter(PRM_TXT_RECORD_LENGTH);
		txtTypeCode = request.getParameter(PRM_TXT_TYPE_CODE);
		txtCoAddress = request.getParameter(PRM_TXT_CO_ADDRESS);
		txtCompanyName = request.getParameter(PRM_TXT_COMPANY_NAME);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		// JimF
		// ʃR[hK{mF
		checkRequired(txtTypeCode, NAM_TYPE_CODE, PRM_TXT_TYPE_CODE);
		// ЃR[hK{mF
		checkRequired(txtCompanyCode, NAM_COMPANY_CODE, PRM_TXT_COMPANY_CODE);
		// ЏZK{mF
		checkRequired(txtCoAddress, NAM_CO_ADDRESS, PRM_TXT_CO_ADDRESS);
		// ЃJiK{mF
		checkRequired(txtCompanyName, NAM_COMPANY_NAME, PRM_TXT_COMPANY_NAME);
		// R[hK{mF
		checkRequired(txtRecordLength, NAM_RECORD_LENGTH, PRM_TXT_RECORD_LENGTH);
		// ʃR[hlmF
		checkNumeric(txtTypeCode, NAM_TYPE_CODE, PRM_TXT_TYPE_CODE);
		// ЃR[hlmF
		checkNumeric(txtCompanyCode, NAM_COMPANY_CODE, PRM_TXT_COMPANY_CODE);
		// R[hlmF
		checkNumeric(txtRecordLength, NAM_RECORD_LENGTH, PRM_TXT_RECORD_LENGTH);
		// ÓmFI
		endValidation();
	}
	
	/**
	 * vZN擾B
	 * @return vZN
	 */
	public Date getCalcDate() {
		return getDateField(calcDate);
	}
	
	/**
	 * vZNݒ肷B
	 * @param calcDate ݒ肷vZN
	 */
	public void setCalcDate(Date calcDate) {
		this.calcDate = getDateField(calcDate);
	}
	
	/**
	 * Tu^Cg擾
	 * @param subTitle Tu^Cg
	 * @param cmdMenu  j[R}h
	 * @return Tu^CgHTML
	 */
	public String getSubTitle(String subTitle, String cmdMenu) {
		String buttonName = "^vZj[";
		String cmd = "P1001";
		if (getFirmBankOutputType().equals("1")) {
			buttonName = "ܗ^vZ";
			cmd = "P2001";
		}
		StringBuffer sb = new StringBuffer();
		sb.append("<div class=\"Header\">");
		sb.append("<div class=\"MenuButtonBar\">");
		sb.append("<button type=\"button\" ");
		sb.append("onclick=\"doSubmit(document.form, '");
		sb.append(cmd);
		sb.append("')\">" + buttonName + "</button>");
		sb.append("<button type=\"button\" ");
		sb.append("onclick=\"doSubmit(document.form, '");
		sb.append(cmdMenu);
		sb.append("')\">j[</button>");
		sb.append("<button type=\"button\" id=\"btnLogout\" ");
		sb.append("onclick=\"doSubmit(document.form, '");
		sb.append(MospConst.CMD_LOGOUT);
		sb.append("')\">OAEg</button>");
		sb.append("</div>");
		sb.append("<div class=\"SubTitleBar\">");
		sb.append(subTitle);
		sb.append("</div>");
		sb.append("</div>");
		return sb.toString();
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	public String getPltOutputDetail() {
		return pltOutputDetail;
	}
	
	public String getPltSpecifyYear() {
		return pltSpecifyYear;
	}
	
	public String getPltSpecifyMonth() {
		return pltSpecifyMonth;
	}
	
	public String getPltSpecifyDay() {
		return pltSpecifyDay;
	}
	
	public String getPltCodeType() {
		return pltCodeType;
	}
	
	public String getPltRecordType() {
		return pltRecordType;
	}
	
	public String getPltEndRecord() {
		return pltEndRecord;
	}
	
	public String getPltDeadlineYear() {
		return pltDeadlineYear;
	}
	
	public String getPltDeadlineMonth() {
		return pltDeadlineMonth;
	}
	
	public String getPltDeadlineDay() {
		return pltDeadlineDay;
	}
	
	public String getPltCoBankCode() {
		return pltCoBankCode;
	}
	
	public String getTxtCompanyCode() {
		return txtCompanyCode;
	}
	
	public String getTxtRecordLength() {
		return txtRecordLength;
	}
	
	public String getTxtTypeCode() {
		return txtTypeCode;
	}
	
	public String getTxtCoAddress() {
		return txtCoAddress;
	}
	
	public String getTxtCompanyName() {
		return txtCompanyName;
	}
	
	public String getEscTxtCompanyCode() {
		return escapeHTML(txtCompanyCode);
	}
	
	public String getEscTxtRecordLength() {
		return escapeHTML(txtRecordLength);
	}
	
	public String getEscTxtTypeCode() {
		return escapeHTML(txtTypeCode);
	}
	
	public String getEscTxtCoAddress() {
		return escapeHTML(txtCoAddress);
	}
	
	public String getEscTxtCompanyName() {
		return escapeHTML(txtCompanyName);
	}
	
	public String getFirmBankOutputType() {
		return key1;
	}
	
	public void setPltOutputDetail(String pltOutputDetail) {
		this.pltOutputDetail = pltOutputDetail;
	}
	
	public void setPltSpecifyYear(String pltSpecifyYear) {
		this.pltSpecifyYear = pltSpecifyYear;
	}
	
	public void setPltSpecifyMonth(String pltSpecifyMonth) {
		this.pltSpecifyMonth = pltSpecifyMonth;
	}
	
	public void setPltSpecifyDay(String pltSpecifyDay) {
		this.pltSpecifyDay = pltSpecifyDay;
	}
	
	public void setPltCodeType(String pltCodeType) {
		this.pltCodeType = pltCodeType;
	}
	
	public void setPltRecordType(String pltRecordType) {
		this.pltRecordType = pltRecordType;
	}
	
	public void setPltEndRecord(String pltEndRecord) {
		this.pltEndRecord = pltEndRecord;
	}
	
	public void setPltDeadlineYear(String pltDeadlineYear) {
		this.pltDeadlineYear = pltDeadlineYear;
	}
	
	public void setPltDeadlineMonth(String pltDeadlineMonth) {
		this.pltDeadlineMonth = pltDeadlineMonth;
	}
	
	public void setPltDeadlineDay(String pltDeadlineDay) {
		this.pltDeadlineDay = pltDeadlineDay;
	}
	
	public void setPltCoBankCode(String pltCoBankCode) {
		this.pltCoBankCode = pltCoBankCode;
	}
	
	public void setTxtCompanyCode(String txtCompanyCode) {
		this.txtCompanyCode = txtCompanyCode;
	}
	
	public void setTxtRecordLength(String txtRecordLength) {
		this.txtRecordLength = txtRecordLength;
	}
	
	public void setTxtTypeCode(String txtTypeCode) {
		this.txtTypeCode = txtTypeCode;
	}
	
	public void setTxtCoAddress(String txtCoAddress) {
		this.txtCoAddress = txtCoAddress;
	}
	
	public void setTxtCompanyName(String txtCompanyName) {
		this.txtCompanyName = txtCompanyName;
	}
	
	public void setFirmBankOutputType(String key1) {
		this.key1 = key1;
	}
	
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	public int getMode() {
		return mode;
	}
	
}
