/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.action;

import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.payroll.base.PayrollAction;
import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.payroll.bonus.vo.BonusCalcVo;
import jp.mosp.payroll.bonus.vo.BonusCardVo;

/**
 * ^׏o͋@\񋟂B<br><br>
 * ^vZʂANw肵đΏۑS̋^ׂꊇo͂B<br>
 * ܂^׉ʂAIЈ̑INɂ鋋^ׂo͂B<br>
 */
public class BonusDetailAction extends PayrollAction {
	
	// R}h
	private static final String	CMD_BONUS_DETAIL_ALL	= "P2031";
	private static final String	CMD_BONUS_DETAIL_ONE	= "P2032";
	

	// ev[gXMLt@CpX
//	private static final String template = "/template/bonusDetail.jasper";
	
	/**
	 * RXgN^B<br>
	 * V[PXssvݒsB<br>
	 */
	public BonusDetailAction() {
		super();
		setNeedProcSeq(false);
	}
	
	/**
	 * ܗ^ׂo͂B<br>
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		if (cmd.equals(CMD_BONUS_DETAIL_ALL)) {
			// VO̎擾
			BonusCalcVo vo = (BonusCalcVo)session.getAttribute(MospConst.ATT_FORMER_VO);
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setYearParams(request);
			// [쐬
			String fileName = vo.getPltDetailYear() + BonusConst.FILE_NAME_SEPARATOR + vo.getPltDetailMonth()
					+ BonusConst.FILE_NAME_SEPARATOR + vo.getPltDetailDay() + BonusConst.FILE_NAME_SEPARATOR
					+ BonusConst.FILE_BONUS_DETAIL;
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			// [쐬yѐݒ
		} else if (cmd.equals(CMD_BONUS_DETAIL_ONE)) {
			// VO̎擾
			BonusCardVo vo = new BonusCardVo();
			vo = (BonusCardVo)getStoredVo(vo.getClassName());
			vo.clearMessage();
			vo.clearErrField();
			vo.initVo(cfg, msg, cmd, aspUser, user);
			// p[^擾
			vo.setParams(request);
			// [쐬
			String fileName = vo.getPltYear() + BonusConst.FILE_NAME_SEPARATOR + vo.getPltMonth()
					+ BonusConst.FILE_NAME_SEPARATOR + vo.getPltDay() + BonusConst.FILE_NAME_SEPARATOR
					+ vo.getHidKCode() + BonusConst.FILE_NAME_SEPARATOR + BonusConst.FILE_BONUS_DETAIL;
			request.setAttribute(MospConst.ATT_FILE_NAME, fileName);
			// [쐬yѐݒ
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
}

/**
 * PDF[쐬B<br>
 * @param template ev[gt@CpX
 * @param list     o͑ΏۃXg
 * @return PDFo̓IuWFNg
 * @throws MospException
 */
/**
	private JRExporter print(
			String template, List<BonusDetailDto> list
	) throws MospException {
		try {
			// IoChf[^
			JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(list);
			// [쐬
			JasperPrint print = JasperFillManager.fillReport(template, new HashMap(), ds);
			// PDFo͏
			JRPdfExporter exporter = new JRPdfExporter();
			exporter.setParameter(JRExporterParameter.JASPER_PRINT, print);
			return exporter;
		} catch (JRException e) {
			throw new MospException(BonusConst.EX_PRINT_FAILED, MospUtility.getStackTrace(e));
		}
	}
}
*/
