/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system.action;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.VariousUtil;
import jp.mosp.mospcommon.system.LaborAgreementManager;
import jp.mosp.mospcommon.system.dto.CmAgreementOverTimeDto;
import jp.mosp.mospcommon.system.dto.CmAgreementWorkOnDto;
import jp.mosp.mospcommon.system.dto.CmLaborAgreementDto;
import jp.mosp.mospcommon.system.vo.LaborAgreementListVo;

/**
 * @author matsusita
 *
 */
public class LaborAgreementListAction extends MosPAction {
	
	// R}h
	private static final String	CMD_AGREEMENT_LIST_SHOW			= "S2510";
	private static final String	CMD_AGREEMENT_LIST_SEARCH		= "S2511";
	/**
	 * Č
	 */
	public static final String	CMD_AGREEMENT_LIST_RE_SEARCH	= "S2512";
	private static final String	CMD_AGREEMENT_LIST_SORT			= "S2513";
	

	/**
	 * RXgN^
	 */
	public LaborAgreementListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_AGREEMENT_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_AGREEMENT_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_AGREEMENT_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_AGREEMENT_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new LaborAgreementListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() throws Exception {
		LaborAgreementListVo vo = (LaborAgreementListVo)getVo();
		vo.setPltDelete(MospConst.DELETE_FLAG_OFF);
		// lɃZbg
		vo.setSearchmode(LaborAgreementListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		LaborAgreementListVo vo = (LaborAgreementListVo)getVo();
		vo.setParams(request);
		searchAgreementList();
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(LaborAgreementListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		LaborAgreementListVo vo = (LaborAgreementListVo)getVo();
		if (vo.getSearchmode() == LaborAgreementListVo.SEARCH_ON) {
			removeSessionDto();
			searchAgreementList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * 胊Xg
	 * @throws Exception Oꍇ
	 */
	private void searchAgreementList() throws Exception {
		LaborAgreementListVo vo = (LaborAgreementListVo)getVo();
		LaborAgreementManager laborAgreement = new LaborAgreementManager(cfg, cmd, aspUser, user, conn);
		// 
		List<CmLaborAgreementDto> list = laborAgreement.getAgreementDao().findForCondition(vo.getTxtAgreeCode(),
				LaborAgreementManager.K_CODE, vo.getPltDelete());
		String[] aryAgreeName = new String[list.size()];
		int i = 0;
		for (CmLaborAgreementDto dto : list) {
			if (LaborAgreementManager.K_CODE.equals(dto.getAgreeType())) {
				// Ј擾ăZbgB
				aryAgreeName[i] = part().mospuser().getUserInfoForKCode(dto.getAgreeCode()).getUserName();
			} else {
				aryAgreeName[i] = dto.getAgreeCode();
			}
			// ԊO
			CmAgreementOverTimeDto overTimeDto = laborAgreement.getOverTimeAgreementInfo(dto.getOverTimeCode(),
					DateUtil.getSystemDate());
			if (VariousUtil.isNotNull(overTimeDto)) {
				// Ɩ̎
				dto.setOverTimeCode(StringUtil.changeTerminal(overTimeDto.getWorkTypeName(), 21));
			}
			// xo
			CmAgreementWorkOnDto workOnDto = laborAgreement.getWorkOnAgreementInfo(dto.getWorkOnCode(), DateUtil
				.getSystemDate());
			if (VariousUtil.isNotNull(workOnDto)) {
				// Ɩ̎
				dto.setWorkOnCode(StringUtil.changeTerminal(workOnDto.getWorkTypeName(), 21));
			}
			i++;
		}
		vo.setFields(list);
		// ЈZbgB
		vo.setAryAgreeName(aryAgreeName);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryAgreeCode().length == 0) {
			vo.addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		LaborAgreementListVo vo = (LaborAgreementListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		LaborAgreementListVo vo = (LaborAgreementListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		LaborAgreementListVo vo = (LaborAgreementListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_AGREE_CODE)) {
			comp = new CompAgreeCode();
		} else if (key.equals(vo.KEY_OVER_TIME_CODE)) {
			comp = new CompOverTimeCode();
		} else if (key.equals(vo.KEY_WORK_ON_CODE)) {
			comp = new CompWorkOnCode();
		} else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompDeleteFlag();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * R[hɂrNX
	 */
	protected static class CompAgreeCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -3256220863532278134L;
		

		public int compare(Object obj1, Object obj2) {
			CmLaborAgreementDto dto1 = (CmLaborAgreementDto)obj1;
			CmLaborAgreementDto dto2 = (CmLaborAgreementDto)obj2;
			return dto1.getAgreeCode().compareTo(dto2.getAgreeCode());
		}
	}
	
	/**
	 * ԊOR[hɂrNX
	 */
	protected static class CompOverTimeCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -9102878735277786582L;
		

		public int compare(Object obj1, Object obj2) {
			CmLaborAgreementDto dto1 = (CmLaborAgreementDto)obj1;
			CmLaborAgreementDto dto2 = (CmLaborAgreementDto)obj2;
			return dto1.getOverTimeCode().compareTo(dto2.getOverTimeCode());
		}
	}
	
	/**
	 * xoR[hɂrNX
	 */
	protected static class CompWorkOnCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -146969641720157320L;
		

		public int compare(Object obj1, Object obj2) {
			CmLaborAgreementDto dto1 = (CmLaborAgreementDto)obj1;
			CmLaborAgreementDto dto2 = (CmLaborAgreementDto)obj2;
			return dto1.getWorkOnCode().compareTo(dto2.getWorkOnCode());
		}
	}
	
	/**
	 * 폜tOɂrNX
	 */
	protected static class CompDeleteFlag implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 3090295838998361549L;
		

		public int compare(Object obj1, Object obj2) {
			CmLaborAgreementDto dto1 = (CmLaborAgreementDto)obj1;
			CmLaborAgreementDto dto2 = (CmLaborAgreementDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}
	
}
