/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.action.AttendanceTotalAction;
import jp.mosp.kintai.common.part.KintaiCommonPart;
import jp.mosp.kintai.dto.MScheduleDto;
import jp.mosp.kintai.vo.ScheduleConfirmListVo;
import jp.mosp.payroll.dto.KintaiCompileDto;

/**
 * @author yoshida
 *
 */
public class ScheduleConfirmListAction extends AttendanceTotalAction {
	
	// R}h
	private static final String	CMD_CONFIRM_LIST_SHOW	= "K1230";
	private static final String	CMD_CONFIRM_LIST_SELECT	= "K1231";
	/**
	 * 
	 */
	public static final String	CMD_CONFIRM_LIST_SEARCH	= "K1232";
	

	/**
	 * RXgN^
	 */
	public ScheduleConfirmListAction() {
		super();
	}
	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_CONFIRM_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_CONFIRM_LIST_SELECT)) {
			// \
			select();
		} else if (cmd.equals(CMD_CONFIRM_LIST_SEARCH)) {
			// 
			search();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new ScheduleConfirmListVo();
	}
	
	@Override
	protected void init() throws Exception {
		ScheduleConfirmListVo vo = (ScheduleConfirmListVo)getVo();
		// v_E擾
		vo.aryPltYear = StringUtil.getYearArray(MospUtility.getYear(DateUtil.getSystemDate()), 3, 1);
		vo.aryPltMonth = StringUtil.getMonthArray();
		// [U[擾
		getInfo(user.getUserId());
		// j[{^
		setScheduleMenuButton();
	}
	
	@Override
	protected void show() throws Exception {
		ScheduleConfirmListVo vo = (ScheduleConfirmListVo)getVo();
		// ΏێЈݒ
		vo.setSelectKCode(userBasis.getKCode());
		// \
		Date current = DateUtil.getSystemDate();
		// Ώ۔Nݒ
		vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
		// 
		searchScheduleList();
	}
	
	@Override
	protected void select() throws Exception {
		ScheduleConfirmListVo vo = (ScheduleConfirmListVo)getVo();
		// ΏێЈݒ
		vo.setSelectKCode(key1);
		// \
		Date current = DateUtil.getSystemDate();
		// Ώ۔Nݒ
		vo.setPltYear(String.valueOf(MospUtility.getYear(current)));
		vo.setPltMonth(String.valueOf(MospUtility.getMonth(current)));
		// 
		searchScheduleList();
	}
	
	@Override
	protected void search() throws Exception {
		ScheduleConfirmListVo vo = (ScheduleConfirmListVo)getVo();
		// Ώ۔Nݒ
		vo.setParams(request);
		// 
		searchScheduleList();
	}
	
	/**
	 * \ꗗ
	 * @throws Exception 	Oꍇ
	 */
	private void searchScheduleList() throws Exception {
		ScheduleConfirmListVo vo = (ScheduleConfirmListVo)getVo();
		// ΑӃf[^擾
		getScheduleListForView(vo.getSelectKCode(), DateUtil.getYearMonth(vo.getPltYear(), vo.getPltMonth()));
		// Wvf[^Ԑݒ
		setScheduleHours(scheduleList);
		// Wvf[^z쐬
		makeScheduleArray(vo.getSelectKCode(), scheduleList);
		// Wv
		totalScheduleDaily(vo.getSelectKCode(), scheduleList);
		// I̐ݒ
		setLabelBasisInfo(part().human().getBasisInfo(vo.getSelectKCode()));
		// Wvf[^ƃx𕪗
		String[] aryLabel = new String[aryAttendanceCompile.length];
		String[] aryCompile = new String[aryAttendanceCompile.length];
		for (int i = 0; i < aryAttendanceCompile.length; i++) {
			aryLabel[i] = aryAttendanceCompile[i][0];
			aryCompile[i] = aryAttendanceCompile[i][1];
		}
		// VOݒ
		vo.setFields(aryAttendance, aryCompile, aryLabel);
	}
	
	/**
	 * Wvf[^z쐬
	 * @param kCode  ΏێЈR[h
	 * @param scheduleList  \񃊃Xg
	 * @throws Exception 	Oꍇ
	 */
	private void makeScheduleArray(String kCode, List<MScheduleDto> scheduleList) throws Exception {
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		final int size = 40;
		aryAttendance = new String[count][size];
		for (int i = 0; i < aryAttendance.length; i++) {
			for (int j = 0; j < aryAttendance[i].length; j++) {
				aryAttendance[i][j] = "";
			}
		}
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// t
			aryAttendance[i][0] = DateUtil.convDateToMonthDayShort(cal.getTime());
			// j
			aryAttendance[i][1] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			aryAttendance[i][8] = getDayOfWeekColorClass(cal.getTime());
			// lijՓAxj
			StringBuffer remark = new StringBuffer();
			String holidayName = getPublicHolidayName(cal.getTime());
			if (StringUtil.isNotNull(holidayName)) {
				remark.append(holidayName);
				remark.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
			aryAttendance[i][7] = remark.toString();
			// cƐ\
			if (part().overtime().isOverTimeRequest(kCode, cal.getTime())) {
				aryAttendance[i][7] += CommonConst.NAM_OVERTIME;
				aryAttendance[i][7] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
			}
			// xɐ\
			if (part().holidayRequest().existHolidayRequest(kCode, cal.getTime())) {
				aryAttendance[i][7] += CommonConst.NAM_VACATION_LEAVE;
				aryAttendance[i][7] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
			}
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// f[^̐ݒ
		Iterator<MScheduleDto> it = scheduleList.iterator();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MScheduleDto dto = it.next();
			Date scheduleDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (scheduleDate.compareTo(cal.getTime()) == 0) {
					// Ζ`
					String kinmuName = "";
					if (KintaiCommonPart.isAvailableWorkType(dto)) {
						kinmuName = part().worktype().getWorkTypeName(dto.getKinmu());
						// oΎ
						aryAttendance[i][3] = dto.getSyJikoku();
						// ދΎ
						aryAttendance[i][4] = dto.getTaJikoku();
						// Ζ
						aryAttendance[i][5] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
						// xe
						aryAttendance[i][6] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
					} else if (KintaiCommonPart.isWeekHoliday(dto) || KintaiCommonPart.isOfficialHoliday(dto)) {
						// Tx̏ꍇ
						//kinmu = CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY;
						// Txx\
						kinmuName = part().worktype().getWorkTypeName(dto.getKinmu());
					} else {
						// xɗR
						kinmuName = part().mospcode().getHolidayName(dto.getKKRiyuu());
					}
					aryAttendance[i][2] = kinmuName;
					// x
					if (KintaiCommonPart.isStartHalfHoliday(dto)) {
						aryAttendance[i][7] += CommonConst.NAM_SHORT_START_ATTENDANCE;
						aryAttendance[i][7] += CommonConst.NAM_VACATION_LEAVE_HALF;
						aryAttendance[i][7] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					if (KintaiCommonPart.isQuitHalfHoliday(dto)) {
						aryAttendance[i][7] += CommonConst.NAM_SHORT_QUIT_ATTENDANCE;
						aryAttendance[i][7] += CommonConst.NAM_VACATION_LEAVE_HALF;
						aryAttendance[i][7] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					if (KintaiCommonPart.isWorkOnHoliday(dto)) {
						aryAttendance[i][7] += CommonConst.NAM_WORK_ON_HOLIDAY;
						aryAttendance[i][7] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					if (KintaiCommonPart.isOverTimeSubHolidayHalf(dto)) {
						aryAttendance[i][7] += CommonConst.NAM_SUB_HOLIDAY_HALF;
						aryAttendance[i][7] += CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}
	
	/**
	 * Wv
	 * @param kCode	ΏێЈR[h
	 * @param scheduleList  \񃊃Xg
	 * @throws Exception 	Oꍇ
	 */
	private void totalScheduleDaily(String kCode, List<MScheduleDto> scheduleList) throws Exception {
		KintaiCompileDto dto = compile().getCompiledInfo(kCode, scheduleList, false);
		// z̏
		aryAttendanceCompile = new String[10][2];
		// z
		// Ζԍv
		aryAttendanceCompile[0][0] = CommonConst.NAM_WORKING;
		aryAttendanceCompile[0][1] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTotalWork()));
		// xeԍv
		aryAttendanceCompile[1][0] = CommonConst.NAM_INTERVAL_TIME;
		aryAttendanceCompile[1][1] = getHourString(TimeUtil.convIntegerTimeToDoubleTime(dto.getTotalInterbal()));
		// oΓ
		aryAttendanceCompile[2][0] = CommonConst.NAM_PRESENCE;
		aryAttendanceCompile[2][1] = String.valueOf(dto.getTotalWorkDays());
		// Lxɓ
		aryAttendanceCompile[3][0] = aryHolidayReason[0][1];
		aryAttendanceCompile[3][1] = String.valueOf(dto.getTotalPaidHoliday());
		// ʋxɓ
		aryAttendanceCompile[4][0] = aryHolidayReason[1][1];
		aryAttendanceCompile[4][1] = String.valueOf(dto.getTotalParticularHoliday());
		// ΋xɓ
		aryAttendanceCompile[5][0] = aryHolidayReason[2][1];
		aryAttendanceCompile[5][1] = String.valueOf(dto.getTotalAbsence());
		// axɓ
		aryAttendanceCompile[6][0] = aryHolidayReason[3][1];
		aryAttendanceCompile[6][1] = String.valueOf(dto.getTotalMedicalLeave());
		// x
		aryAttendanceCompile[7][0] = aryHolidayReason[4][1];
		aryAttendanceCompile[7][1] = String.valueOf(dto.getTotalCompensationDay());
		// U֋xɓ
		aryAttendanceCompile[8][0] = aryHolidayReason[5][1];
		aryAttendanceCompile[8][1] = String.valueOf(dto.getTotalTransfer());
		// xɓ
		aryAttendanceCompile[9][0] = CommonConst.NAM_OTHER_SHORT;
		aryAttendanceCompile[9][1] = String.valueOf(dto.getTotalOther());
	}
	
}
