/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;

/**
 * CM_USER([U[}X^)DAONX B
 */
public class MosPUserDao extends CmUserDao {
	
	/**
	 * RXgN^
	 */
	public MosPUserDao() {
		super();
	}
	
	/**
	 * RXgN^B<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public MosPUserDao(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		this();
		initDao(cfg, cmd, aspUser, user, conn);
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<CmUserDto> mappingAll() throws SQLException {
		List<CmUserDto> all = new ArrayList<CmUserDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return	dto	DTO
	 * @throws SQLException SQLOꍇ
	 */
	private CmUserDto mapping() throws SQLException {
		CmUserDto dto = new CmUserDto();
		dto.setUserId(rs.getString(COL_USER_ID));
		dto.setPassword(rs.getString(COL_PASSWORD));
		dto.setKCode(rs.getString(COL_K_CODE));
		dto.setUserName(rs.getString(COL_USER_NAME));
		dto.setAuthority(rs.getString(COL_AUTHORITY));
		dto.setDataLevel(rs.getInt(COL_DATA_LEVEL));
		dto.setChangePass(rs.getDate(COL_CHANGE_PASS));
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<CmUserDto> findAllMosPUser() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param userId [U[ID
	 * @param userName [U[
	 * @param mospAuthority MosPp
	 * @param deleteFlag 폜tO
	 * @return (DTOList)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public List<?> findForCondition(String userId, String userName, String mospAuthority, String deleteFlag)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(notAdminUser());
		sb.append("AND ");
		sb.append(MosPDao.like(COL_USER_ID));
		sb.append("AND ");
		sb.append(MosPDao.like(COL_USER_NAME));
		if (MosPDao.isNotNull(mospAuthority)) {
			sb.append("AND ");
			sb.append(MosPDao.equal(COL_AUTHORITY));
		}
		if (MosPDao.isNotNull(deleteFlag)) {
			sb.append("AND ");
			sb.append(MosPDao.equal(COL_DELETE_FLAG));
		}
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, MosPDao.startWithParam(userId));
			setParam(index++, MosPDao.containsParam(userName));
			if (MosPDao.isNotNull(mospAuthority)) {
				setParam(index++, mospAuthority);
			}
			if (MosPDao.isNotNull(deleteFlag)) {
				setParam(index++, Integer.parseInt(deleteFlag));
			}
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param userId [U[ID(L[)
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CmUserDto findForRegistered(String userId) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(MosPDao.like(COL_USER_ID));
			sb.append("AND ");
			sb.append(MosPDao.deleteFlagOff(COL_DELETE_FLAG));
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, userId);
			executeQuery();
			CmUserDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ЈR[hɂf[^擾
	 * @param kCode ЈR[h
	 * @return (DTO)
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 */
	public CmUserDto findForKCode(String kCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(MosPDao.equal(COL_K_CODE));
			sb.append("AND ");
			sb.append(notAdminUser());
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			executeQuery();
			CmUserDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @param needLog Oo͗v
	 * @return XV()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException	MosPOꍇ
	 */
	public int update(CmUserDto dto, boolean needLog) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getUserId());
			executeUpdate(needLog);
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto      XVΏDTO
	 * @param isInsert }tO(trueF}AfalseFXV)
	 * @throws SQLException SQLOꍇ
	 */
	private void setParams(CmUserDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getUserId());
		setParam(index++, dto.getPassword());
		setParam(index++, dto.getKCode());
		setParam(index++, dto.getUserName());
		setParam(index++, dto.getAuthority());
		setParam(index++, dto.getDataLevel());
		setParam(index++, dto.getChangePass());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
	/**
	 * ЈR[hpTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchKCodeSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_K_CODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(notAdminUser());
		sb.append("AND ");
		sb.append(MosPDao.like(COL_K_CODE));
		return sb.toString();
	}
	
	/**
	 * ЈpTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchKNameSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_K_CODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(notAdminUser());
		sb.append("AND ");
		sb.append(MosPDao.like(COL_USER_NAME));
		return sb.toString();
	}
	
	/**
	 * pTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchAuthoritySubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_K_CODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(notAdminUser());
		sb.append("AND ");
		sb.append(MosPDao.equal(COL_AUTHORITY));
		return sb.toString();
	}
	
	/**
	 * FpTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchApprovalSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_K_CODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(notAdminUser());
		sb.append("AND ");
		sb.append("(");
		sb.append(MosPDao.equal(COL_AUTHORITY));
		sb.append("OR ");
		sb.append(MosPDao.equal(COL_AUTHORITY));
		sb.append(") ");
		return sb.toString();
	}
	
	/**
	 * ЈR[hpTuNG[
	 * @return	sb	TuNG
	 */
	public static String getSearchDataLevelSubQuery() {
		StringBuffer sb = new StringBuffer();
		sb.append(" SELECT ");
		sb.append(COL_K_CODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(notAdminUser());
		sb.append("AND ");
		sb.append(COL_DATA_LEVEL);
		sb.append(" <= ? ");
		return sb.toString();
	}
	
	/**
	 * admin[UTuNG
	 * @return {@link CmUserDao#COL_USER_ID} <> 'admin'
	 */
	public static String notAdminUser() {
		StringBuffer sb = new StringBuffer();
		sb.append(COL_USER_ID);
		sb.append(" <> 'admin' ");
		return sb.toString();
	}
	
}
