/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.common.utils.StringUtil;
import jp.mosp.common.utils.TimeUtil;
import jp.mosp.kintai.common.part.HolidayRequestPart;
import jp.mosp.kintai.common.part.PaidHolidayPart;
import jp.mosp.kintai.common.vo.MosPWorkFlowVo;
import jp.mosp.workflow.dto.KtHolidayRequestDto;

/**
 * @author yoshida
 *
 */
public class HolidayRequestCardVo extends MosPWorkFlowVo {
	
	private static final long	serialVersionUID			= -1423855097770810052L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT					= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE					= 1;
	/**
	 * 
	 */
	public static final int		MODE_REQUEST				= 2;
	/**
	 * 
	 */
	public static final int		MODE_APPROVED				= 3;
	/**
	 * 
	 */
	public static final int		MODE_RETURNED				= 4;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_HOLIDAY_YEAR		= "pltHolidayYear";
	/**
	 * 
	 */
	public static final String	PRM_PLT_HOLIDAY_MONTH		= "pltHolidayMonth";
	/**
	 * 
	 */
	public static final String	PRM_PLT_HOLIDAY_DAY			= "pltHolidayDay";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_HOUR			= "pltStartHour";
	/**
	 * 
	 */
	public static final String	PRM_PLT_START_MIN			= "pltStartMin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_END_HOUR			= "pltEndHour";
	/**
	 * 
	 */
	public static final String	PRM_PLT_END_MIN				= "pltEndMin";
	/**
	 * 
	 */
	public static final String	PRM_PLT_REASON				= "pltReason";
	/**
	 * 
	 */
	public static final String	PRM_PLT_TYPE				= "pltType";
	/**
	 * 
	 */
	public static final String	PRM_PLT_SUBSTITUTE_YEAR		= "pltSubstituteYear";
	/**
	 * 
	 */
	public static final String	PRM_PLT_SUBSTITUTE_MONTH	= "pltSubstituteMonth";
	/**
	 * 
	 */
	public static final String	PRM_PLT_SUBSTITUTE_DAY		= "pltSubstituteDay";
	/**
	 * 
	 */
	public static final String	PRM_TXT_CAUSE_COMMENT		= "txtCauseComment";
	
	// tB[h
	private String				pltHolidayYear;
	private String				pltHolidayMonth;
	private String				pltHolidayDay;
	private String				pltStartHour;
	private String				pltStartMin;
	private String				pltEndHour;
	private String				pltEndMin;
	private String				pltReason;
	private String				pltType;
	private String				pltSubstituteYear;
	private String				pltSubstituteMonth;
	private String				pltSubstituteDay;
	private String				txtCauseComment;
	private String				lblApprover;
	private String				lblStatus;
	
	// v_EXg
	/**
	 * 
	 */
	public String[][]			aryPltYear;
	/**
	 * 
	 */
	public String[][]			aryPltMonth;
	/**
	 * 
	 */
	public String[][]			aryPltDay;
	/**
	 * 
	 */
	public String[][]			aryPltHour;
	/**
	 * 
	 */
	public String[][]			aryPltMin;
	/**
	 * 
	 */
	public String[][]			aryPltReason;
	/**
	 * 
	 */
	public String[][]			aryPltType;
	/**
	 * 
	 */
	public String[][]			aryPltSubstituteYear;
	/**
	 * 
	 */
	public String[][]			aryPltSubstituteMonth;
	/**
	 * 
	 */
	public String[][]			aryPltSubstituteDay;
	
	// [h(0FVKo^A1FύXA2FύXs)
	private int					mode;
	
	private boolean				useHourHoliday;
	private boolean				useSubstitute;
	
	private int					hourUnit;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_K_CODE;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_SECTION;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_DATE;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_DATE_YEAR;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_DATE_MONTH;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_DATE_DAY;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_TIME;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_TIME_HOUR;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_TIME_MIN;
	/**
	 * 
	 */
	public String				NAM_START_TIME;
	/**
	 * 
	 */
	public String				NAM_END_TIME;
	/**
	 * 
	 */
	public String				NAM_REASON;
	/**
	 * 
	 */
	public String				NAM_HOLIDAY_TYPE;
	/**
	 * 
	 */
	public String				NAM_SUBSTITUTE_DATE;
	/**
	 * 
	 */
	public String				NAM_SUBSTITUTE_DATE_YEAR;
	/**
	 * 
	 */
	public String				NAM_SUBSTITUTE_DATE_MONTH;
	/**
	 * 
	 */
	public String				NAM_SUBSTITUTE_DATE_DAY;
	/**
	 * 
	 */
	public String				NAM_CAUSE_COMMENT;
	/**
	 * 
	 */
	public String				NAM_APPROVER;
	/**
	 * 
	 */
	public String				NAM_STATUS;
	

	/**
	 * RXgN^
	 */
	public HolidayRequestCardVo() {
		super();
		setViewPath(getClassName());
		aryPltYear = new String[0][0];
		aryPltMonth = new String[0][0];
		aryPltDay = new String[0][0];
		aryPltHour = new String[0][0];
		aryPltMin = new String[0][0];
		aryPltReason = new String[0][0];
		aryPltType = new String[0][0];
		aryPltSubstituteYear = new String[0][0];
		aryPltSubstituteMonth = new String[0][0];
		aryPltSubstituteDay = new String[0][0];
		mode = MODE_INSERT;
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.NAM_HOLIDAY_REQUEST;
		aryMenu = new String[][]{ { CMD_MENU_INPUT, CommonConst.NAM_TO_MENU }, MosPMenuConst.getMenuApplication(), };
	}
	
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_K_CODE = CommonConst.NAM_K_CODE;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_SECTION = CommonConst.NAM_STATION;
		NAM_HOLIDAY_DATE = CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_DAY;
		NAM_HOLIDAY_DATE_YEAR = NAM_HOLIDAY_DATE + CommonConst.MSG_YEAR;
		NAM_HOLIDAY_DATE_MONTH = NAM_HOLIDAY_DATE + CommonConst.MSG_MONTH;
		NAM_HOLIDAY_DATE_DAY = NAM_HOLIDAY_DATE + CommonConst.MSG_DAY;
		NAM_HOLIDAY_TIME = CommonConst.NAM_HOLIDAY_HOURS;
		NAM_HOLIDAY_TIME_HOUR = NAM_HOLIDAY_TIME + CommonConst.MSG_HOUR;
		NAM_HOLIDAY_TIME_MIN = NAM_HOLIDAY_TIME + CommonConst.MSG_MINUTES;
		NAM_REASON = CommonConst.NAM_VACATION_LEAVE + CommonConst.NAM_REASON;
		NAM_HOLIDAY_TYPE = "L";
		NAM_SUBSTITUTE_DATE = CommonConst.NAM_APPLY_DATE;
		NAM_SUBSTITUTE_DATE_YEAR = NAM_SUBSTITUTE_DATE + CommonConst.MSG_YEAR;
		NAM_SUBSTITUTE_DATE_MONTH = NAM_SUBSTITUTE_DATE + CommonConst.MSG_MONTH;
		NAM_SUBSTITUTE_DATE_DAY = NAM_SUBSTITUTE_DATE + CommonConst.MSG_DAY;
		NAM_CAUSE_COMMENT = CommonConst.NAM_CAUSE;
		NAM_APPROVER = CommonConst.NAM_APPROVER;
		NAM_STATUS = CommonConst.NAM_APPROVAL_STATE;
		LEN_COMMENT = 50;
		NAM_START_TIME = "Jn";
		NAM_END_TIME = "I";
	}
	
	/**
	 * lݒ
	 */
	public void setDefaultValues() {
		pltHolidayYear = "0";
		pltHolidayMonth = "0";
		pltHolidayDay = "0";
		pltStartHour = "0";
		pltStartMin = "0";
		pltEndHour = "0";
		pltEndMin = "0";
		pltReason = "";
		pltType = "";
		pltSubstituteYear = "0";
		pltSubstituteMonth = "0";
		pltSubstituteDay = "0";
		txtCauseComment = "";
		lblApprover = "";
		lblStatus = "";
	}
	
	/**
	 * p[^ݒ
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		pltHolidayYear = request.getParameter(PRM_PLT_HOLIDAY_YEAR);
		pltHolidayMonth = request.getParameter(PRM_PLT_HOLIDAY_MONTH);
		pltHolidayDay = request.getParameter(PRM_PLT_HOLIDAY_DAY);
		pltStartHour = request.getParameter(PRM_PLT_START_HOUR);
		pltStartMin = request.getParameter(PRM_PLT_START_MIN);
		pltEndHour = request.getParameter(PRM_PLT_END_HOUR);
		pltEndMin = request.getParameter(PRM_PLT_END_MIN);
		pltReason = request.getParameter(PRM_PLT_REASON);
		pltType = request.getParameter(PRM_PLT_TYPE);
		pltSubstituteYear = request.getParameter(PRM_PLT_SUBSTITUTE_YEAR);
		pltSubstituteMonth = request.getParameter(PRM_PLT_SUBSTITUTE_MONTH);
		pltSubstituteDay = request.getParameter(PRM_PLT_SUBSTITUTE_DAY);
		txtCauseComment = request.getParameter(PRM_TXT_CAUSE_COMMENT);
		super.setParams(request);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ݒΏDTO
	 */
	public void setFields(KtHolidayRequestDto dto) {
		pltHolidayYear = String.valueOf(MospUtility.getYear(dto.getHolidayDate()));
		pltHolidayMonth = String.valueOf(MospUtility.getMonth(dto.getHolidayDate()));
		pltHolidayDay = String.valueOf(MospUtility.getDay(dto.getHolidayDate()));
		pltStartHour = TimeUtil.convIntegerTimeToStringHour(dto.getStartTime());
		pltStartMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getStartTime());
		pltEndHour = TimeUtil.convIntegerTimeToStringHour(dto.getEndTime());
		pltEndMin = TimeUtil.convIntegerTimeToStringMinutes(dto.getEndTime());
		pltReason = dto.getReason();
		pltType = dto.getHolidayType();
		String substitutedate = dto.getSubstituteDate();
		if (StringUtil.isNotNull(substitutedate)) {
			Date date = DateUtil.convHyphenDateToDate(substitutedate);
			pltSubstituteYear = String.valueOf(MospUtility.getYear(date));
			pltSubstituteMonth = String.valueOf(MospUtility.getMonth(date));
			pltSubstituteDay = String.valueOf(MospUtility.getDay(date));
		}
		txtCauseComment = dto.getCauseComment();
		setHidVoucher(String.valueOf(dto.getVoucher()));
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(KtHolidayRequestDto dto) {
		dto.setHolidayDate(DateUtil.getDate(pltHolidayYear, pltHolidayMonth, pltHolidayDay));
		dto.setReason(pltReason);
		// Lx
		if (PaidHolidayPart.isPaidHoliday(pltReason)) {
			dto.setHolidayType(pltType);
			// ԋx
			if (HolidayRequestPart.isPaidHolidayTime(pltType)) {
				dto.setStartTime(TimeUtil.convStringTimeToIntegerTime(pltStartHour, pltStartMin));
				dto.setEndTime(TimeUtil.convStringTimeToIntegerTime(pltEndHour, pltEndMin));
			}
		} else if (HolidayRequestPart.isSubHoliday(pltReason)) {
			// ԊOɂx
			dto.setHolidayType(pltType);
		} else {
			// xɗR
			dto.setHolidayType(CommonConst.CODE_HOLIDAY_ALL);
		}
		// [
		if (StringUtil.isNotNull(pltSubstituteYear) && StringUtil.isNotNull(pltSubstituteMonth)
				&& StringUtil.isNotNull(pltSubstituteDay)) {
			dto.setSubstituteDate(DateUtil.convStringDateFormattedByHyphen(pltSubstituteYear, pltSubstituteMonth,
					pltSubstituteDay));
		}
		dto.setCauseComment(txtCauseComment);
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(pltHolidayYear, NAM_HOLIDAY_DATE_YEAR, PRM_PLT_HOLIDAY_YEAR);
		checkRequired(pltHolidayMonth, NAM_HOLIDAY_DATE_MONTH, PRM_PLT_HOLIDAY_MONTH);
		checkRequired(pltHolidayDay, NAM_HOLIDAY_DATE_DAY, PRM_PLT_HOLIDAY_DAY);
		// tÓmF
		checkDate(getIntParam(pltHolidayYear), getIntParam(pltHolidayMonth), getIntParam(pltHolidayDay),
				NAM_HOLIDAY_DATE, PRM_PLT_HOLIDAY_DAY);
		// 񒷊mF
		checkLength(txtCauseComment, LEN_COMMENT, NAM_CAUSE_COMMENT, PRM_TXT_CAUSE_COMMENT);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append(getArrayCodeJs("ARY_PLT_TYPE", aryPltType));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		sb.append("var USE_HOUR_HOLIDAY = ");
		sb.append(useHourHoliday);
		sb.append(";");
		sb.append("var USE_SUBSTITUTE_HOLIDAY = ");
		sb.append(useSubstitute);
		sb.append(";");
		sb.append("var HOUR_UNIT = ");
		sb.append(hourUnit);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh
	/**
	 * @return pltHolidayYear
	 */
	public String getPltHolidayYear() {
		return pltHolidayYear;
	}
	
	/**
	 * @return pltHolidayMonth
	 */
	public String getPltHolidayMonth() {
		return pltHolidayMonth;
	}
	
	/**
	 * @return pltHolidayDay
	 */
	public String getPltHolidayDay() {
		return pltHolidayDay;
	}
	
	/**
	 * @return pltStartHour
	 */
	public String getPltStartHour() {
		return pltStartHour;
	}
	
	/**
	 * @return pltStartMin
	 */
	public String getPltStartMin() {
		return pltStartMin;
	}
	
	/**
	 * @return pltEndHour
	 */
	public String getPltEndHour() {
		return pltEndHour;
	}
	
	/**
	 * @return pltEndMin
	 */
	public String getPltEndMin() {
		return pltEndMin;
	}
	
	/**
	 * @return pltReason
	 */
	public String getPltReason() {
		return pltReason;
	}
	
	/**
	 * @return pltType
	 */
	public String getPltType() {
		return pltType;
	}
	
	/**
	 * @return pltSubstituteYear
	 */
	public String getPltSubstituteYear() {
		return pltSubstituteYear;
	}
	
	/**
	 * @return pltSubstituteMonth
	 */
	public String getPltSubstituteMonth() {
		return pltSubstituteMonth;
	}
	
	/**
	 * @return pltSubstituteDay
	 */
	public String getPltSubstituteDay() {
		return pltSubstituteDay;
	}
	
	/**
	 * @return txtCauseComment
	 */
	public String getTxtCauseComment() {
		return txtCauseComment;
	}
	
	/**
	 * @return txtCauseComment
	 */
	public String getEscTxtCauseComment() {
		return escapeHTML(txtCauseComment);
	}
	
	/**
	 * @return lblApprover
	 */
	public String getEscLblApprover() {
		return escapeHTML(lblApprover);
	}
	
	/**
	 * @return lblStatus
	 */
	public String getEscLblStatus() {
		return escapeHTML(lblStatus);
	}
	
	/**
	 * @param pltHolidayYear pltHolidayYear
	 */
	public void setPltHolidayYear(String pltHolidayYear) {
		this.pltHolidayYear = pltHolidayYear;
	}
	
	/**
	 * @param pltHolidayMonth pltHolidayMonth
	 */
	public void setPltHolidayMonth(String pltHolidayMonth) {
		this.pltHolidayMonth = pltHolidayMonth;
	}
	
	/**
	 * @param pltHolidayDay pltHolidayDay
	 */
	public void setPltHolidayDay(String pltHolidayDay) {
		this.pltHolidayDay = pltHolidayDay;
	}
	
	/**
	 * @param lblStatus lblStatus
	 */
	public void setLblStatus(String lblStatus) {
		this.lblStatus = lblStatus;
	}
	
	/**
	 * @param lblApprover lblApprover
	 */
	public void setLblApprover(String lblApprover) {
		this.lblApprover = lblApprover;
	}
	
	/**
	 * @param mode mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
	/**
	 * @return useHourHoliday
	 */
	public boolean isUseHourHoliday() {
		return useHourHoliday;
	}
	
	/**
	 * @return useSubstitute
	 */
	public boolean isUseSubstitute() {
		return useSubstitute;
	}
	
	/**
	 * @param useHourHoliday Zbg useHourHoliday
	 */
	public void setUseHourHoliday(boolean useHourHoliday) {
		this.useHourHoliday = useHourHoliday;
	}
	
	/**
	 * @param useSubstitute Zbg useSubstitute
	 */
	public void setUseSubstitute(boolean useSubstitute) {
		this.useSubstitute = useSubstitute;
	}
	
	/**
	 * @param hourUnit Zbg hourUnit
	 */
	public void setHourUnit(int hourUnit) {
		this.hourUnit = hourUnit;
	}
	
	/**
	 * @return hourUnit
	 */
	public int getHourUnit() {
		return hourUnit;
	}
	
}
