/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.MCodeDto;
import jp.mosp.common.utils.StringUtil;

/**
 * @author yoshida
 *
 */
public class LeaveEarlyReasonCardVo extends MosPVo {
	
	private static final long	serialVersionUID			= -7620328907056255240L;
	
	// p[^
	/**
	 * txtLeaveEarlyReason
	 */
	public static final String	PRM_TXT_LEAVE_EARLY_REASON	= "txtLeaveEarlyReason";
	
	// tB[h
	private String[]			aryLeaveEarlyReason;
	private String[]			aryTxtLeaveEarlyReason;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_LEAVE_EARLY_REASON;
	/**
	 * 
	 */
	public int					LEN_LEAVE_EARLY_REASON;
	

	/**
	 * RXgN^
	 */
	public LeaveEarlyReasonCardVo() {
		super();
		setViewPath(getClassName());
		aryLeaveEarlyReason = new String[0];
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_LEAVE_EARLY_REASON;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuReasonMaster());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_LEAVE_EARLY_REASON = CommonConst.NAM_LEAVE_EARLY + CommonConst.NAM_REASON;
		LEN_LEAVE_EARLY_REASON = 15;
	}
	
	/**
	 * p[^ݒ
	 */
	@Override
	public void setParams(HttpServletRequest request) {
		aryTxtLeaveEarlyReason = request.getParameterValues(PRM_TXT_LEAVE_EARLY_REASON);
	}
	
	/**
	 * tB[hݒ
	 * @param listLeave		ޗRXg
	 */
	@Override
	public void setFields(List<?> listLeave) {
		// z̏
		aryLeaveEarlyReason = StringUtil.getBlankArrayOneDimension(10);
		// f[^̐ݒ
		int i = 0;
		Iterator<?> it = listLeave.iterator();
		while (it.hasNext()) {
			MCodeDto dto = (MCodeDto)it.next();
			aryLeaveEarlyReason[i] = escapeHTML(dto.getTName());
			i++;
		}
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		for (int i = 0; i < aryTxtLeaveEarlyReason.length; i++) {
			// 񒷊mF
			checkLength(aryTxtLeaveEarlyReason[i], LEN_LEAVE_EARLY_REASON, NAM_LEAVE_EARLY_REASON,
					PRM_TXT_LEAVE_EARLY_REASON + i);
		}
		// ÓmFI
		endValidation();
	}
	
	// ANZT\bh
	/**
	 * @return aryLeaveEarlyReason
	 */
	public String[] getAryLeaveEarlyReason() {
		return aryLeaveEarlyReason.clone();
	}
	
	/**
	 * @return aryTxtLeaveEarlyReason
	 */
	public String[] getAryTxtLeaveEarlyReason() {
		return aryTxtLeaveEarlyReason.clone();
	}
	
	/**
	 * @param aryLeaveEarlyReason Zbg aryLeaveEarlyReason
	 */
	public void setAryLeaveEarlyReason(String[] aryLeaveEarlyReason) {
		this.aryLeaveEarlyReason = aryLeaveEarlyReason.clone();
	}
	
	/**
	 * @param aryTxtLeaveEarlyReason Zbg aryTxtLeaveEarlyReason
	 */
	public void setAryTxtLeaveEarlyReason(String[] aryTxtLeaveEarlyReason) {
		this.aryTxtLeaveEarlyReason = aryTxtLeaveEarlyReason.clone();
	}
	
}
