/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.payment.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.dto.CmCityDto;

public class CityListVo extends PayrollVo {
	
	private static final long	serialVersionUID			= 7706050524635760070L;
	
	public static final String	PRM_TXT_CITY_CODE			= "txtCityCode";						// sR[h
	public static final String	PRM_TXT_CITY_NAME			= "txtCityName";						// s
	public static final String	PRM_TXT_CITY_KANA			= "txtCityKana";						// sJi
	public static final String	PRM_TXT_CITY_ACCOUNT		= "txtCityAccount";					// sԍ
	public static final String	PRM_TXT_CITY_ACCOUNT_NAME1	= "txtCityAccountName1";				// 1
	public static final String	PRM_TXT_CITY_ACCOUNT_NAME2	= "txtCityAccountName2";				// 2
	public static final String	PRM_TXT_DESIGNATED_NUMBER	= "txtDesignatedNumber";				// wԍ
	public static final String	PRM_PLT_CO_BANK_CODE		= "pltCoBankCode";						// ЋsR[h
	public static final String	PRM_TXT_MASTER_OFFICE		= "txtMasterOffice";					// ܂Ƃߋ
	public static final String	PRM_TXT_CITY_POSTAL_CODE	= "txtCityPostalCode";					// sX֔ԍ
	public static final String	PRM_TXT_CITY_ADDRESS1		= "txtCityAddress1";					// sZ1
	public static final String	PRM_TXT_CITY_ADDRESS2		= "txtCityAddress2";					// sZ2
	public static final String	PRM_TXT_CITY_OFFICE1		= "txtCityOffice1";					// ꖼ1
	public static final String	PRM_TXT_CITY_OFFICE2		= "txtCityOffice2";					// ꖼ2
	public static final String	PRM_TXT_CITY_PHONE			= "txtCityPhone";						// sdbԍ
																									
	public static final int		SEARCH_OFF					= 0;
	public static final int		SEARCH_ON					= 1;
	
	// [h(0FȂA1F)
	private int					searchmode;
	// \[gL[
	public final String			KEY_CITY_CODE				= "keyCityCode";						// sR[h
	public final String			KEY_CITY_NAME				= "keyCityName";						// s
	public final String			KEY_CITY_KANA				= "keyCityKana";						// sJi
	public final String			KEY_CITY_ACCOUNT			= "keyCityAccount";					// sԍ
	public final String			KEY_CITY_ACCOUNT_NAME1		= "keyCityAccountName1";				// 1
	public final String			KEY_CITY_ACCOUNT_NAME2		= "keyCityAccountName2";				// 2
	public final String			KEY_DESIGNATED_NUMBER		= "keyDesignatedNumber";				// wԍ
	public final String			KEY_CO_BANK_CODE			= "keyCoBankCode";						// ЋsR[h
	public final String			KEY_MASTER_OFFICE			= "keyMasterOffice";					// ܂Ƃߋ
	public final String			KEY_CITY_POSTAL_CODE		= "keyCityPostalCode";					// sX֔ԍ
	public final String			KEY_CITY_ADDRESS1			= "keyCityAddress1";					// sZ1
	public final String			KEY_CITY_ADDRESS2			= "keyCityAddress2";					// sZ2
	public final String			KEY_CITY_OFFICE1			= "keyCityOffice1";					// ꖼ1
	public final String			KEY_CITY_OFFICE2			= "keyCityOffice2";					// ꖼ2
	public final String			KEY_CITY_PHONE				= "keyCityPhone";						// sdbԍ
																									
	public String				NAM_CITY_CODE;
	public String				NAM_CITY_KANA;
	
	public static final int		LEN_CITY_CODE				= PayrollConst.LEN_CITY_CODE;
	public static final int		LEN_CITY_NAME				= PayrollConst.LEN_CITY_NAME;
	public static final int		LEN_CITY_KANA				= PayrollConst.LEN_CITY_KANA;
	public static final int		LEN_DESIGNATED_NUMBER		= PayrollConst.LEN_DESIGNATED_NUMBER;
	
	// tB[h
	private String[]			aryCityCode;
	private String[]			aryCityName;
	private String[]			aryCityKana;
	private String[]			aryCityAccount;
	private String[]			aryCityAccountName1;
	private String[]			aryCityAccountName2;
	private String[]			aryDesignatedNumber;
	private String[]			aryCoBankCode;
	private String[]			aryMasterOffice;
	private String[]			aryCityPostalCode;
	private String[]			aryCityAddress1;
	private String[]			aryCityAddress2;
	private String[]			aryCityOffice1;
	private String[]			aryCityOffice2;
	private String[]			aryCityPhone;
	
	private String				txtCityCode;
	private String				txtCityName;
	private String				txtCityKana;
	private String				txtCityAccount;
	private String				txtCityAccountName1;
	private String				txtCityAccountName2;
	private String				txtDesignatedNumber;
	private String				pltCoBankCode;
	private String				txtMasterOffice;
	private String				txtCityPostalCode;
	private String				txtCityAddress1;
	private String				txtCityAddress2;
	private String				txtCityOffice1;
	private String				txtCityOffice2;
	private String				txtCityPhone;
	
	//@v_EXg
	public String[][]			aryPltCoBankCode;
	

	/**
	 * RXgN^
	 */
	public CityListVo() {
		super();
		aryCityCode = new String[0];
		aryCityName = new String[0];
		aryCityKana = new String[0];
		aryCityAccount = new String[0];
		aryCityAccountName1 = new String[0];
		aryCityAccountName2 = new String[0];
		aryDesignatedNumber = new String[0];
		aryCoBankCode = new String[0];
		aryMasterOffice = new String[0];
		aryCityPostalCode = new String[0];
		aryCityAddress1 = new String[0];
		aryCityAddress2 = new String[0];
		aryCityOffice1 = new String[0];
		aryCityOffice2 = new String[0];
		aryCityPhone = new String[0];
		
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_CITY") + getName("P_WARD") + getName("P_TOWN") + getName("P_VILLAGE")
				+ getName("C_MASTER") + getName("P_MAINTENANCE");
		addAryMenu("P1002", getName("P_PAYROLL") + getName("C_MASTER") + getName("C_MENU") + getName("C_TO"));
	}
	
	/**
	 * ږ̂ݒ肷B
	 */
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		NAM_CITY_CODE = getName("P_CITY_CODE");
		NAM_CITY_KANA = getName("P_CITY_KANA");
	}
	
	/**
	 * tB[hݒ
	 * @param listStation Xg
	 */
	public void setFields(List listStation) {
		// Xg̐ݒ
		list = listStation;
		// f[^̎擾
		count = listStation.size();
		
		// z̏
		aryCityCode = new String[count];
		aryCityName = new String[count];
		aryCityKana = new String[count];
		aryCityAccount = new String[count];
		aryCityAccountName1 = new String[count];
		aryCityAccountName2 = new String[count];
		aryDesignatedNumber = new String[count];
		aryCoBankCode = new String[count];
		aryMasterOffice = new String[count];
		aryCityPostalCode = new String[count];
		aryCityAddress1 = new String[count];
		aryCityAddress2 = new String[count];
		aryCityOffice1 = new String[count];
		aryCityOffice2 = new String[count];
		aryCityPhone = new String[count];
		
		// f[^̐ݒ
		int i = 0;
		Iterator it = listStation.iterator();
		while (it.hasNext()) {
			CmCityDto dto = (CmCityDto)it.next();
			aryCityCode[i] = escapeHTML(dto.getCityCode());
			aryCityName[i] = escapeHTML(dto.getCityName());
			aryCityKana[i] = escapeHTML(dto.getCityKana());
			aryCityAccount[i] = escapeHTML(dto.getCityAccount());
			aryCityAccountName1[i] = escapeHTML(dto.getCityAccountName1());
			aryCityAccountName2[i] = escapeHTML(dto.getCityAccountName2());
			aryDesignatedNumber[i] = escapeHTML(dto.getDesignatedNumber());
			aryCoBankCode[i] = escapeHTML(getCodeName(dto.getCoBankCode(), aryPltCoBankCode));
			aryMasterOffice[i] = escapeHTML(dto.getMasterOffice());
			aryCityPostalCode[i] = escapeHTML(dto.getCityPostalCode());
			aryCityAddress1[i] = escapeHTML(dto.getCityAddress1());
			aryCityAddress2[i] = escapeHTML(dto.getCityAddress2());
			aryCityOffice1[i] = escapeHTML(dto.getCityOffice1());
			aryCityOffice2[i] = escapeHTML(dto.getCityOffice2());
			aryCityPhone[i] = escapeHTML(dto.getCityPhone());
			i++;
		}
	}
	
	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		txtCityCode = request.getParameter(PRM_TXT_CITY_CODE);
		txtCityName = request.getParameter(PRM_TXT_CITY_NAME);
		txtCityKana = request.getParameter(PRM_TXT_CITY_KANA);
		txtCityAccount = request.getParameter(PRM_TXT_CITY_ACCOUNT);
		txtCityAccountName1 = request.getParameter(PRM_TXT_CITY_ACCOUNT_NAME1);
		txtCityAccountName2 = request.getParameter(PRM_TXT_CITY_ACCOUNT_NAME2);
		txtDesignatedNumber = request.getParameter(PRM_TXT_DESIGNATED_NUMBER);
		pltCoBankCode = request.getParameter(PRM_PLT_CO_BANK_CODE);
		txtMasterOffice = request.getParameter(PRM_TXT_MASTER_OFFICE);
		txtCityPostalCode = request.getParameter(PRM_TXT_CITY_POSTAL_CODE);
		txtCityAddress1 = request.getParameter(PRM_TXT_CITY_ADDRESS1);
		txtCityAddress2 = request.getParameter(PRM_TXT_CITY_ADDRESS2);
		txtCityOffice1 = request.getParameter(PRM_TXT_CITY_OFFICE1);
		txtCityOffice2 = request.getParameter(PRM_TXT_CITY_OFFICE2);
		txtCityPhone = request.getParameter(PRM_TXT_CITY_PHONE);
	}
	
	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class<?> cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}
	
	public void setSearchmode(int searchmode) {
		this.searchmode = searchmode;
	}
	
	public int getSearchmode() {
		return searchmode;
	}
	
	// ANZT\bh
	
	public String[] getAryCityCode() {
		return aryCityCode.clone();
	}
	
	public String[] getAryCityName() {
		return aryCityName.clone();
	}
	
	public String[] getAryCityKana() {
		return aryCityKana.clone();
	}
	
	public String[] getAryCityAccount() {
		return aryCityAccount.clone();
	}
	
	public String[] getAryCityAccountName1() {
		return aryCityAccountName1.clone();
	}
	
	public String[] getAryCityAccountName2() {
		return aryCityAccountName2.clone();
	}
	
	public String[] getAryDesignatedNumber() {
		return aryDesignatedNumber.clone();
	}
	
	public String[] getAryCoBankCode() {
		return aryCoBankCode.clone();
	}
	
	public String[] getAryMasterOffice() {
		return aryMasterOffice.clone();
	}
	
	public String[] getAryCityPostalCode() {
		return aryCityPostalCode.clone();
	}
	
	public String[] getAryCityAddress1() {
		return aryCityAddress1.clone();
	}
	
	public String[] getAryCityAddress2() {
		return aryCityAddress2.clone();
	}
	
	public String[] getAryCityOffice1() {
		return aryCityOffice1.clone();
	}
	
	public String[] getAryCityOffice2() {
		return aryCityOffice2.clone();
	}
	
	public String[] getAryCityPhone() {
		return aryCityPhone.clone();
	}
	
	public void setTxtCityCode(String txtCityCode) {
		this.txtCityCode = txtCityCode;
	}
	
	public void setTxtCityName(String txtCityName) {
		this.txtCityName = txtCityName;
	}
	
	public void setTxtCityKana(String txtCityKana) {
		this.txtCityKana = txtCityKana;
	}
	
	public void setTxtCityAccount(String txtCityAccount) {
		this.txtCityAccount = txtCityAccount;
	}
	
	public void setTxtCityAccountName1(String txtCityAccountName1) {
		this.txtCityAccountName1 = txtCityAccountName1;
	}
	
	public void setTxtCityAccountName2(String txtCityAccountName2) {
		this.txtCityAccountName2 = txtCityAccountName2;
	}
	
	public void setTxtDesignatedNumber(String txtDesignatedNumber) {
		this.txtDesignatedNumber = txtDesignatedNumber;
	}
	
	public void setPltCoBankCode(String pltCoBankCode) {
		this.pltCoBankCode = pltCoBankCode;
	}
	
	public void setTxtMasterOffice(String txtMasterOffice) {
		this.txtMasterOffice = txtMasterOffice;
	}
	
	public void setTxtCityPostalCode(String txtCityPostalCode) {
		this.txtCityPostalCode = txtCityPostalCode;
	}
	
	public void setTxtCityAddress1(String txtCityAddress1) {
		this.txtCityAddress1 = txtCityAddress1;
	}
	
	public void setTxtCityAddress2(String txtCityAddress2) {
		this.txtCityAddress2 = txtCityAddress2;
	}
	
	public void setTxtCityOffice1(String txtCityOffice1) {
		this.txtCityOffice1 = txtCityOffice1;
	}
	
	public void setTxtCityOffice2(String txtCityOffice2) {
		this.txtCityOffice2 = txtCityOffice2;
	}
	
	public void setTxtCityPhone(String txtCityPhone) {
		this.txtCityPhone = txtCityPhone;
	}
	
	public String getTxtCityCode() {
		return escapeHTML(txtCityCode);
	}
	
	public String getTxtCityName() {
		return escapeHTML(txtCityName);
	}
	
	public String getTxtCityKana() {
		return escapeHTML(txtCityKana);
	}
	
	public String getTxtCityAccount() {
		return escapeHTML(txtCityAccount);
	}
	
	public String getTxtCityAccountName1() {
		return escapeHTML(txtCityAccountName1);
	}
	
	public String getTxtCityAccountName2() {
		return escapeHTML(txtCityAccountName2);
	}
	
	public String getTxtDesignatedNumber() {
		return escapeHTML(txtDesignatedNumber);
	}
	
	public String getPltCoBankCode() {
		return escapeHTML(pltCoBankCode);
	}
	
	public String getTxtMasterOffice() {
		return escapeHTML(txtMasterOffice);
	}
	
	public String getTxtCityPostalCode() {
		return escapeHTML(txtCityPostalCode);
	}
	
	public String getTxtCityAddress1() {
		return escapeHTML(txtCityAddress1);
	}
	
	public String getTxtCityAddress2() {
		return escapeHTML(txtCityAddress2);
	}
	
	public String getTxtCityOffice1() {
		return escapeHTML(txtCityOffice1);
	}
	
	public String getTxtCityOffice2() {
		return escapeHTML(txtCityOffice2);
	}
	
	public String getTxtCityPhone() {
		return escapeHTML(txtCityPhone);
	}
	
}
