/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.common.vo;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.common.MospUtility;
import jp.mosp.payroll.base.PayrollConst;
import jp.mosp.payroll.base.PayrollVo;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.common.action.ReferSlipAction;
import jp.mosp.payroll.dto.PhPaymentDto;

/**
 * ܗ^׎QƉʂɂB<br><br>
 */
public class ReferSlipVo extends PayrollVo {
	
	private static final long	serialVersionUID	= 7848063443227608842L;
	
	// tB[h
	private int					pltYear;
	private int					pltType;
	
	private String				hidKCode;
	private String				hidCmd;
	
	// tB[h(ꗗ)
	private String[]			aryType;
	private String[]			aryDate;
	private String[]			aryAllowance;
	private String[]			aryDeduction;
	private String[]			aryTotal;
	private String[]			aryHidDate;
	
	// v_E
	private String[][]			pitYear;
	private String[][]			pitType				= { { String.valueOf(PayrollConst.CALC_PAYMENT), "" },
		{ String.valueOf(PayrollConst.CALC_BONUS), "" } };
	
	/**
	 * p[^(xN)B
	 */
	public static final String	PRM_PLT_YEAR		= "pltYear";
	
	/**
	 * p[^(ܗ^敪)B
	 */
	public static final String	PRM_PLT_TYPE		= "pltType";
	

	/**
	 * {@link PayrollVo#PayrollVo()}sB
	 */
	public ReferSlipVo() {
		super();
		aryType = new String[0];
		aryDate = new String[0];
		aryAllowance = new String[0];
		aryDeduction = new String[0];
		aryTotal = new String[0];
		aryHidDate = new String[0];
		setPageCommand(ReferSlipAction.CMD_PAGE);
		setSortKey("1");
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.payroll.base.PayrollVo#setSubTitle()
	 */
	@Override
	protected void setSubTitle() {
		super.setSubTitle();
		subTitle = getName("P_PAY_BON") + getName("P_DETAIL");
		aryMenu = new String[1][2];
		aryMenu[0][0] = "K1910";
		aryMenu[0][1] = getName("C_MENU") + getName("C_TO");
		
	}
	
	/**
	 * ږ̂ݒ肷B
	 */
	@Override
	protected void setFieldsName() {
		super.setFieldsName();
		pitType[0][1] = getName("P_PAYMENT");
		pitType[1][1] = getName("P_BONUS");
	}
	
	/**
	 * NGXgp[^擾Aݒ肷B
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltYear = getIntParam(request.getParameter(PRM_PLT_YEAR));
		pltType = getIntParam(request.getParameter(PRM_PLT_TYPE));
	}
	
	/**
	 * tB[hݒ肷B<br>
	 * @param list DTOXg
	 */
	public void setFields(List<?> list) {
		// f[^̎擾
		count = list.size();
		// z̏
		aryType = new String[count];
		aryDate = new String[count];
		aryAllowance = new String[count];
		aryDeduction = new String[count];
		aryTotal = new String[count];
		aryHidDate = new String[count];
		// f[^̐ݒ
		for (int i = 0; i < list.size(); i++) {
			Object obj = list.get(i);
			if (obj instanceof PhPaymentDto) {
				PhPaymentDto dto = (PhPaymentDto)obj;
				aryType[i] = getCodeName(String.valueOf(pltType), pitType);
				aryDate[i] = MospUtility.getDateString(dto.getCalcMonth(), PayrollConst.FORMAT_DATE_JP);
				aryAllowance[i] = String.valueOf(dto.getAllowanceTotal());
				aryDeduction[i] = String.valueOf(dto.getDeductionTotal());
				aryTotal[i] = String.valueOf(dto.getPaymentTotal());
				aryHidDate[i] = MospUtility.getDateString(dto.getCalcMonth(), PayrollConst.FORMAT_DATE);
			} else if (obj instanceof PhBounsDto) {
				PhBounsDto dto = (PhBounsDto)obj;
				aryType[i] = getCodeName(String.valueOf(pltType), pitType);
				aryDate[i] = MospUtility.getDateString(dto.getCalcMonth(), PayrollConst.FORMAT_DATE_JP);
				aryAllowance[i] = String.valueOf(dto.getAllowanceTotal());
				aryDeduction[i] = String.valueOf(dto.getDeductionTotal());
				aryTotal[i] = String.valueOf(dto.getPaymentTotal());
				aryHidDate[i] = MospUtility.getDateString(dto.getCalcMonth(), PayrollConst.FORMAT_DATE);
			}
		}
	}
	
	/**
	 * 敪擾B
	 * @return 敪
	 */
	public int getPltType() {
		return pltType;
	}
	
	/**
	 * 敪ݒ肷B
	 * @param pltType ݒ肷敪
	 */
	public void setPltType(int pltType) {
		this.pltType = pltType;
	}
	
	/**
	 * N擾B
	 * @return N
	 */
	public int getPltYear() {
		return pltYear;
	}
	
	/**
	 * Nݒ肷B
	 * @param pltYear ݒ肷N
	 */
	public void setPltYear(int pltYear) {
		this.pltYear = pltYear;
	}
	
	/**
	 * ЈR[h擾B
	 * @return ЈR[h
	 */
	public String getHidKCode() {
		return hidKCode;
	}
	
	/**
	 * ЈR[hݒ肷B
	 * @param hidKCode ݒ肷ЈR[h
	 */
	public void setHidKCode(String hidKCode) {
		this.hidKCode = hidKCode;
	}
	
	/**
	 * ׏o̓R}h擾B
	 * @return ׏o̓R}h
	 */
	public String getHidCmd() {
		return hidCmd;
	}
	
	/**
	 * ׏o̓R}hݒ肷B
	 * @param hidCmd ݒ肷閾׏o̓R}h
	 */
	public void setHidCmd(String hidCmd) {
		this.hidCmd = hidCmd;
	}
	
	/**
	 * Nv_EACe擾B
	 * @return Nv_EACe
	 */
	public String[][] getPitYear() {
		return getAryField(pitYear);
	}
	
	/**
	 * Nv_EACeݒ肷B
	 * @param pitYear ݒ肷Nv_EACe
	 */
	public void setPitYear(String[][] pitYear) {
		this.pitYear = getAryField(pitYear);
	}
	
	/**
	 * 敪v_EACe擾B
	 * @return 敪v_EACe
	 */
	public String[][] getPitType() {
		return getAryField(pitType);
	}
	
	/**
	 * 敪v_EACeݒ肷B
	 * @param pitType ݒ肷敪v_EACe
	 */
	public void setPitType(String[][] pitType) {
		this.pitType = getAryField(pitType);
	}
	
	/**
	 * 敪擾B
	 * @param idx CfbNX
	 * @return 敪
	 */
	public String getAryType(int idx) {
		return escapeHTML(aryType[idx]);
	}
	
	/**
	 * 擾B
	 * @param idx CfbNX
	 * @return 
	 */
	public String getAryDate(int idx) {
		return escapeHTML(aryDate[idx]);
	}
	
	/**
	 * xz擾B
	 * @param idx CfbNX
	 * @return xz
	 */
	public String getAryAllowance(int idx) {
		return escapeHTML(insertComma(aryAllowance[idx]));
	}
	
	/**
	 * Tz擾B
	 * @param idx CfbNX
	 * @return Tz
	 */
	public String getAryDeduction(int idx) {
		return escapeHTML(insertComma(aryDeduction[idx]));
	}
	
	/**
	 * xz擾B
	 * @param idx CfbNX
	 * @return xz
	 */
	public String getAryTotal(int idx) {
		return escapeHTML(insertComma(aryTotal[idx]));
	}
	
	/**
	 * p[^pt擾B
	 * @param idx CfbNX
	 * @return p[^pt
	 */
	public String getAryHidDate(int idx) {
		return escapeHTML(aryHidDate[idx]);
	}
	
}
