/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.mospcommon.system.dto.CmLaborAgreementDto;

/**
 * @author matsusita
 *
 */
public class LaborAgreementCardVo extends MosPVo {
	
	private static final long	serialVersionUID		= 4132442013076434822L;
	
	// 萔
	/**
	 * 
	 */
	public static final int		MODE_INSERT				= 0;
	/**
	 * 
	 */
	public static final int		MODE_UPDATE				= 1;
	
	// p[^
	/**
	 * 
	 */
	public static final String	PRM_PLT_J_CODE			= "pltJCode";
	/**
	 * 
	 */
	public static final String	PRM_PLT_S_CODE			= "pltSCode";
	/**
	 * 
	 */
	public static final String	PRM_PLT_AGREE_CODE		= "pltAgreeCode";
	/**
	 * 
	 */
	public static final String	PRM_HID_AGREE_TYPE		= "hidAgreeType";
	/**
	 * 
	 */
	public static final String	PRM_PLT_OVER_TIME_CODE	= "pltOverTimeCode";
	/**
	 * 
	 */
	public static final String	PRM_PLT_WORK_ON_CODE	= "pltWorkOnCode";
	/**
	 * 
	 */
	public static final String	PRM_PLT_DELETE			= "pltDelete";
	
	// tB[h
	private String				pltJCode;
	private String				pltSCode;
	private String				pltAgreeCode;
	private String				hidAgreeType;
	private String				pltOverTimeCode;
	private String				pltWorkOnCode;
	private String				pltDelete;
	
	private String[]			aryPltAgreeCode;
	
	// v_EXg
	/**
	 * ƏR[h
	 */
	public String[][]			aryPltJCode;
	/**
	 * R[h
	 */
	public String[][]			aryPltSCode;
	/**
	 * ЈR[h
	 */
	public String[][]			aryPltKCode;
	/**
	 * ԊOR[h
	 */
	public String[][]			aryPltOverTimeCode;
	/**
	 * xoR[h
	 */
	public String[][]			aryPltWorkOnCode;
	
	// tB[hyѐ
	/**
	 * 
	 */
	public String				NAM_OFFICE;
	/**
	 * 
	 */
	public String				NAM_STATION;
	/**
	 * 
	 */
	public String				NAM_K_NAME;
	/**
	 * 
	 */
	public String				NAM_AGREE_CODE;
	/**
	 * 
	 */
	public String				NAM_AGREE_TYPE;
	/**
	 * 
	 */
	public String				NAM_OVER_TIME_CODE;
	/**
	 * 
	 */
	public String				NAM_WORK_ON_CODE;
	/**
	 * 
	 */
	public String				NAM_DELETE;
	
	// [h(0FVKo^A1FXV)
	private int					mode;
	

	/**
	 * RXgN^
	 */
	public LaborAgreementCardVo() {
		super();
		setViewPath(getClassName());
	}
	
	@Override
	protected void setSubTitle() {
		subTitle = CommonConst.TTL_LABOR_AGREEMENT;
		createAryMenu(CMD_MENU_SYSTEM2, MosPMenuConst.getMenuLaborAgreement());
	}
	
	@Override
	protected void setFieldsName() {
		NAM_OFFICE = CommonConst.NAM_OFFICE;
		NAM_STATION = CommonConst.NAM_STATION;
		NAM_K_NAME = CommonConst.NAM_K_NAME;
		NAM_AGREE_CODE = CommonConst.NAM_AGREEMENT + CommonConst.NAM_COMMON_CODE;
		NAM_AGREE_TYPE = CommonConst.NAM_AGREE_TYPE;
		NAM_OVER_TIME_CODE = CommonConst.NAM_OVER_TIME + CommonConst.NAM_AGREEMENT + CommonConst.NAM_COMMON_CODE;
		NAM_WORK_ON_CODE = CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_AGREEMENT + CommonConst.NAM_COMMON_CODE;
		NAM_DELETE = CommonConst.NAM_DELETE_FLAG;
	}
	
	@Override
	public void setParams(HttpServletRequest request) {
		aryPltAgreeCode = request.getParameterValues(PRM_PLT_AGREE_CODE);
		pltJCode = request.getParameter(PRM_PLT_J_CODE);
		pltSCode = request.getParameter(PRM_PLT_S_CODE);
		hidAgreeType = request.getParameter(PRM_HID_AGREE_TYPE);
		pltOverTimeCode = request.getParameter(PRM_PLT_OVER_TIME_CODE);
		pltWorkOnCode = request.getParameter(PRM_PLT_WORK_ON_CODE);
		pltDelete = request.getParameter(PRM_PLT_DELETE);
	}
	
	/**
	 * tB[hݒ
	 * @param dto ΏDTO
	 */
	public void setFields(CmLaborAgreementDto dto) {
		pltAgreeCode = dto.getAgreeCode();
		hidAgreeType = dto.getAgreeType();
		pltOverTimeCode = dto.getOverTimeCode();
		pltWorkOnCode = dto.getWorkOnCode();
		pltDelete = String.valueOf(dto.getDeleteFlag());
	}
	
	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 * @param i i
	 */
	public void setDtoFields(CmLaborAgreementDto dto, int i) {
		dto.setAgreeCode(aryPltAgreeCode[i]);
		dto.setAgreeType(hidAgreeType);
		dto.setOverTimeCode(pltOverTimeCode);
		dto.setWorkOnCode(pltWorkOnCode);
		dto.setDeleteFlag(Integer.parseInt(pltDelete));
	}
	
	/**
	 * tB[h̑ÓmF
	 * @throws MospException MosPOꍇ
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(hidAgreeType, NAM_AGREE_TYPE, PRM_HID_AGREE_TYPE);
		checkRequired(pltOverTimeCode, NAM_OVER_TIME_CODE, PRM_PLT_OVER_TIME_CODE);
		checkRequired(pltWorkOnCode, NAM_WORK_ON_CODE, PRM_PLT_WORK_ON_CODE);
		// ÓmFI
		endValidation();
	}
	
	@Override
	public String getDirectJs(Class<?> cls, Object obj) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls, obj));
		sb.append("MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}
	
	// ANZT\bh	
	/**
	 * @return aryPltAgreeCode
	 */
	public String[] getAryPltAgreeCode() {
		return aryPltAgreeCode.clone();
	}
	
	/**
	 * @return pltJCode
	 */
	public String getPltJCode() {
		return pltJCode;
	}
	
	/**
	 * @return pltSCode
	 */
	public String getPltSCode() {
		return pltSCode;
	}
	
	/**
	 * @return pltAgreeCode
	 */
	public String getPltAgreeCode() {
		return pltAgreeCode;
	}
	
	/**
	 * @return hidAgreeType
	 */
	public String getHidAgreeType() {
		return hidAgreeType;
	}
	
	/**
	 * @return pltOverTimeCode
	 */
	public String getPltOverTimeCode() {
		return pltOverTimeCode;
	}
	
	/**
	 * @return pltWorkOnCode
	 */
	public String getPltWorkOnCode() {
		return pltWorkOnCode;
	}
	
	/**
	 * @return pltDelete
	 */
	public String getPltDelete() {
		return pltDelete;
	}
	
	/**
	 * @return hidAgreeType
	 */
	public String getEscHidAgreeType() {
		return escapeHTML(hidAgreeType);
	}
	
	/**
	 * @param pltJCode Zbg pltJCode
	 */
	public void setPltJCode(String pltJCode) {
		this.pltJCode = pltJCode;
	}
	
	/**
	 * @param pltSCode Zbg pltSCode
	 */
	public void setPltSCode(String pltSCode) {
		this.pltSCode = pltSCode;
	}
	
	/**
	 * @param pltAgreeCode Zbg pltAgreeCode
	 */
	public void setPltAgreeCode(String pltAgreeCode) {
		this.pltAgreeCode = pltAgreeCode;
	}
	
	/**
	 * @param hidAgreeType Zbg hidAgreeType
	 */
	public void setHidAgreeType(String hidAgreeType) {
		this.hidAgreeType = hidAgreeType;
	}
	
	/**
	 * @param pltOverTimeCode Zbg pltOverTimeCode
	 */
	public void setPltOverTimeCode(String pltOverTimeCode) {
		this.pltOverTimeCode = pltOverTimeCode;
	}
	
	/**
	 * @param pltWorkOnCode Zbg pltWorkOnCode
	 */
	public void setPltWorkOnCode(String pltWorkOnCode) {
		this.pltWorkOnCode = pltWorkOnCode;
	}
	
	/**
	 * @param pltDelete Zbg pltDelete
	 */
	public void setPltDelete(String pltDelete) {
		this.pltDelete = pltDelete;
	}
	
	/**
	 * @return mode
	 */
	public int getMode() {
		return mode;
	}
	
	/**
	 * @param mode Zbg mode
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}
	
}
