/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.mospcommon.system.dao.CmAgreementWorkOnDao;
import jp.mosp.mospcommon.system.dto.CmAgreementWorkOnDto;
import jp.mosp.mospcommon.system.vo.WorkOnHolidayAgreementListVo;

/**
 * @author matsusita
 *
 */
public class WorkOnHolidayAgreementListAction extends MosPAction {
	
	// R}h
	private static final String	CMD_AGREEMENT_LIST_SHOW			= "S2530";
	private static final String	CMD_AGREEMENT_LIST_SEARCH		= "S2531";
	private static final String	CMD_AGREEMENT_LIST_RE_SEARCH	= "S2532";
	private static final String	CMD_AGREEMENT_LIST_SORT			= "S2533";
	

	/**
	 * RXgN^
	 */
	public WorkOnHolidayAgreementListAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾
		prepareVo();
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_AGREEMENT_LIST_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_AGREEMENT_LIST_SEARCH)) {
			// 
			search();
		} else if (cmd.equals(CMD_AGREEMENT_LIST_RE_SEARCH)) {
			// Č
			research();
		} else if (cmd.equals(CMD_AGREEMENT_LIST_SORT)) {
			// \[g
			sortList(key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new WorkOnHolidayAgreementListVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
	}
	
	@Override
	protected void show() throws Exception {
		WorkOnHolidayAgreementListVo vo = (WorkOnHolidayAgreementListVo)getVo();
		vo.setPltDelete(MospConst.DELETE_FLAG_OFF);
		// lɃZbg
		vo.setSearchmode(WorkOnHolidayAgreementListVo.SEARCH_OFF);
	}
	
	@Override
	protected void search() throws Exception {
		WorkOnHolidayAgreementListVo vo = (WorkOnHolidayAgreementListVo)getVo();
		vo.setParams(request);
		searchAgreementList();
		vo.setIsAscending(true);
		vo.initListInfo();
		// ɃZbg
		vo.setSearchmode(WorkOnHolidayAgreementListVo.SEARCH_ON);
	}
	
	@Override
	protected void research() throws Exception {
		WorkOnHolidayAgreementListVo vo = (WorkOnHolidayAgreementListVo)getVo();
		if (vo.getSearchmode() == WorkOnHolidayAgreementListVo.SEARCH_ON) {
			removeSessionDto();
			searchAgreementList();
			vo.setPageButton();
			sortList();
		}
	}
	
	/**
	 * 胊Xg
	 * @throws Exception Oꍇ
	 */
	private void searchAgreementList() throws Exception {
		WorkOnHolidayAgreementListVo vo = (WorkOnHolidayAgreementListVo)getVo();
		CmAgreementWorkOnDao dao = new CmAgreementWorkOnDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// 
		vo.setFields(dao.findForCondition(vo.getTxtWorkOnCode(), vo.getTxtWorkTypeName(), vo.getPltDelete()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryWorkOnCode().length == 0) {
			addErrMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void sortList(String key) throws MospException {
		WorkOnHolidayAgreementListVo vo = (WorkOnHolidayAgreementListVo)getVo();
		vo.sortList(key, getComparator(key));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected void sortList() throws MospException {
		WorkOnHolidayAgreementListVo vo = (WorkOnHolidayAgreementListVo)getVo();
		vo.sortList(getComparator(vo.getFormerKey()));
		vo.setFields(vo.getList());
	}
	
	@Override
	protected Comparator<Object> getComparator(String key) throws MospException {
		WorkOnHolidayAgreementListVo vo = (WorkOnHolidayAgreementListVo)getVo();
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_WORK_ON_CODE)) {
			comp = new CompWorkOnCode();
		} else if (key.equals(vo.KEY_WORK_TYPE_NAME)) {
			comp = new CompWorkTypeName();
		} else if (key.equals(vo.KEY_START_DATE)) {
			comp = new CompStartDate();
		} else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompDeleteFlag();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}
	

	/**
	 * xoR[hɂrNX
	 */
	protected static class CompWorkOnCode implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -2070871406750997603L;
		

		public int compare(Object obj1, Object obj2) {
			CmAgreementWorkOnDto dto1 = (CmAgreementWorkOnDto)obj1;
			CmAgreementWorkOnDto dto2 = (CmAgreementWorkOnDto)obj2;
			return dto1.getWorkOnCode().compareTo(dto2.getWorkOnCode());
		}
	}
	
	/**
	 * Ɩ̎ނɂrNX
	 */
	protected static class CompWorkTypeName implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= 2342333242957080405L;
		

		public int compare(Object obj1, Object obj2) {
			CmAgreementWorkOnDto dto1 = (CmAgreementWorkOnDto)obj1;
			CmAgreementWorkOnDto dto2 = (CmAgreementWorkOnDto)obj2;
			return dto1.getWorkTypeName().compareTo(dto2.getWorkTypeName());
		}
	}
	
	/**
	 * JnNɂrNX
	 */
	protected static class CompStartDate implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -5328266035040997905L;
		

		public int compare(Object obj1, Object obj2) {
			CmAgreementWorkOnDto dto1 = (CmAgreementWorkOnDto)obj1;
			CmAgreementWorkOnDto dto2 = (CmAgreementWorkOnDto)obj2;
			return dto1.getStartDate().compareTo(dto2.getStartDate());
		}
	}
	
	/**
	 * 폜tOɂrNX
	 */
	protected static class CompDeleteFlag implements Comparator<Object>, Serializable {
		
		private static final long	serialVersionUID	= -4190738984728973084L;
		

		public int compare(Object obj1, Object obj2) {
			CmAgreementWorkOnDto dto1 = (CmAgreementWorkOnDto)obj1;
			CmAgreementWorkOnDto dto2 = (CmAgreementWorkOnDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}
	
}
