/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/**
 * 
 */
package jp.mosp.mospcommon.system.action;

import java.util.Date;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.utils.DateUtil;
import jp.mosp.mospcommon.system.LaborAgreementManager;
import jp.mosp.mospcommon.system.dao.CmLaborAgreementDao;
import jp.mosp.mospcommon.system.dto.CmLaborAgreementDto;
import jp.mosp.mospcommon.system.vo.LaborAgreementCardVo;

/**
 * @author matsusita
 *
 */
public class LaborAgreementCardAction extends MosPAction {
	
	// R}h
	private static final String	CMD_AGREEMENT_CARD_SHOW		= "S2515";
	private static final String	CMD_AGREEMENT_CARD_SELECT	= "S2516";
	private static final String	CMD_AGREEMENT_CARD_INSERT	= "S2517";
	private static final String	CMD_AGREEMENT_CARD_UPDATE	= "S2518";
	private static final String	CMD_AGREEMENT_CARD_SEARCH	= "S2519";
	

	/**
	 * RXgN^
	 */
	public LaborAgreementCardAction() {
		super();
	}
	
	public void action() throws Exception {
		// VO̎擾yѐݒ
		prepareVo(false);
		// 
		init();
		// R}h̏
		if (cmd.equals(CMD_AGREEMENT_CARD_SHOW)) {
			// \iVKo^j
			show();
		} else if (cmd.equals(CMD_AGREEMENT_CARD_SELECT)) {
			// \(L[ŏ)
			select();
		} else if (cmd.equals(CMD_AGREEMENT_CARD_INSERT)) {
			// VKo^
			insert();
		} else if (cmd.equals(CMD_AGREEMENT_CARD_UPDATE)) {
			// XV
			update();
		} else if (cmd.equals(CMD_AGREEMENT_CARD_SEARCH)) {
			// 
			search();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	@Override
	protected BaseVo getSpecificVo() {
		return new LaborAgreementCardVo();
	}
	
	@Override
	protected void init() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		LaborAgreementCardVo vo = (LaborAgreementCardVo)getVo();
		LaborAgreementManager laborAgreement = new LaborAgreementManager(cfg, cmd, aspUser, user, conn);
		Date date = DateUtil.getSystemDate();
		// ƏR[h
		vo.aryPltJCode = new String[0][0];
		// R[h
		vo.aryPltSCode = new String[0][0];
		// ЈR[h
		vo.aryPltKCode = new String[0][0];
		// ԊOR[h
		vo.aryPltOverTimeCode = laborAgreement.getOverTimeArray(date);
		// xoR[h
		vo.aryPltWorkOnCode = laborAgreement.getWorkOnArray(date);
		// R[hꌏo^ĂȂꍇ
		if (vo.aryPltOverTimeCode.length == 0 || vo.aryPltWorkOnCode.length == 0) {
			// bZ[Wݒ
			setMessage(getMessage(MospConst.MSG_NO_DATA, ""));
		}
	}
	
	@Override
	protected void show() {
		LaborAgreementCardVo vo = (LaborAgreementCardVo)getVo();
		vo.setHidAgreeType(LaborAgreementManager.K_CODE);
		// [hݒ
		vo.setMode(LaborAgreementCardVo.MODE_INSERT);
	}
	
	@Override
	protected void select() throws Exception {
		LaborAgreementCardVo vo = (LaborAgreementCardVo)getVo();
		CmLaborAgreementDao dao = new CmLaborAgreementDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		CmLaborAgreementDto dto = dao.findForKey(key1, key2);
		chkExist(dto);
		// VOɏZbg
		vo.setFields(dto);
		// [hݒ
		vo.setMode(LaborAgreementCardVo.MODE_UPDATE);
		// ZbVDTOZbg
		setSessionDto(dto);
	}
	
	@Override
	protected void insert() throws Exception {
		LaborAgreementCardVo vo = (LaborAgreementCardVo)getVo();
		vo.setParams(request);
		vo.setPltDelete(String.valueOf(MospConst.DELETE_FLAG_OFF));
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		CmLaborAgreementDao dao = new CmLaborAgreementDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTȌ
		CmLaborAgreementDto dto = new CmLaborAgreementDto();
		String[] aryAgreeCode = vo.getAryPltAgreeCode();
		for (int i = 0; i < aryAgreeCode.length; i++) {
			vo.setDtoFields(dto, i);
			// d`FbN
			chkDuplicate(dao.findForKey(aryAgreeCode[i], vo.getHidAgreeType()));
			// f[^̑}
			dao.insert(dto);
			// DTO̍Ď擾
			CmLaborAgreementDto retDto = dao.findForKey(dto.getAgreeCode(), dto.getAgreeType());
			chkInsert(retDto);
		}
		// R~bg
		commit();
		// bZ[Wݒ
		setMessage(getMessage(MospConst.MSG_INSERT, ""));
		// ꗗ֑J
		setNextCmd(LaborAgreementListAction.CMD_AGREEMENT_LIST_RE_SEARCH);
	}
	
	@Override
	protected void update() throws Exception {
		// DTO̎擾
		CmLaborAgreementDto dto = (CmLaborAgreementDto)getSessionDto();
		LaborAgreementCardVo vo = (LaborAgreementCardVo)getVo();
		vo.setParams(request);
		// p[^̑ÓmF
		vo.validate();
		// DTȌ
		vo.setDtoFields(dto, 0);
		// DAȌ
		CmLaborAgreementDao dao = new CmLaborAgreementDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// rmF
		chkExclusive(dto, dao.findForUpdate(vo.getAryPltAgreeCode()[0], vo.getHidAgreeType()));
		// f[^̍XV
		dao.update(dto);
		// DTO̍Ď擾
		CmLaborAgreementDto retDto = dao.findForKey(dto.getAgreeCode(), dto.getAgreeType());
		chkUpdate(retDto);
		// R~bg
		commit();
		// [hݒ
		vo.setMode(LaborAgreementCardVo.MODE_UPDATE);
		// bZ[Wݒ
		setMessage(getMessage(MospConst.MSG_UPDATE, ""));
		// ZbVDTOZbg
		setSessionDto(retDto);
	}
	
	@Override
	protected void search() {
		LaborAgreementCardVo vo = (LaborAgreementCardVo)getVo();
		vo.setParams(request);
		vo.aryPltKCode = new String[0][0];
	}
	
}
