/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.payroll.dto.KdPaidHolidayDto;

/**
 * KD_PAID_HOLIDAY(LxǗe[u)DAONX B
 */
public class KdPaidHolidayDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * KD_PAID_HOLIDAY(LxǗe[u)B
	 */
	public static final String	TABLE					= "KD_PAID_HOLIDAY";
	
	/**
	 * KEY_1 = PAID_ID(LxID)B
	 */
	public static final String	KEY_1					= "PAID_ID";
	/**
	 * KEY_2 = K_CODE(ЈR[h)B
	 */
	public static final String	KEY_2					= "K_CODE";
	
	// 
	/**
	 * PAID_ID(LxID)B
	 */
	public static final String	COL_PAID_ID				= "PAID_ID";
	/**
	 * K_CODE(ЈR[h)B
	 */
	public static final String	COL_K_CODE				= "K_CODE";
	/**
	 * PROCESS_TYPE(R[h)B
	 */
	public static final String	COL_PROCESS_TYPE		= "PROCESS_TYPE";
	/**
	 * PROCESS_DATE(x)B
	 */
	public static final String	COL_PROCESS_DATE		= "PROCESS_DATE";
	/**
	 * LAST_REMAIN_DAYS(ONxc)B
	 */
	public static final String	COL_LAST_REMAIN_DAYS	= "LAST_REMAIN_DAYS";
	/**
	 * LAST_REMAIN_HOUR(ONxc)B
	 */
	public static final String	COL_LAST_REMAIN_HOUR	= "LAST_REMAIN_HOUR";
	/**
	 * REMAIN_DAYS(Nxc)B
	 */
	public static final String	COL_REMAIN_DAYS			= "REMAIN_DAYS";
	/**
	 * REMAIN_HOUR(Nxc)B
	 */
	public static final String	COL_REMAIN_HOUR			= "REMAIN_HOUR";
	/**
	 * POSSIBLE(ԒPʎ擾\)B
	 */
	public static final String	COL_POSSIBLE			= "POSSIBLE";
	/**
	 * DELETE_FLAG(폜tO)B
	 */
	public static final String	COL_DELETE_FLAG			= "DELETE_FLAG";
	

	/**
	 * RXgN^B
	 */
	public KdPaidHolidayDao() {
		super();
		INSERT_DATE = "INSERT_DATE";
		INSERT_USER = "INSERT_USER";
		UPDATE_DATE = "UPDATE_DATE";
		UPDATE_USER = "UPDATE_USER";
	}
	
	/**
	 * ʎ擾(DTOList)B
	 * @return ʃXg
	 * @throws SQLException 	SQLOꍇ
	 */
	private List<KdPaidHolidayDto> mappingAll() throws SQLException {
		List<KdPaidHolidayDto> all = new ArrayList<KdPaidHolidayDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)B
	 * @return KD_PAID_HOLIDAYR[h
	 * @throws SQLException 	SQLOꍇ
	 */
	private KdPaidHolidayDto mapping() throws SQLException {
		KdPaidHolidayDto dto = new KdPaidHolidayDto();
		dto.setPaidId(rs.getLong(COL_PAID_ID));
		dto.setKCode(rs.getString(COL_K_CODE));
		dto.setProcessType(rs.getString(COL_PROCESS_TYPE));
		dto.setProcessDate(rs.getDate(COL_PROCESS_DATE));
		dto.setLastRemainDays(rs.getDouble(COL_LAST_REMAIN_DAYS));
		dto.setLastRemainHour(rs.getInt(COL_LAST_REMAIN_HOUR));
		dto.setRemainDays(rs.getDouble(COL_REMAIN_DAYS));
		dto.setRemainHour(rs.getInt(COL_REMAIN_HOUR));
		dto.setPossible(rs.getInt(COL_POSSIBLE));
		dto.setDeleteFlag(rs.getInt(COL_DELETE_FLAG));
		mappingCommonInfo(dto);
		return dto;
	}
	
	/**
	 * Sf[^擾B
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KdPaidHolidayDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾B
	 * @param paidId LxID
	 * @param kCode ЈR[h
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public KdPaidHolidayDto findForKey(long paidId, String kCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, paidId);
			setParam(index++, kCode);
			executeQuery();
			KdPaidHolidayDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾B
	 * @param paidId LxID
	 * @param kCode ЈR[h
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public KdPaidHolidayDto findForUpdate(long paidId, String kCode) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, paidId);
			setParam(index++, kCode);
			executeQuery();
			KdPaidHolidayDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param paidId LxID
	 * @param kCode ЈR[h
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KdPaidHolidayDto> findForCondition(long paidId, String kCode) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_PAID_ID);
		sb.append(" = ? AND ");
		sb.append(COL_K_CODE);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, paidId);
			setParam(index++, kCode);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param kCode ЈR[h
	 * @param processType ΏۏR[h
	 * @param startDate JnN
	 * @param endDate IN
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KdPaidHolidayDto> findForCondition(String kCode, String processType, Date startDate, Date endDate)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_DELETE_FLAG);
		sb.append(" = " + MospConst.DELETE_FLAG_OFF);
		sb.append(" AND ");
		sb.append(COL_K_CODE);
		sb.append(" = ? AND ");
		sb.append(COL_PROCESS_TYPE);
		sb.append(" = ? ");
		sb.append(" AND ");
		sb.append(COL_PROCESS_DATE);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_PROCESS_DATE);
		sb.append(" <= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, processType);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param kCode ЈR[h
	 * @param startDate JnN
	 * @param endDate IN
	 * @return (DTOList)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<KdPaidHolidayDto> findForCondition(String kCode, Date startDate, Date endDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append(" WHERE ");
		sb.append(COL_K_CODE);
		sb.append(" = ? AND ");
		sb.append(COL_PROCESS_DATE);
		sb.append(" >= ? ");
		sb.append(" AND ");
		sb.append(COL_PROCESS_DATE);
		sb.append(" <= ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, kCode);
			setParam(index++, startDate);
			setParam(index++, endDate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param kCode ЈR[h
	 * @param processType ΏۏR[h
	 * @param processDate Ώ۔N
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public KdPaidHolidayDto findForProcess(String kCode, String processType, Date processDate) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_K_CODE);
			sb.append(" = ? AND ");
			sb.append(COL_PROCESS_TYPE);
			sb.append(" = ? AND ");
			sb.append(COL_PROCESS_DATE);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, processType);
			setParam(index++, processDate);
			executeQuery();
			KdPaidHolidayDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B
	 * @param kCode ЈR[h
	 * @param processType ΏۏR[h
	 * @param processDate Ώ۔N
	 * @return (DTO)
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public KdPaidHolidayDto findForProcessNearlyDate(String kCode, String processType, Date processDate)
			throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(" WHERE ");
			sb.append(COL_DELETE_FLAG);
			sb.append(" = " + MospConst.DELETE_FLAG_OFF);
			sb.append(" AND ");
			sb.append(COL_K_CODE);
			sb.append(" = ? AND ");
			sb.append(COL_PROCESS_TYPE);
			sb.append(" = ? AND ");
			sb.append(COL_PROCESS_DATE);
			sb.append(" <= ? ");
			sb.append(getOrderBy());
			sb.append(COL_PROCESS_DATE);
			sb.append(" ");
			sb.append(getDesc());
			sb.append(getLimit());
			sb.append("1");
			prepareStatement(getSelectQuery(getClass()) + sb.toString());
			setParam(index++, kCode);
			setParam(index++, processType);
			setParam(index++, processDate);
			executeQuery();
			KdPaidHolidayDto dto = null;
			if (rs.next()) {
				dto = mapping();
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * maxl擾
	 * @param kCode ΏێЈR[h
	 * @return String@őA
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public String findForMax(String kCode) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			String maxPaidId = "";
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("SELECT MAX(");
			sb.append(COL_PAID_ID);
			sb.append(") FROM ");
			sb.append(TABLE);
			sb.append(" WHERE ");
			sb.append(COL_K_CODE);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, kCode);
			executeQuery();
			if (rs.next()) {
				maxPaidId = String.valueOf(rs.getInt(1));
			}
			return maxPaidId;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}B
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(KdPaidHolidayDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * @param list		VLxɏ
	 * @param divSize	
	 * @return	}()
	 * @throws SQLException SQLOꍇ
	 * @throws IllegalAccessException	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(List<KdPaidHolidayDto> list, int divSize) throws SQLException, IllegalAccessException,
			NoSuchFieldException, MospException {
		try {
			index = 1;
			int listSize = list.size();
			int rev = listSize / divSize + 1;
			if (listSize % divSize == 0) {
				rev--;
			}
			int insertCount = 0;
			List<KdPaidHolidayDto> divList = new ArrayList<KdPaidHolidayDto>();
			for (int i = 0; i < rev; i++) {
				// XgdivƕB
				for (int k = 0; k < divSize; k++) {
					int count = k + (i * divSize);
					if (count >= listSize) {
						break;
					}
					divList.add(list.get(count));
				}
				int divListSize = divList.size();
				prepareStatement(getInsertQuery(getClass(), divListSize, divSize));
				for (KdPaidHolidayDto dto : divList) {
					setParams(dto, true);
				}
				executeUpdate();
				clearParams();
				index = 1;
				divList.clear();
				chkInsert(divListSize);
				insertCount += cnt;
			}
			return insertCount;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XVB
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(KdPaidHolidayDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getPaidId());
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜B
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException 	SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(KdPaidHolidayDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getPaidId());
			setParam(index++, dto.getKCode());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒB
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseF})
	 * @throws SQLException 	SQLOꍇ
	 */
	private void setParams(KdPaidHolidayDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getPaidId());
		setParam(index++, dto.getKCode());
		setParam(index++, dto.getProcessType());
		setParam(index++, dto.getProcessDate());
		setParam(index++, dto.getLastRemainDays());
		setParam(index++, dto.getLastRemainHour());
		setParam(index++, dto.getRemainDays());
		setParam(index++, dto.getRemainHour());
		setParam(index++, dto.getPossible());
		setParam(index++, dto.getDeleteFlag());
		setCommonParams(isInsert);
	}
	
}
