/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.common.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;
import jp.mosp.kintai.common.dto.MYakusyokuDto;

/**
 * M_YAKUSYOKU(E}X^)DAONX B
 */
public class MYakusyokuDao extends BaseDao {
	
	// e[uyуL[
	/**
	 * M_YAKUSYOKU(E}X^)B
	 */
	public static final String	TABLE			= "M_YAKUSYOKU";
	
	/**
	 * KEY_1 = YCODE(ER[h)B
	 */
	public static final String	KEY_1			= "YCODE";
	/**
	 * KEY_2 = TOKYU()B
	 */
	public static final String	KEY_2			= "TOKYU";
	
	// 
	/**
	 * YCODE(ER[h)B
	 */
	public static final String	COL_YCODE		= "YCODE";
	/**
	 * YNAME(E)B
	 */
	public static final String	COL_YNAME		= "YNAME";
	/**
	 * TOKYU()B
	 */
	public static final String	COL_TOKYU		= "TOKYU";
	/**
	 * TKEKKIN(ʋxɍTL)B
	 */
	public static final String	COL_TKEKKIN		= "TKEKKIN";
	/**
	 * KEKKIN(ʌ΍TL)B
	 */
	public static final String	COL_KEKKIN		= "KEKKIN";
	/**
	 * SKEKKIN(a΍TL)B
	 */
	public static final String	COL_SKEKKIN		= "SKEKKIN";
	/**
	 * TIJI(xލTL)B
	 */
	public static final String	COL_TIJI		= "TIJI";
	/**
	 * ZAJI(ʎcƎ蓖L)B
	 */
	public static final String	COL_ZAJI		= "ZAJI";
	/**
	 * KSJI(xcƎ蓖L)B
	 */
	public static final String	COL_KSJI		= "KSJI";
	/**
	 * SNJI([cƎ蓖L)B
	 */
	public static final String	COL_SNJI		= "SNJI";
	/**
	 * KAIKIN(FΎ蓖L)B
	 */
	public static final String	COL_KAIKIN		= "KAIKIN";
	/**
	 * SYOKUJI(H蓖L)B
	 */
	public static final String	COL_SYOKUJI		= "SYOKUJI";
	/**
	 * CYOKU1(1蓖L)B
	 */
	public static final String	COL_CYOKU1		= "CYOKU1";
	/**
	 * CYOKU2(2蓖L)B
	 */
	public static final String	COL_CYOKU2		= "CYOKU2";
	/**
	 * CYOKU3(3蓖L)B
	 */
	public static final String	COL_CYOKU3		= "CYOKU3";
	/**
	 * HOKA1(̑x1L)B
	 */
	public static final String	COL_HOKA1		= "HOKA1";
	/**
	 * HOKA2(̑x2L)B
	 */
	public static final String	COL_HOKA2		= "HOKA2";
	/**
	 * HOKA3(̑x3L)B
	 */
	public static final String	COL_HOKA3		= "HOKA3";
	/**
	 * HOKA4(̑x4L)B
	 */
	public static final String	COL_HOKA4		= "HOKA4";
	/**
	 * HOKA5(̑x5L)B
	 */
	public static final String	COL_HOKA5		= "HOKA5";
	/**
	 * TKEKKINTAN(ʋxɍTP)B
	 */
	public static final String	COL_TKEKKINTAN	= "TKEKKINTAN";
	/**
	 * KEKKINTAN(ʌ΍TP)B
	 */
	public static final String	COL_KEKKINTAN	= "KEKKINTAN";
	/**
	 * SKEKKINTAN(a΍TP)B
	 */
	public static final String	COL_SKEKKINTAN	= "SKEKKINTAN";
	/**
	 * TIJITAN(xލTP)B
	 */
	public static final String	COL_TIJITAN		= "TIJITAN";
	/**
	 * ZAJITAN(ʎcƎ蓖P)B
	 */
	public static final String	COL_ZAJITAN		= "ZAJITAN";
	/**
	 * KSJITAN(xcƎ蓖P)B
	 */
	public static final String	COL_KSJITAN		= "KSJITAN";
	/**
	 * SNJITAN([cƎ蓖P)B
	 */
	public static final String	COL_SNJITAN		= "SNJITAN";
	/**
	 * KAIKINTAN(FΎ蓖P)B
	 */
	public static final String	COL_KAIKINTAN	= "KAIKINTAN";
	/**
	 * SYOKUJITAN(H蓖P)B
	 */
	public static final String	COL_SYOKUJITAN	= "SYOKUJITAN";
	/**
	 * CYOKU1TAN(1蓖P)B
	 */
	public static final String	COL_CYOKU1TAN	= "CYOKU1TAN";
	/**
	 * CYOKU2TAN(2蓖P)B
	 */
	public static final String	COL_CYOKU2TAN	= "CYOKU2TAN";
	/**
	 * CYOKU3TAN(3蓖P)B
	 */
	public static final String	COL_CYOKU3TAN	= "CYOKU3TAN";
	/**
	 * HOKA1TAN(̑x1P)B
	 */
	public static final String	COL_HOKA1TAN	= "HOKA1TAN";
	/**
	 * HOKA2TAN(̑x2P)B
	 */
	public static final String	COL_HOKA2TAN	= "HOKA2TAN";
	/**
	 * HOKA3TAN(̑x3P)B
	 */
	public static final String	COL_HOKA3TAN	= "HOKA3TAN";
	/**
	 * HOKA4TAN(̑x4P)B
	 */
	public static final String	COL_HOKA4TAN	= "HOKA4TAN";
	/**
	 * HOKA5TAN(̑x5P)B
	 */
	public static final String	COL_HOKA5TAN	= "HOKA5TAN";
	

	/**
	 * RXgN^
	 */
	public MYakusyokuDao() {
		super();
	}
	
	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException SQLOꍇ
	 */
	private List<MYakusyokuDto> mappingAll() throws SQLException {
		List<MYakusyokuDto> all = new ArrayList<MYakusyokuDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ʎ擾(DTO)
	 * @return m_yakusyokuDto m_yakusyokuR[h
	 * @throws SQLException SQLOꍇ
	 */
	private MYakusyokuDto mapping() throws SQLException {
		MYakusyokuDto dto = new MYakusyokuDto();
		dto.setYcode(rs.getString(COL_YCODE));
		dto.setYname(rs.getString(COL_YNAME));
		dto.setTokyu(rs.getString(COL_TOKYU));
		dto.setTkekkin(rs.getString(COL_TKEKKIN));
		dto.setKekkin(rs.getString(COL_KEKKIN));
		dto.setSkekkin(rs.getString(COL_SKEKKIN));
		dto.setTiji(rs.getString(COL_TIJI));
		dto.setZaji(rs.getString(COL_ZAJI));
		dto.setKsji(rs.getString(COL_KSJI));
		dto.setSnji(rs.getString(COL_SNJI));
		dto.setKaikin(rs.getString(COL_KAIKIN));
		dto.setSyokuji(rs.getString(COL_SYOKUJI));
		dto.setCyoku1(rs.getString(COL_CYOKU1));
		dto.setCyoku2(rs.getString(COL_CYOKU2));
		dto.setCyoku3(rs.getString(COL_CYOKU3));
		dto.setHoka1(rs.getString(COL_HOKA1));
		dto.setHoka2(rs.getString(COL_HOKA2));
		dto.setHoka3(rs.getString(COL_HOKA3));
		dto.setHoka4(rs.getString(COL_HOKA4));
		dto.setHoka5(rs.getString(COL_HOKA5));
		dto.setTkekkintan(rs.getInt(COL_TKEKKINTAN));
		dto.setKekkintan(rs.getInt(COL_KEKKINTAN));
		dto.setSkekkintan(rs.getInt(COL_SKEKKINTAN));
		dto.setTijitan(rs.getInt(COL_TIJITAN));
		dto.setZajitan(rs.getInt(COL_ZAJITAN));
		dto.setKsjitan(rs.getInt(COL_KSJITAN));
		dto.setSnjitan(rs.getInt(COL_SNJITAN));
		dto.setKaikintan(rs.getInt(COL_KAIKINTAN));
		dto.setSyokujitan(rs.getInt(COL_SYOKUJITAN));
		dto.setCyoku1tan(rs.getInt(COL_CYOKU1TAN));
		dto.setCyoku2tan(rs.getInt(COL_CYOKU2TAN));
		dto.setCyoku3tan(rs.getInt(COL_CYOKU3TAN));
		dto.setHoka1tan(rs.getInt(COL_HOKA1TAN));
		dto.setHoka2tan(rs.getInt(COL_HOKA2TAN));
		dto.setHoka3tan(rs.getInt(COL_HOKA3TAN));
		dto.setHoka4tan(rs.getInt(COL_HOKA4TAN));
		dto.setHoka5tan(rs.getInt(COL_HOKA5TAN));
		return dto;
	}
	
	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<MYakusyokuDto> findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List<MYakusyokuDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾(L̂)
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<MYakusyokuDto> findAvailable() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_TOKYU);
			sb.append(" > '0' ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<MYakusyokuDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * Sf[^擾(̂)
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<MYakusyokuDto> findForTitle() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE NOT (");
			sb.append(COL_TOKYU);
			sb.append(" > '0' )");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			executeQuery();
			List<MYakusyokuDto> all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂf[^擾
	 * @param ycode ER[h(L[)
	 * @param tokyu (L[)
	 * @return m_yakusyokuDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public MYakusyokuDto findForKey(String ycode, String tokyu) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, ycode);
			setParam(index++, tokyu);
			executeQuery();
			MYakusyokuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * L[ɂsbN擾
	 * @param ycode ER[h(L[)
	 * @param tokyu (L[)
	 * @return m_yakusyokuDto (DTO)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public MYakusyokuDto findForUpdate(String ycode, String tokyu) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, ycode);
			setParam(index++, tokyu);
			executeQuery();
			MYakusyokuDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param ycode ER[h
	 * @param tokyu 
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<?> findForCondition(String ycode, String tokyu) throws SQLException, IllegalAccessException,
			NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_YCODE);
		sb.append(" = ? AND ");
		sb.append(COL_TOKYU);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, ycode);
			setParam(index++, tokyu + "%");
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾
	 * @param ycode ER[h
	 * @param tokyu 
	 * @param yname E
	 * @return List (DTOList)
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 */
	public List<?> findForCondition(String ycode, String tokyu, String yname) throws SQLException,
			IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_YCODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_TOKYU);
		sb.append(" LIKE ? AND ");
		sb.append(COL_YNAME);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, ycode + "%");
			setParam(index++, tokyu + "%");
			setParam(index++, "%" + yname + "%");
			executeQuery();
			List<?> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int insert(MYakusyokuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto, true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int update(MYakusyokuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getYcode());
			setParam(index++, dto.getTokyu());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException 			SQLOꍇ
	 * @throws IllegalAccessException 	\bhɃANZXłȂꍇ
	 * @throws NoSuchFieldException 	tB[hȂꍇ
	 * @throws MospException 	MosPOꍇ
	 */
	public int delete(MYakusyokuDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException,
			MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getYcode());
			setParam(index++, dto.getTokyu());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @param isInsert }tO(trueF}AfalseF})
	 * @throws SQLException 	SQLOꍇ
	 */
	private void setParams(MYakusyokuDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getYcode());
		setParam(index++, dto.getYname());
		setParam(index++, dto.getTokyu());
		setParam(index++, dto.getTkekkin());
		setParam(index++, dto.getKekkin());
		setParam(index++, dto.getSkekkin());
		setParam(index++, dto.getTiji());
		setParam(index++, dto.getZaji());
		setParam(index++, dto.getKsji());
		setParam(index++, dto.getSnji());
		setParam(index++, dto.getKaikin());
		setParam(index++, dto.getSyokuji());
		setParam(index++, dto.getCyoku1());
		setParam(index++, dto.getCyoku2());
		setParam(index++, dto.getCyoku3());
		setParam(index++, dto.getHoka1());
		setParam(index++, dto.getHoka2());
		setParam(index++, dto.getHoka3());
		setParam(index++, dto.getHoka4());
		setParam(index++, dto.getHoka5());
		setParam(index++, dto.getTkekkintan());
		setParam(index++, dto.getKekkintan());
		setParam(index++, dto.getSkekkintan());
		setParam(index++, dto.getTijitan());
		setParam(index++, dto.getZajitan());
		setParam(index++, dto.getKsjitan());
		setParam(index++, dto.getSnjitan());
		setParam(index++, dto.getKaikintan());
		setParam(index++, dto.getSyokujitan());
		setParam(index++, dto.getCyoku1tan());
		setParam(index++, dto.getCyoku2tan());
		setParam(index++, dto.getCyoku3tan());
		setParam(index++, dto.getHoka1tan());
		setParam(index++, dto.getHoka2tan());
		setParam(index++, dto.getHoka3tan());
		setParam(index++, dto.getHoka4tan());
		setParam(index++, dto.getHoka5tan());
		setCommonParams(isInsert);
	}
	
	/**
	 * EʃR[hoSQL擾
	 * @return f[^xEʃR[hoSQL
	 */
	public static String getForLowerLevel() {
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT ");
		sb.append(COL_YCODE);
		sb.append(" FROM ");
		sb.append(TABLE);
		sb.append(" WHERE ");
		sb.append(COL_YCODE + " >= ? ");
		return sb.toString();
	}
	
}
