/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.part;

import java.sql.Connection;
import java.util.Properties;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.InstanceFactory;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.utils.VariousUtil;

/**
 * ePartNX̊{ƂȂNX
 * @author yoshida
 *	@version	0.0.4
 */
public abstract class BasePart {
	
	/**
	 *  MosPAvP[Vݒ(/WEB-INF/mosp.properties)B
	 */
	protected Properties	cfg;
	/**
	 * NGXgꂽCommandB
	 */
	protected String		cmd;
	/**
	 * OCASP[U[B
	 */
	protected CmAspUserDto	aspUser;
	/**
	 * OC[U[B
	 */
	protected CmUserDto		user;
	/**
	 * DBRlNVB
	 */
	protected Connection	conn;
	

	/**
	 * RXgN^
	 */
	public BasePart() {
		super();
	}
	
	/**
	 * RXgN^
	 * @param partInfo	Part𗘗pۂɕKvȏ
	 */
	public BasePart(PartInfo partInfo) {
		this();
		init(partInfo);
	}
	
	/**
	 * 
	 * @param partInfo	Part𗘗pۂɕKvȏ
	 */
	public void init(PartInfo partInfo) {
		init(partInfo.getCfg(), partInfo.getCmd(), partInfo.getAspUser(), partInfo.getUser(), partInfo.getConn());
	}
	
	/**
	 * 
	 * @param cfg	MosPAvP[Vݒ(/WEB-INF/mosp.properties)B
	 * @param cmd	NGXgꂽCommandB
	 * @param aspUser	OCASP[U[B
	 * @param user	OC[U[B
	 * @param conn 	DBRlNVB
	 */
	public void init(Properties cfg, String cmd, CmAspUserDto aspUser, CmUserDto user, Connection conn) {
		this.cfg = cfg;
		this.cmd = cmd;
		this.aspUser = aspUser;
		this.user = user;
		this.conn = conn;
	}
	

	/**
	 * DAOtB[h
	 */
	private BaseDao	dao;
	

	/**
	 * ςDAO
	 * @param className		ΏDAONX
	 * @return				ΏۏςDAOCX^X
	 * @throws MospException MosPOꍇ
	 */
	protected BaseDao getPreparedDao(String className) throws MospException {
		// DAO
		if (dao == null || !dao.getClass().getName().equals(className)) {
			Object obj = InstanceFactory.loadInstance(className);
			if (obj instanceof BaseDao) {
				dao = (BaseDao)obj;
				dao.initDao(cfg, cmd, aspUser, user, conn);
			} else {
				final int exCode = 5014;
				throw new MospException(exCode, className + " is not instanceof BaseDao class.");
			}
		}
		return dao;
	}
	
	/**
	 * ςDAO
	 * @param cls ΏDAONX
	 * @return ΏۏςDAOCX^X
	 * @throws MospException MosPOꍇ
	 */
	protected BaseDao getPreparedDao(Class<?> cls) throws MospException {
		return getPreparedDao(cls.getCanonicalName());
	}
	

	private BaseStore	baseStore;
	

	/**
	 * ΏPartStoreCX^X擾B
	 * @since	0.0.4
	 * @return	PartStoreCX^X
	 * @throws MospException  MosPOꍇ
	 */
	protected PartStore part() throws MospException {
		return (PartStore)getBaseStore(PartStore.class);
	}
	
	/**
	 * ΏStoreCX^X擾B
	 * @since 0.0.5
	 * @param cls BaseStorepNX
	 * @return BaseStoreCX^X
	 * @throws MospException  MosPOꍇ
	 */
	protected BaseStore getBaseStore(Class<?> cls) throws MospException {
		if (VariousUtil.isNull(baseStore)) {
			baseStore = (BaseStore)InstanceFactory.loadInstance(cls.getCanonicalName());
			baseStore.setPartInfo(PartManager.createPartInfo(cfg, cmd, aspUser, user, conn));
		}
		return baseStore;
	}
	
}
