/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.vo;

import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPMenuConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.TimePart;
import jp.mosp.common.vo.MosPWorkFlowVo;

import jp.mosp.workflow.dto.CtOvertimeRequestDto;

public class OverTimeRequestCardVo extends MosPWorkFlowVo {

	private static final long serialVersionUID = -7782303860861379213L;

	// 萔
	public static final int MODE_INSERT 		= 0;
	public static final int MODE_UPDATE		= 1;
	public static final int MODE_REQUEST 		= 2;
	public static final int MODE_APPROVED 	= 3;
	public static final int MODE_RETURNED 	= 4;

	// p[^
	public static final String PRM_PLT_REQUEST_YEAR 	= "pltRequestYear";
	public static final String PRM_PLT_REQUEST_MONTH 	= "pltRequestMonth";
	public static final String PRM_PLT_REQUEST_DAY 	= "pltRequestDay";
	public static final String PRM_PLT_REQUEST_HOUR	= "pltRequestHour";
	public static final String PRM_PLT_REQUEST_MIN		= "pltRequestMin";
	public static final String PRM_TXT_REASON			= "txtReason";

	// tB[h
	private String pltRequestYear;
	private String pltRequestMonth;
	private String pltRequestDay;
	private String pltRequestHour;
	private String pltRequestMin;
	private String txtReason;

	private String lblKCode;
	private String lblKName;
	private String lblSection;

	private String lblApprover;
	private String lblStatus;

	// v_EXg
	public String[][] aryPltYear;
	public String[][] aryPltMonth;
	public String[][] aryPltDay;
	public String[][] aryPltHour;
	public String[][] aryPltMin;

	// [h(0FVKo^A1FύXA2FύXs)
	private int mode;

	// tB[hyѐ
	public static final String NAM_K_CODE 		= CommonConst.NAM_K_CODE;
	public static final String NAM_K_NAME 		= CommonConst.NAM_K_NAME;
	public static final String NAM_SECTION 	= CommonConst.NAM_STATION;

	public static final String NAM_WORK_DATE 			= CommonConst.NAM_WORKING + CommonConst.NAM_DAY;
	public static final String NAM_WORK_DATE_YEAR 		= CommonConst.NAM_WORKING + CommonConst.NAM_DAY + CommonConst.MSG_YEAR;
	public static final String NAM_WORK_DATE_MONTH 	= CommonConst.NAM_WORKING + CommonConst.NAM_DAY + CommonConst.MSG_MONTH;
	public static final String NAM_WORK_DATE_DAY 		= CommonConst.NAM_WORKING + CommonConst.NAM_DAY + CommonConst.MSG_DAY;
	public static final String NAM_REQUEST_TIME 		= CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME;
	public static final String NAM_REQUEST_TIME_HOUR 	= CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_HOUR;
	public static final String NAM_REQUEST_TIME_MIN 	= CommonConst.NAM_APPLICATION + CommonConst.NAM_COMMON_TIME + CommonConst.MSG_MINUTES;

	public static final String NAM_REASON 			= CommonConst.NAM_REASON;
	public static final String NAM_APPROVER 		= CommonConst.NAM_APPROVER;
	public static final String NAM_STATUS 			= CommonConst.NAM_APPROVAL_STATE;

	public static final int LEN_REASON = 50;

	/**
	 * RXgN^
	 * @param cfg
	 * @param msg
	 * @param nam
	 * @param cmd
	 * @param aspUser
	 * @param user
	 */
	public OverTimeRequestCardVo(
			Properties cfg,
			Properties msg,
			Properties nam,
			String cmd,
			CmAspUserDto aspUser,
			CmUserDto user
	) {
		super(cfg, msg, nam, cmd, aspUser, user);
		setViewPath(getClassName());
		aryPltYear 	= new String[0][0];
		aryPltMonth = new String[0][0];
		aryPltDay 	= new String[0][0];
		aryPltHour 	= new String[0][0];
		aryPltMin 	= new String[0][0];
		mode = MODE_INSERT;
	}

	public void setSubTitle() {
		subTitle = CommonConst.NAM_OVER_TIME_REQUEST;
		aryMenu = new String[][] {
				{ CMD_MENU_INPUT, CommonConst.NAM_TO_MENU },
				MosPMenuConst.getEmployeeCmdArray()[3],
		};
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		pltRequestYear = "0";
		pltRequestMonth = "0";
		pltRequestDay = "0";
		pltRequestHour = "0";
		pltRequestMin = "0";
		lblApprover = "";
		lblStatus = "";
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request) {
		pltRequestYear = request.getParameter(PRM_PLT_REQUEST_YEAR);
		pltRequestMonth = request.getParameter(PRM_PLT_REQUEST_MONTH);
		pltRequestDay = request.getParameter(PRM_PLT_REQUEST_DAY);
		pltRequestHour = request.getParameter(PRM_PLT_REQUEST_HOUR);
		pltRequestMin = request.getParameter(PRM_PLT_REQUEST_MIN);
		txtReason = request.getParameter(PRM_TXT_REASON);
		super.setParams(request);
	}

	/**
	 * tB[hݒ
	 * @param dto ݒΏDTO
	 */
	public void setFields(CtOvertimeRequestDto dto) {
		pltRequestYear = String.valueOf(MospUtility.getYear(dto.getWorkDate()));
		pltRequestMonth = String.valueOf(MospUtility.getMonth(dto.getWorkDate()));
		pltRequestDay = String.valueOf(MospUtility.getDay(dto.getWorkDate()));
		pltRequestHour = TimePart.convIntegerTimeToStringHour(dto.getOverTime());
		pltRequestMin = TimePart.convIntegerTimeToStringMinutes(dto.getOverTime());
		txtReason = dto.getReason();
		setHidVoucher(String.valueOf(dto.getVoucher()));
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFields(CtOvertimeRequestDto dto) {
		dto.setWorkDate(DatePart.getDate(pltRequestYear, pltRequestMonth, pltRequestDay));
		dto.setOverTime(TimePart.convStringTimeToIntegerTime(pltRequestHour, pltRequestMin));
		dto.setReason(txtReason);
	}

	/**
	 * tB[h̑ÓmF
	 * @throws MospException
	 */
	public void validate() throws MospException {
		// ÓmFJn
		startValidation();
		// K{mF
		checkRequired(pltRequestYear, NAM_WORK_DATE_YEAR, PRM_PLT_REQUEST_YEAR);
		checkRequired(pltRequestMonth, NAM_WORK_DATE_MONTH, PRM_PLT_REQUEST_MONTH);
		checkRequired(pltRequestDay, NAM_WORK_DATE_DAY, PRM_PLT_REQUEST_DAY);
		checkRequired(pltRequestHour, NAM_REQUEST_TIME_HOUR, PRM_PLT_REQUEST_HOUR);
		checkRequired(pltRequestMin, NAM_REQUEST_TIME_MIN, PRM_PLT_REQUEST_MIN);
		checkRequired(txtReason, NAM_REASON, PRM_TXT_REASON);
		// tÓmF
		checkDate(getIntParam(pltRequestYear), getIntParam(pltRequestMonth), getIntParam(pltRequestDay), NAM_WORK_DATE, PRM_PLT_REQUEST_DAY);
		// 񒷊mF
		checkLength(txtReason, LEN_REASON, NAM_REASON, PRM_TXT_REASON);
		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String getPltRequestYear() 	{ return pltRequestYear		; }
	public String getPltRequestMonth() 	{ return pltRequestMonth	; }
	public String getPltRequestDay() 	{ return pltRequestDay		; }
	public String getPltRequestHour() 	{ return pltRequestHour		; }
	public String getPltRequestMin() 	{ return pltRequestMin		; }
	public String getTxtReason() 		{ return txtReason			; }
	public String getLblApprover() 		{ return lblApprover		; }

	public String getEscLblKCode() 		{ return escapeHTML(lblKCode	); }
	public String getEscLblKName() 		{ return escapeHTML(lblKName	); }
	public String getEscLblSection() 	{ return escapeHTML(lblSection	); }
	public String getEscTxtReason() 	{ return escapeHTML(txtReason	); }
	public String getEscLblApprover() 	{ return escapeHTML(lblApprover	); }
	public String getEscLblStatus() 	{ return escapeHTML(lblStatus	); }

	public void setLblApprover		(String lblApprover		) { this.lblApprover 		= lblApprover		; }
	public void setPltRequestDay	(String pltRequestDay	) { this.pltRequestDay 		= pltRequestDay		; }
	public void setPltRequestHour	(String pltRequestHour	) { this.pltRequestHour 	= pltRequestHour	; }
	public void setPltRequestMin	(String pltRequestMin	) { this.pltRequestMin 		= pltRequestMin		; }
	public void setPltRequestMonth	(String pltRequestMonth	) { this.pltRequestMonth 	= pltRequestMonth	; }
	public void setPltRequestYear	(String pltRequestYear	) { this.pltRequestYear 	= pltRequestYear	; }
	public void setTxtReason		(String txtReason		) { this.txtReason 			= txtReason			; }

	public void setLblKCode	(String lblKCode	) { this.lblKCode 		= lblKCode		; }
	public void setLblKName	(String lblKName	) { this.lblKName 		= lblKName		; }
	public void setLblSection	(String lblSection	) { this.lblSection 	= lblSection	; }
	public void setLblStatus	(String lblStatus	) { this.lblStatus 		= lblStatus		; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
