/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.workflow.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.DatePart;
import jp.mosp.common.part.KintaiApprovalPart;
import jp.mosp.common.part.StringPart;

import jp.mosp.workflow.dto.CtOvertimeRequestDto;
import jp.mosp.workflow.dto.OverTimeRequestDto;
import jp.mosp.workflow.vo.OverTimeRequestListVo;

public class OverTimeRequestListAction extends MosPWorkflowAction {

	// R}h
	private static final String CMD_LIST_SHOW 		= "K1410";
	private static final String CMD_LIST_SEARCH 		= "K1411";
	public  static final String CMD_LIST_RE_SEARCH 	= "K1412";
	private static final String CMD_LIST_SORT 		= "K1413";

	/**
	 * RXgN^
	 */
	public OverTimeRequestListAction() {
		super();
	}

	public void action() throws Exception {
		// VȌ
		OverTimeRequestListVo vo = (OverTimeRequestListVo) prepareVo();
		// v_E̐ݒ
		setPulldownList(vo);
		// [U̐ݒ
		getInfo(user.getUserId());
		vo.setLblSection(getSectionName(mKihon.getSCode()));
		// R}h̏
		if (cmd.equals(CMD_LIST_SHOW)) {
			Date todayDate = DatePart.getSystemDate();
			vo.setPltYear(String.valueOf(MospUtility.getYear(todayDate)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(todayDate)));
			// 
			search(vo);
		} else if (cmd.equals(CMD_LIST_SEARCH)) {
			vo.setParams(request);
			// 
			search(vo);
		} else if (cmd.equals(CMD_LIST_RE_SEARCH)) {
			// Č
			session.removeAttribute(MospConst.ATT_DTO);
			searchRequestList(vo);
			vo.setPageButton();
			sortList(vo);
		} else if (cmd.equals(CMD_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	protected OverTimeRequestListVo getSpecificVo() {
		return new OverTimeRequestListVo();
	}

	/**
	 * v_E̐ݒ
	 * @param vo		ΏVO
	 */
	private void setPulldownList(OverTimeRequestListVo vo) {
		vo.aryPltYear = StringPart.getYearArray(MospUtility.getYear(DatePart.getSystemDate()));
		vo.aryPltMonth = StringPart.getMonthArray();
	}

	/**
	 * 
	 * @param vo
	 * @throws Exception
	 */
	private void search(OverTimeRequestListVo vo) throws Exception {
		// ɂꗗ擾
		searchRequestList(vo);
		vo.setFormerKey(vo.KEY_WORK_DATE);
		vo.setIsAscending(true);
		vo.initListInfo();
	}

	/**
	 * ɂꗗݒ
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	private void searchRequestList(OverTimeRequestListVo vo) throws Exception {
		// JnN
		Date startDate = DatePart.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth());
		// IN
		Date endDate = DatePart.getLastDateOfMonth(vo.getPltYear(), vo.getPltMonth());
		// \ꗗ
		List<CtOvertimeRequestDto> overList = overRequestDao().findForCondition(
				mKihon.getKCode(),
				DatePart.convDateFormattedByHyphen(startDate),
				DatePart.convDateFormattedByHyphen(endDate)
		);
		// \ꗗ
		List<OverTimeRequestDto> listRequest = new ArrayList<OverTimeRequestDto>();
		for (Iterator iter = overList.iterator(); iter.hasNext();) {
			CtOvertimeRequestDto requestDto = (CtOvertimeRequestDto) iter.next();
			OverTimeRequestDto dto = new OverTimeRequestDto(requestDto);
			// F
			dto.setApprovalStatus(getApprovalName(toKintaiApprovalStatus(dto.getWorkflow())));
			// FҖ
			String approverName = "";
			if (KintaiApprovalPart.is1stApproved(toKintaiApprovalStatus(dto.getWorkflow()))
					|| KintaiApprovalPart.is2ndApproved(toKintaiApprovalStatus(dto.getWorkflow()))
			) {
				approverName = getKName(getWorkflowDto(dto.getWorkflow()).getUpdateUser());
			}
			dto.setApproverName(approverName);
			listRequest.add(dto);
		}
		// VOɃZbg
		vo.setFields(listRequest);
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryOverTime().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, OverTimeRequestListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(OverTimeRequestListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, OverTimeRequestListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_WORK_DATE)) {
			comp = new CompWorkDate();
		} else if (key.equals(vo.KEY_REQUEST_DATE)) {
			comp = new CompRequestDate();
		} else if (key.equals(vo.KEY_STATUS)) {
			comp = new CompStatus();
		} else if (key.equals(vo.KEY_APPROVER)) {
			comp = new CompApprover();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * ΖɂrNX
	 */
	protected static class CompWorkDate implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 9136870178985992803L;
		public int compare(Object obj1, Object obj2) {
			OverTimeRequestDto dto1 = (OverTimeRequestDto)obj1;
			OverTimeRequestDto dto2 = (OverTimeRequestDto)obj2;
			return dto1.getWorkDate().compareTo(dto2.getWorkDate());
		}
	}

	/**
	 * \ɂrNX
	 */
	protected static class CompRequestDate implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 818289320529127227L;
		public int compare(Object obj1, Object obj2) {
			OverTimeRequestDto dto1 = (OverTimeRequestDto)obj1;
			OverTimeRequestDto dto2 = (OverTimeRequestDto)obj2;
			return dto1.getRequestDate().compareTo(dto2.getRequestDate());
		}
	}

	/**
	 * F󋵂ɂrNX
	 */
	protected static class CompStatus implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 7143311063774870712L;
		public int compare(Object obj1, Object obj2) {
			OverTimeRequestDto dto1 = (OverTimeRequestDto)obj1;
			OverTimeRequestDto dto2 = (OverTimeRequestDto)obj2;
			return dto1.getApprovalStatus().compareTo(dto2.getApprovalStatus());
		}
	}

	/**
	 * F󋵂ɂrNX
	 */
	protected static class CompApprover implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = 1923632050645529241L;
		public int compare(Object obj1, Object obj2) {
			OverTimeRequestDto dto1 = (OverTimeRequestDto)obj1;
			OverTimeRequestDto dto2 = (OverTimeRequestDto)obj2;
			return dto1.getApproverName().compareTo(dto2.getApproverName());
		}
	}

}
