/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospException;
import jp.mosp.system.dto.MKaisyaDto;

public class KaisyaMasterListVo extends MosPVo {

	private static final long serialVersionUID = -912308350054852945L;

	// URLACSS
	private static final String RETURN_URL	= "/jsp/system/kaisyaMasterList.jsp";
	private static final String EXTRA_JS		= "/pub/system/js/kaisyaMasterList.js";
	private static final String EXTRA_CSS		= "/pub/system/css/kaisyaMasterList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_COMPANY_MASTER;

	//萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	// p[^
	public static final String PRM_TXT_JCODE		= "txtJCode";
	public static final String PRM_TXT_KAIMEI		= "txtKaiMei";

	// tB[h
	private String[]	aryJCode;
	private String[]	aryKaimei;
	private String 		txtJCode;
	private String		txtKaiMei;

	// tB[hyѐ
	public static final String NAM_JCODE	= CommonConst.NAM_OFFICE + CommonConst.NAM_COMMON_CODE;
	public static final String NAM_KAIMEI	= CommonConst.NAM_COMMON_MEISYO;

	public static final int	LEN_JCODE	= 10;
	public static final int	LEN_KAIMEI	= 50;

	// \[gL[
	public final String KEY_JCODE			= "keyJCode";
	public final String KEY_KAIMEI			= "keyKaimei";

	// [h(0FȂA1F)
	private int searchmode;

	public KaisyaMasterListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		aryJCode 		= new String[0];
		aryKaimei 		= new String[0];
		txtJCode 		= "";
		txtKaiMei 		= "";
		setFormerKey(KEY_JCODE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtJCode 		= request.getParameter(PRM_TXT_JCODE);
		txtKaiMei 		= request.getParameter(PRM_TXT_KAIMEI);
	}

	/**
	 * tB[hݒ
	 * @param listJigyousyo ƏXg
	 * @throws MospException
	 */
	public void setFields(List listJigyousyo) throws MospException {
		// Xg̐ݒ
		list = listJigyousyo;
		// f[^̎擾
		count = listJigyousyo.size();
		// z̏
		aryJCode	= new String[count];
		aryKaimei	= new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listJigyousyo.iterator();
		while (it.hasNext()) {
			MKaisyaDto dto = (MKaisyaDto)it.next();
			aryJCode[i] = escapeHTML(dto.getId());
			aryKaimei[i] = escapeHTML(dto.getKaiMei());
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[] getEscAryJCode		() { return aryJCode.clone()		; }
	public String[] getEscAryKaimei		() { return aryKaimei.clone()		; }

	public String getTxtJCode			() { return txtJCode 				; }
	public String getTxtKaiMei			() { return txtKaiMei				; }	

	public String getEscTxtJCode		() { return escapeHTML(txtJCode)	; }
	public String getEscTxtKaiMei		() { return escapeHTML(txtKaiMei)	; }

	public void setSearchmode	(int searchmode) 	{ this.searchmode = searchmode; }
	public int getSearchmode	() 					{ return searchmode; }

}
