/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.dto.CmUserDto;

public class AccountMasterListVo extends MosPVo {

	private static final long serialVersionUID = 445388768524423342L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/system/accountMasterList.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/accountMasterList.js";
	private static final String EXTRA_CSS  = "/pub/system/css/accountMasterList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_ACCOUNT_MASTER;

	//萔
	public static final int SEARCH_OFF 	= 0;
	public static final int SEARCH_ON  	= 1;
	public static final int MODE_INSERT 	= 0;
	public static final int MODE_VIEW 	= 1;

	// p[^
	public static final String PRM_TXT_USER_ID   = "txtUserId";
	public static final String PRM_TXT_USER_NAME = "txtUserName";
	public static final String PRM_PLT_AUTHORITY = "pltAuthority";
	public static final String PRM_PLT_DELETE    = "pltDelete";	

	// tB[h
	private String[] aryUserId;
	private String[] aryUserName;
	private String[] aryAuthority;
	private String[] aryDelete;
	private String   txtUserId;
	private String   txtUserName;
	private String   pltAuthority;
	private String   pltDelete;

	// tB[hyѐ
	public static final String NAM_USER_ID   = CommonConst.NAM_USER_ID;
	public static final String NAM_USER_NAME = CommonConst.NAM_USER_NAME;
	public static final String NAM_AUTHORITY = CommonConst.NAM_AUTHORITY;
	public static final String NAM_DELETE    = CommonConst.NAM_DELETE_FLAG;
	public static final int    LEN_USER_ID   = 10;
	public static final int    LEN_USER_NAME = 16;

	// \[gL[
	public final String KEY_USER_ID   = "keyUserId";
	public final String KEY_USER_NAME = "keyUserName";
	public final String KEY_AUTHORITY = "keyAuthority";
	public final String KEY_DELETE    = "keyDelete";

	// v_EXg
	public String[][] aryPltAuthority;

	// [h(0FVKo^A1:\)
	private int mode;

	/**
	 * RXgN^
	 */
	public AccountMasterListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		txtUserId    = "";
		txtUserName  = "";
		pltAuthority = "";
		pltDelete    = "";
		aryUserId    = new String[0];
		aryUserName  = new String[0];
		aryAuthority = new String[0];
		aryDelete    = new String[0];
		setFormerKey(KEY_USER_ID);
		mode = 0;
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtUserId    = request.getParameter(PRM_TXT_USER_ID);
		txtUserName  = request.getParameter(PRM_TXT_USER_NAME);
		pltAuthority = request.getParameter(PRM_PLT_AUTHORITY);
		pltDelete    = request.getParameter(PRM_PLT_DELETE);
	}

	/**
	 * tB[hݒ
	 * @param listCmUser [U[Xg
	 * @throws MospException
	 */
	public void setFields(List listCmUser) throws MospException {
		// Xg̐ݒ
		list = listCmUser;
		// f[^̎擾
		count = listCmUser.size();
		// z̏
		aryUserId    = new String[count];
		aryUserName  = new String[count];
		aryAuthority = new String[count];
		aryDelete    = new String[count];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listCmUser.iterator();
		while (it.hasNext()) {
			CmUserDto dto   = (CmUserDto)it.next();
			aryUserId[i]    = escapeHTML(dto.getUserId());
			aryUserName[i]  = escapeHTML(dto.getUserName());
			aryAuthority[i] = dto.getAuthority();
			aryDelete[i]    = String.valueOf(dto.getDeleteFlag());
			aryAuthority[i] = "";
			for (int j = 0; j < aryPltAuthority.length; j++) {
				if (dto.getAuthority().equals(aryPltAuthority[j][0])) {
					aryAuthority[i] = escapeHTML(aryPltAuthority[j][1]);
					break;
				}
			}
			if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_OFF) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_OFF_NAME);
			} else if (dto.getDeleteFlag() == MospConst.DELETE_FLAG_ON) {
				aryDelete[i] = escapeHTML(MospConst.DELETE_FLAG_ON_NAME);
			} else {
				throw new MospException(MospConst.EX_CM_USER_ILLEGAL);
			}
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String[] getEscAryUserId() 		{ return aryUserId.clone()		; }
	public String[] getEscAryUserName() 	{ return aryUserName.clone()	; }
	public String[] getEscAryAuthority() 	{ return aryAuthority.clone()	; }
	public String[] getEscAryDelete() 		{ return aryDelete.clone()		; }

	public String getTxtUserId() 		{ return txtUserId		; }
	public String getTxtUserName() 		{ return txtUserName	; }
	public String getPltAuthority() 	{ return pltAuthority	; }
	public String getPltDelete() 		{ return pltDelete		; }
	public String getEscTxtUserId() 	{ return escapeHTML(txtUserId)		; }
	public String getEscTxtUserName() 	{ return escapeHTML(txtUserName)	; }
	public void setPltDelete(int pltDelete) { this.pltDelete = String.valueOf(pltDelete); }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
