/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.PartManager;

import jp.mosp.payroll.dao.MKintaiKeisanDao;
import jp.mosp.payroll.dto.MKintaiKeisanDto;

import jp.mosp.system.vo.KeisanInformationCardVo;

public class KeisanInformationCardAction extends MosPAction {

	// R}h
	private static final String CMD_KEISAN_INFO_SHOW 		= "S1100";	//\
	private static final String CMD_KEISAN_INFO_UPDATE	= "S1108";	//XV

	// tB[h
	protected MKintaiKeisanDto dto;

	/**
	 * RXgN^
	 */
	public KeisanInformationCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// vZǗmF
		confirmCalculateAuth();
		// VO̎擾yѐݒ
		KeisanInformationCardVo vo = getInitVo();
		init(vo);
		// R}h̏
		if (cmd.equals(CMD_KEISAN_INFO_SHOW)) {
			// \
			show(vo);
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else if (cmd.equals(CMD_KEISAN_INFO_UPDATE)){
			// XV
			vo.setParams(request);
			update(vo);
			// \
			show(vo);
			session.setAttribute(MospConst.ATT_DTO, dto);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * VOCX^X擾
	 * @return	VO
	 */
	protected KeisanInformationCardVo getInitVo() {
		return new KeisanInformationCardVo();
	}

	/**
	 * Action
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	protected void init(KeisanInformationCardVo vo) throws Exception {
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.setParams(request);
		// VOyуtH[h̏
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DTO̎擾
		Object obj = session.getAttribute(MospConst.ATT_DTO);
		dto = obj instanceof MKintaiKeisanDto ? (MKintaiKeisanDto)obj : null;
		// v_ẼZbg
		vo.aryPltMonth 			= util.getMonthArray();
		vo.aryPltDays 			= util.getDayArray();
		vo.aryPltCompleteFlag 	= setPltCompleteFlag();
	}

	/**
	 * ݒ荀ڌ
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	protected void show(KeisanInformationCardVo vo) throws Exception {
		// DTȌ
		dto = PartManager.calculate(partInfo()).findForCalc();
		if (chkExistDto(dto)) {
			//	dtoAdtoVoɃZbgB
			vo.setFields(dto);
		} else {
			// ȂAݒ肳ꂽNꂼ̔NtB[hɃZbgB
			// ΑӌvZݒA^vZݒ
			vo.setFields(getCalcMonth(), getCalcPayment(getCalcMonth()));
		}
		// [hݒ
		vo.setMode(KeisanInformationCardVo.MODE_UPDATE);
	}

	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @throws Exception
	 */
	protected void update(KeisanInformationCardVo vo) throws Exception {
		// p[^̑ÓmF
		vo.validate();
		// DAȌ
		MKintaiKeisanDao dao = new MKintaiKeisanDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// DTȌ
		if (dto == null) {
			dto = new MKintaiKeisanDto();
		}
		// XVOdto݂邩ǂ`FbN
		MKintaiKeisanDto currentDto = dao.findForUpdate(String.valueOf(dto.getKTNen()));
		if (chkExistDto(currentDto)) {
			// 폜
			dao.delete(currentDto);
		}
		vo.setDtoFields(dto);
		// o^	
		dao.insert(dto);
		// DTO̍Ď擾
		MKintaiKeisanDto retDto = dao.findForKey(String.valueOf(dto.getKTNen()));		
		chkUpdate(retDto);
		// ZbVpDTOɃZbg
		dto = retDto;
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		// R~bg
		commit();			
	}	

	/**
	 * vZ󋵃tOv_E
	 * @return	aryPltCompleteFlag
	 * @throws Exception
	 */
	protected String[][] setPltCompleteFlag() throws Exception {
		String[][] aryPltCompleteFlag = new String[2][2];
		aryPltCompleteFlag[0][0] = CommonConst.NUM_ATT_CALCULATE_COMPLETE_FLAG_OFF;
		aryPltCompleteFlag[0][1] = CommonConst.NAM_ATT_CALCULATE_COMPLETE_FLAG_OFF;
		aryPltCompleteFlag[1][0] = CommonConst.NUM_ATT_CALCULATE_COMPLETE_FLAG_ON;
		aryPltCompleteFlag[1][1] = CommonConst.NAM_ATT_CALCULATE_COMPLETE_FLAG_ON;
		return aryPltCompleteFlag;
	}

}
